/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.raw.RawResourceData;
import org.pentaho.reporting.libraries.xmlns.parser.LoggingErrorHandler;
import org.pentaho.reporting.libraries.xmlns.parser.MultiplexRootElementHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ResourceDataInputSource;
import org.pentaho.reporting.libraries.xmlns.parser.XmlFactoryModule;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractXmlResourceFactory
implements ResourceFactory {
    private static final Log logger = LogFactory.getLog(AbstractXmlResourceFactory.class);
    public static final String CONTENTBASE_KEY = "content-base";
    private static final byte[] EMPTY_DATA = new byte[0];
    private ArrayList modules = new ArrayList();
    private SAXParserFactory factory;

    protected AbstractXmlResourceFactory() {
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
        }
        return this.factory.newSAXParser();
    }

    protected void configureReader(XMLReader xMLReader, MultiplexRootElementHandler multiplexRootElementHandler) {
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", multiplexRootElementHandler.getCommentHandler());
        }
        catch (SAXException sAXException) {
            logger.debug((Object)"Comments are not supported by this SAX implementation.");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (SAXException sAXException) {
            multiplexRootElementHandler.setXmlnsUrisNotAvailable(true);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            logger.warn((Object)"No Namespace features will be available. (Yes, this is serious)");
        }
    }

    public Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceCreationException, ResourceLoadingException {
        try {
            Object object2;
            long l;
            ResourceKey resourceKey2;
            SAXParser sAXParser = this.getParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            XmlFactoryModule[] xmlFactoryModuleArray = this.getModules();
            if (xmlFactoryModuleArray.length == 0) {
                throw new ResourceCreationException("There are no root-handlers registered for the factory for type " + this.getFactoryType());
            }
            ResourceDataInputSource resourceDataInputSource = new ResourceDataInputSource(resourceData, resourceManager);
            ResourceKey resourceKey3 = resourceData.getKey();
            if (resourceKey == null) {
                resourceKey2 = resourceKey3;
                l = resourceData.getVersion(resourceManager);
            } else {
                resourceKey2 = resourceKey;
                l = -1L;
            }
            MultiplexRootElementHandler multiplexRootElementHandler = new MultiplexRootElementHandler(resourceManager, resourceKey3, resourceKey2, l, xmlFactoryModuleArray);
            DefaultConfiguration defaultConfiguration = multiplexRootElementHandler.getParserConfiguration();
            URL uRL = resourceManager.toURL(resourceKey2);
            if (uRL != null) {
                defaultConfiguration.setConfigProperty(CONTENTBASE_KEY, uRL.toExternalForm());
            }
            this.configureReader(xMLReader, multiplexRootElementHandler);
            xMLReader.setContentHandler(multiplexRootElementHandler);
            xMLReader.setDTDHandler(multiplexRootElementHandler);
            xMLReader.setEntityResolver(multiplexRootElementHandler.getEntityResolver());
            xMLReader.setErrorHandler(this.getErrorHandler());
            Map map = resourceKey3.getFactoryParameters();
            for (Object object2 : map.keySet()) {
                if (!(object2 instanceof FactoryParameterKey)) continue;
                FactoryParameterKey factoryParameterKey = (FactoryParameterKey)object2;
                multiplexRootElementHandler.setHelperObject(factoryParameterKey.getName(), map.get(factoryParameterKey));
            }
            xMLReader.parse(resourceDataInputSource);
            object2 = this.finishResult(multiplexRootElementHandler.getResult(), resourceManager, resourceData, resourceKey2);
            multiplexRootElementHandler.getDependencyCollector().add(resourceKey3, resourceData.getVersion(resourceManager));
            return this.createResource(resourceKey3, multiplexRootElementHandler, object2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ResourceCreationException("Unable to parse the document: " + resourceData.getKey(), (Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new ResourceLoadingException("Unable to read the stream from document: " + resourceData.getKey(), (Exception)iOException);
        }
    }

    public Object parseDirectly(ResourceManager resourceManager, InputSource inputSource, ResourceKey resourceKey, Map map) throws ResourceKeyCreationException, ResourceCreationException, ResourceLoadingException {
        try {
            SAXParser sAXParser = this.getParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            XmlFactoryModule[] xmlFactoryModuleArray = this.getModules();
            ResourceKey resourceKey2 = resourceManager.createKey((Object)EMPTY_DATA);
            ResourceKey resourceKey3 = resourceKey == null ? resourceKey2 : resourceKey;
            MultiplexRootElementHandler multiplexRootElementHandler = new MultiplexRootElementHandler(resourceManager, resourceKey2, resourceKey3, -1L, xmlFactoryModuleArray);
            DefaultConfiguration defaultConfiguration = multiplexRootElementHandler.getParserConfiguration();
            URL uRL = resourceManager.toURL(resourceKey3);
            if (uRL != null) {
                defaultConfiguration.setConfigProperty(CONTENTBASE_KEY, uRL.toExternalForm());
            }
            this.configureReader(xMLReader, multiplexRootElementHandler);
            xMLReader.setContentHandler(multiplexRootElementHandler);
            xMLReader.setDTDHandler(multiplexRootElementHandler);
            xMLReader.setEntityResolver(multiplexRootElementHandler.getEntityResolver());
            xMLReader.setErrorHandler(this.getErrorHandler());
            for (Object k : map.keySet()) {
                if (!(k instanceof FactoryParameterKey)) continue;
                FactoryParameterKey factoryParameterKey = (FactoryParameterKey)k;
                multiplexRootElementHandler.setHelperObject(factoryParameterKey.getName(), map.get(factoryParameterKey));
            }
            xMLReader.parse(inputSource);
            return this.finishResult(multiplexRootElementHandler.getResult(), resourceManager, (ResourceData)new RawResourceData(resourceKey2), resourceKey3);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ResourceCreationException("Unable to parse the document", (Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new ResourceLoadingException("Unable to read the stream", (Exception)iOException);
        }
    }

    private XmlFactoryModule[] getModules() {
        return this.modules.toArray(new XmlFactoryModule[this.modules.size()]);
    }

    protected Resource createResource(ResourceKey resourceKey, MultiplexRootElementHandler multiplexRootElementHandler, Object object) {
        return new CompoundResource(resourceKey, multiplexRootElementHandler.getDependencyCollector(), object);
    }

    protected Object finishResult(Object object, ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceCreationException, ResourceLoadingException {
        return object;
    }

    protected abstract Configuration getConfiguration();

    public void initializeDefaults() {
        String string = this.getFactoryType().getName();
        String string2 = "org.pentaho.reporting.libraries.resourceloader.factory.modules." + string;
        Configuration configuration = this.getConfiguration();
        Iterator iterator = configuration.findPropertyKeys(string2);
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = configuration.getConfigProperty(string3);
            Object object = ObjectUtilities.loadAndInstantiate((String)string4, AbstractXmlResourceFactory.class, XmlFactoryModule.class);
            if (!(object instanceof XmlFactoryModule)) continue;
            this.registerModule((XmlFactoryModule)object);
        }
    }

    public void registerModule(XmlFactoryModule xmlFactoryModule) {
        if (xmlFactoryModule == null) {
            throw new NullPointerException();
        }
        this.modules.add(xmlFactoryModule);
    }

    protected ErrorHandler getErrorHandler() {
        return new LoggingErrorHandler();
    }
}

