/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassQueryTool {
    private static final Log logger = LogFactory.getLog(ClassQueryTool.class);

    protected ClassQueryTool() {
    }

    protected void processEntry(ClassLoader classLoader, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (classLoader == null) {
            throw new NullPointerException();
        }
        if (!string.endsWith(".class")) {
            return;
        }
        String string2 = string.substring(0, string.length() - 6).replace('/', '.');
        if (!this.isValidClass(string2)) {
            return;
        }
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            this.processClass(classLoader, clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable throwable) {
            logger.debug((Object)("At class '" + string2 + "': " + throwable));
        }
    }

    protected boolean isValidClass(String string) {
        return true;
    }

    protected abstract void processClass(ClassLoader var1, Class var2);

    private void processJarFile(ClassLoader classLoader, URL uRL) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                this.processEntry(classLoader, zipEntry.getName());
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            logger.debug((Object)("Caught IO-Exception while processing file " + uRL), (Throwable)iOException);
        }
    }

    public void processDirectory(File file) throws IOException {
        URLClassLoader uRLClassLoader;
        Serializable serializable;
        int n;
        String string;
        Serializable serializable2;
        Serializable[] serializableArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        ArrayList<Serializable> arrayList3 = new ArrayList<Serializable>();
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            serializableArray = stringTokenizer.nextToken();
            File file2 = new File((String)serializableArray);
            serializable2 = file2.getAbsoluteFile();
            if (((File)serializable2).isDirectory() && ((File)serializable2).exists() && ((File)serializable2).canRead()) {
                arrayList.add(((File)serializable2).toURL());
                arrayList3.add(serializable2);
                continue;
            }
            if (!((File)serializable2).isFile() || !((File)serializable2).exists() || !((File)serializable2).canRead() || !(string = ((File)serializable2).getName()).endsWith(".jar") && !string.endsWith(".zip")) continue;
            arrayList.add(((File)serializable2).toURL());
            arrayList2.add(((File)serializable2).toURL());
        }
        if (file != null && file.isDirectory()) {
            serializableArray = file.listFiles();
            for (int i = 0; i < serializableArray.length; ++i) {
                serializable2 = serializableArray[i];
                if (((File)serializable2).isDirectory() && ((File)serializable2).exists() && ((File)serializable2).canRead()) {
                    arrayList.add(((File)serializable2).toURL());
                    arrayList3.add(serializable2);
                    continue;
                }
                if (!((File)serializable2).isFile() || !((File)serializable2).exists() || !((File)serializable2).canRead() || !(string = ((File)serializable2).getName()).endsWith(".jar") && !string.endsWith(".zip")) continue;
                arrayList.add(((File)serializable2).toURL());
                arrayList2.add(((File)serializable2).toURL());
            }
        }
        serializableArray = arrayList2.toArray(new URL[arrayList2.size()]);
        File[] fileArray = arrayList3.toArray(new File[arrayList3.size()]);
        serializable2 = arrayList.toArray(new URL[arrayList.size()]);
        for (n = 0; n < ((Serializable)serializable2).length; ++n) {
            serializable = serializable2[n];
            logger.debug((Object)serializable);
        }
        for (n = 0; n < serializableArray.length; ++n) {
            serializable = serializableArray[n];
            uRLClassLoader = new URLClassLoader((URL[])serializable2);
            this.processJarFile(uRLClassLoader, (URL)serializable);
        }
        for (n = 0; n < fileArray.length; ++n) {
            serializable = fileArray[n];
            uRLClassLoader = new URLClassLoader((URL[])serializable2);
            this.processDirectory(uRLClassLoader, (File)serializable, "");
        }
    }

    private void processDirectory(URLClassLoader uRLClassLoader, File file, String string) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.exists() || !file2.canRead()) continue;
            if (file2.isDirectory()) {
                this.processDirectory(uRLClassLoader, file2, string + file2.getName() + '/');
                continue;
            }
            if (!file2.isFile()) continue;
            this.processEntry(uRLClassLoader, string + file2.getName());
        }
    }
}

