/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.output.text;

import com.sun.star.report.DataSourceFactory;
import com.sun.star.report.ImageService;
import com.sun.star.report.InputRepository;
import com.sun.star.report.OutputRepository;
import com.sun.star.report.pentaho.model.OfficeMasterPage;
import com.sun.star.report.pentaho.model.OfficeMasterStyles;
import com.sun.star.report.pentaho.model.OfficeStyle;
import com.sun.star.report.pentaho.model.OfficeStyles;
import com.sun.star.report.pentaho.model.OfficeStylesCollection;
import com.sun.star.report.pentaho.model.PageSection;
import com.sun.star.report.pentaho.output.OfficeDocumentReportTarget;
import com.sun.star.report.pentaho.output.StyleUtilities;
import com.sun.star.report.pentaho.output.text.MasterPageFactory;
import com.sun.star.report.pentaho.output.text.PageBreakDefinition;
import com.sun.star.report.pentaho.output.text.PageContext;
import com.sun.star.report.pentaho.output.text.VariablesDeclarations;
import com.sun.star.report.pentaho.styles.LengthCalculator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.jfree.report.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class TextRawReportTarget
extends OfficeDocumentReportTarget {
    private static final String ALWAYS = "always";
    private static final String KEEP_TOGETHER = "keep-together";
    private static final String KEEP_WITH_NEXT = "keep-with-next";
    private static final String MAY_BREAK_BETWEEN_ROWS = "may-break-between-rows";
    private static final String NAME = "name";
    private static final String NONE = "none";
    private static final String NORMAL = "normal";
    private static final String PARAGRAPH_PROPERTIES = "paragraph-properties";
    private static final String STANDARD = "Standard";
    private static final String TABLE_PROPERTIES = "table-properties";
    private static final String VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT = "variables_paragraph_with_next";
    private static final String VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT = "variables_paragraph_without_next";
    private static final int TABLE_LAYOUT_VARIABLES_PARAGRAPH = 0;
    private static final int TABLE_LAYOUT_SINGLE_DETAIL_TABLE = 2;
    private static final int CP_SETUP = 0;
    private static final int CP_FIRST_TABLE = 1;
    private static final int CP_NEXT_TABLE = 2;
    private static final int DETAIL_SECTION_WAIT = 0;
    private static final int DETAIL_SECTION_FIRST_STARTED = 1;
    private static final int DETAIL_SECTION_FIRST_PRINTED = 2;
    private static final int DETAIL_SECTION_OTHER_STARTED = 3;
    private static final int DETAIL_SECTION_OTHER_PRINTED = 4;
    private boolean pageFooterOnReportFooter;
    private boolean pageFooterOnReportHeader;
    private boolean pageHeaderOnReportFooter;
    private boolean pageHeaderOnReportHeader;
    private int contentProcessingState;
    private OfficeMasterPage currentMasterPage;
    private final FastStack activePageContext = new FastStack();
    private MasterPageFactory masterPageFactory;
    private LengthCalculator sectionHeight;
    private String variables;
    private PageBreakDefinition pageBreakDefinition;
    private VariablesDeclarations variablesDeclarations;
    private boolean columnBreakPending;
    private boolean sectionKeepTogether;
    private final AttributeNameGenerator sectionNames = new AttributeNameGenerator();
    private int detailBandProcessingState;
    private final int tableLayoutConfig;
    private int expectedTableRowCount;
    private boolean firstCellSeen;

    public TextRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey resourceKey, InputRepository inputRepository, OutputRepository outputRepository, String string, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, resourceKey, inputRepository, outputRepository, string, imageService, dataSourceFactory);
        this.tableLayoutConfig = 2;
    }

    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.text";
    }

    private boolean isPagebreakPending() {
        return this.pageBreakDefinition != null;
    }

    private boolean isResetPageNumber() {
        return this.pageBreakDefinition != null && this.pageBreakDefinition.isResetPageNumber();
    }

    private void setPagebreakDefinition(PageBreakDefinition pageBreakDefinition) {
        this.pageBreakDefinition = pageBreakDefinition;
    }

    private PageBreakDefinition getPagebreakDefinition() {
        return this.pageBreakDefinition;
    }

    private boolean isKeepTableWithNext() {
        int n = this.getCurrentContext().getKeepTogether();
        if (n == 1) {
            return true;
        }
        boolean bl = n == 2 && this.detailBandProcessingState == 0;
        return bl;
    }

    private boolean isSectionPagebreakAfter(AttributeMap attributeMap) {
        Object object = attributeMap.getAttribute("http://openoffice.org/2005/report", "force-new-page");
        return "after-section".equals(object) || "before-after-section".equals(object);
    }

    private boolean isSectionPagebreakBefore(AttributeMap attributeMap) {
        Object object = attributeMap.getAttribute("http://openoffice.org/2005/report", "force-new-page");
        return "before-section".equals(object) || "before-after-section".equals(object);
    }

    private PageContext getCurrentContext() {
        return (PageContext)this.activePageContext.peek();
    }

    private String createMasterPage(boolean bl, boolean bl2) throws ReportProcessingException {
        String string;
        PageContext pageContext = this.getCurrentContext();
        String string2 = bl2 ? pageContext.getPageFooterContent() : null;
        String string3 = bl ? pageContext.getPageHeaderContent() : null;
        if (this.currentMasterPage == null || !this.masterPageFactory.containsMasterPage(STANDARD, string3, string2)) {
            CSSNumericValue cSSNumericValue = pageContext.getAllHeaderSize();
            CSSNumericValue cSSNumericValue2 = pageContext.getAllFooterSize();
            this.currentMasterPage = this.masterPageFactory.createMasterPage(STANDARD, string3, string2);
            OfficeStylesCollection officeStylesCollection = this.getGlobalStylesCollection();
            OfficeMasterStyles officeMasterStyles = officeStylesCollection.getMasterStyles();
            String string4 = this.currentMasterPage.getPageLayout();
            if (string4 == null) {
                String string5 = this.masterPageFactory.createPageStyle(this.getGlobalStylesCollection().getAutomaticStyles(), cSSNumericValue, cSSNumericValue2);
                this.currentMasterPage.setPageLayout(string5);
            } else {
                String string6 = this.masterPageFactory.derivePageStyle(string4, this.getPredefinedStylesCollection().getAutomaticStyles(), this.getGlobalStylesCollection().getAutomaticStyles(), cSSNumericValue, cSSNumericValue2);
                this.currentMasterPage.setPageLayout(string6);
            }
            officeMasterStyles.addMasterPage(this.currentMasterPage);
            string = this.currentMasterPage.getStyleName();
        } else {
            OfficeMasterPage officeMasterPage = this.masterPageFactory.getMasterPage(STANDARD, string3, string2);
            if (ObjectUtilities.equal((Object)officeMasterPage.getStyleName(), (Object)this.currentMasterPage.getStyleName())) {
                string = null;
            } else {
                this.currentMasterPage = officeMasterPage;
                string = this.currentMasterPage.getStyleName();
            }
        }
        if (!bl && pageContext.getHeader() != null || !bl2 && pageContext.getFooter() != null) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        return string;
    }

    private boolean isColumnBreakPending() {
        return this.columnBreakPending;
    }

    private void setColumnBreakPending(boolean bl) {
        this.columnBreakPending = bl;
    }

    private Integer parseInt(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return IntegerCache.getInteger((int)number.intValue());
        }
        if (object instanceof String) {
            try {
                return IntegerCache.getInteger((int)Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private OfficeDocumentReportTarget.BufferState applyColumnsToPageBand(OfficeDocumentReportTarget.BufferState bufferState, int n) throws IOException, ReportProcessingException {
        if (n <= 1) {
            return bufferState;
        }
        this.startBuffering(this.getGlobalStylesCollection(), true);
        XmlWriter xmlWriter = this.getXmlWriter();
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", this.generateSectionStyle(n));
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, this.sectionNames.generateName("Section"));
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "section", attributeList, false);
        for (int i = 0; i < n; ++i) {
            xmlWriter.writeStream(bufferState.getXmlAsReader());
        }
        xmlWriter.writeCloseTag();
        return this.finishBuffering();
    }

    private String generateSectionStyle(int n) {
        Section section;
        OfficeStyles officeStyles = this.getStylesCollection().getAutomaticStyles();
        String string = this.getAutoStyleNameGenerator().generateName("auto_section_style");
        Section section2 = new Section();
        section2.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        section2.setType("section-properties");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", (Object)"transparent");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "dont-balance-text-columns", (Object)"false");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "editable", (Object)"false");
        if (n > 1) {
            section = new Section();
            section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            section.setType("columns");
            section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count", (Object)String.valueOf(n));
            section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-gap", (Object)"0cm");
            section2.addNode((Node)section);
            for (int i = 0; i < n; ++i) {
                Section section3 = new Section();
                section3.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                section3.setType("column");
                section3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "rel-width", (Object)"1*");
                section3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "start-indent", (Object)"0cm");
                section3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "end-indent", (Object)"0cm");
                section.addNode((Node)section3);
            }
        }
        section = new OfficeStyle();
        section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        section.setType("style");
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", NAME, (Object)string);
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", (Object)"section");
        section.addNode((Node)section2);
        officeStyles.addStyle((OfficeStyle)section);
        return string;
    }

    public void startReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        super.startReport(reportStructureRoot);
        this.variablesDeclarations = new VariablesDeclarations();
        this.detailBandProcessingState = 0;
        this.sectionNames.reset();
        this.pageFooterOnReportFooter = false;
        this.pageFooterOnReportHeader = false;
        this.pageHeaderOnReportFooter = false;
        this.pageHeaderOnReportHeader = false;
        this.contentProcessingState = 0;
        this.activePageContext.clear();
        this.activePageContext.push((Object)new PageContext());
        OfficeStylesCollection officeStylesCollection = this.getPredefinedStylesCollection();
        this.masterPageFactory = new MasterPageFactory(officeStylesCollection.getMasterStyles());
        officeStylesCollection.getAutomaticStyles().addStyle(this.createVariablesStyle(true));
        officeStylesCollection.getAutomaticStyles().addStyle(this.createVariablesStyle(false));
    }

    private OfficeStyle createVariablesStyle(boolean bl) {
        OfficeStyle officeStyle = new OfficeStyle();
        officeStyle.setStyleFamily("paragraph");
        if (bl) {
            officeStyle.setStyleName(VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
        } else {
            officeStyle.setStyleName(VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT);
        }
        Section section = new Section();
        section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        section.setType(PARAGRAPH_PROPERTIES);
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", (Object)"transparent");
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-align", (Object)"start");
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, (Object)ALWAYS);
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_TOGETHER, (Object)ALWAYS);
        section.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-align", (Object)"top");
        officeStyle.addNode((Node)section);
        Section section2 = new Section();
        section2.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        section2.setType("text-properties");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-variant", (Object)NORMAL);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-transform", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "color", (Object)"#ffffff");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-outline", (Object)"false");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-blinking", (Object)"false");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-line-through-style", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-line-through-mode", (Object)"continuous");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-position", (Object)"0% 100%");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name", (Object)"Tahoma");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-size", (Object)"1pt");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "letter-spacing", (Object)NORMAL);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "letter-kerning", (Object)"false");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-style", (Object)NORMAL);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-shadow", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-style", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-mode", (Object)"continuous");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-weight", (Object)NORMAL);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-rotation-angle", (Object)"0");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-emphasize", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine-start-char", (Object)"");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine-end-char", (Object)"");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-blinking", (Object)"false");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-scale", (Object)"100%");
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-relief", (Object)NONE);
        section2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-display", (Object)NONE);
        officeStyle.addNode((Node)section2);
        return officeStyle;
    }

    protected void startContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "text", null, false);
        this.writeNullDate();
        this.startBuffering(this.getStylesCollection(), true);
        Object object = attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count");
        Integer n = this.parseInt(object);
        if (n != null) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setColumnCount(n);
        }
    }

    protected void startOther(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        String string = ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attributeMap);
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attributeMap);
        if (ObjectUtilities.equal((Object)"http://jfreereport.sourceforge.net/namespaces/engine", (Object)string)) {
            if (ObjectUtilities.equal((Object)"image", (Object)string2)) {
                this.startImageProcessing(attributeMap);
            } else if (ObjectUtilities.equal((Object)"object-ole", (Object)string2) && this.getCurrentRole() != 11) {
                this.startChartProcessing(attributeMap);
            }
            return;
        }
        if (this.isFilteredNamespace(string)) {
            throw new IllegalStateException("This element should be hidden: " + string + ", " + string2);
        }
        if (this.isTableMergeActive() && this.detailBandProcessingState == 4 && ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)string) && ObjectUtilities.equal((Object)"table-columns", (Object)string2)) {
            this.startBuffering(this.getStylesCollection(), true);
        } else {
            String string3;
            Object object;
            String string4;
            this.openSection();
            boolean bl = ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)string);
            if (bl) {
                if (ObjectUtilities.equal((Object)"table", (Object)string2)) {
                    this.startTable(attributeMap);
                    return;
                }
                if (ObjectUtilities.equal((Object)"table-row", (Object)string2)) {
                    this.startRow(attributeMap);
                    return;
                }
            }
            if (ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:text:1.0", (Object)string)) {
                String string5;
                if (ObjectUtilities.equal((Object)"variable-set", (Object)string2)) {
                    string4 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME);
                    string5 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
                    object = this.variablesDeclarations.produceVariable(string4, string5);
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, object);
                } else if (ObjectUtilities.equal((Object)"variable-get", (Object)string2)) {
                    string4 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME);
                    string5 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
                    object = this.variablesDeclarations.produceVariable(string4, string5);
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, object);
                }
            }
            if (this.tableLayoutConfig == 0 && this.variables != null) {
                StyleUtilities.copyStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
                string4 = this.getXmlWriter();
                string4.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, false);
                string4.writeText(this.variables);
                string4.writeCloseTag();
                this.variables = null;
            }
            if (ReportTargetUtil.isElementOfType((String)"urn:oasis:names:tc:opendocument:xmlns:text:1.0", (String)"p", (AttributeMap)attributeMap)) {
                int n = this.getCurrentContext().getKeepTogether();
                if (!this.firstCellSeen && (this.sectionKeepTogether || n == 1)) {
                    object = null;
                    string3 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name");
                    if (string3 == null) {
                        boolean bl2 = (n == 1 || this.expectedTableRowCount > 0) && this.isParentKeepTogether();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        arrayList.add("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
                        arrayList.add("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
                        arrayList2.add(KEEP_TOGETHER);
                        arrayList3.add(ALWAYS);
                        if (bl2) {
                            arrayList2.add(KEEP_WITH_NEXT);
                            arrayList3.add(ALWAYS);
                        } else {
                            arrayList2.add(KEEP_WITH_NEXT);
                            arrayList3.add(null);
                        }
                        object = StyleUtilities.queryStyleByProperties(this.getStylesCollection(), "paragraph", PARAGRAPH_PROPERTIES, arrayList, arrayList2, arrayList3);
                    }
                    if (object == null) {
                        object = this.deriveStyle("paragraph", string3);
                        Element element = ((OfficeStyle)((Object)object)).getParagraphProperties();
                        if (element == null) {
                            element = new Section();
                            element.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                            element.setType(PARAGRAPH_PROPERTIES);
                            object.addNode((Node)element);
                        }
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_TOGETHER, (Object)ALWAYS);
                        if ((n == 1 || this.expectedTableRowCount > 0) && this.isParentKeepTogether()) {
                            element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, (Object)ALWAYS);
                        }
                    }
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", (Object)((OfficeStyle)((Object)object)).getStyleName());
                }
            }
            if (ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", (Object)string) && ObjectUtilities.equal((Object)"frame", (Object)string2)) {
                String string6 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
                object = this.getPredefinedStylesCollection().getAutomaticStyles().getStyle("graphic", string6);
                if (object != null) {
                    string3 = ((OfficeStyle)((Object)object)).getGraphicProperties();
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-pos", (Object)"from-top");
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-pos", (Object)"from-left");
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-rel", (Object)"paragraph-content");
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-rel", (Object)"paragraph");
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "flow-with-text", (Object)"false");
                    string3.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "ole-draw-aspect", (Object)"1");
                }
            }
            this.performStyleProcessing(attributeMap);
            XmlWriter xmlWriter = this.getXmlWriter();
            object = this.buildAttributeList(attributeMap);
            xmlWriter.writeTag(string, string2, (AttributeList)object, false);
            if (this.tableLayoutConfig != 0 && this.variables != null && !this.isRepeatingSection() && ReportTargetUtil.isElementOfType((String)"urn:oasis:names:tc:opendocument:xmlns:text:1.0", (String)"p", (AttributeMap)attributeMap)) {
                xmlWriter.writeText(this.variables);
                this.variables = null;
            }
        }
    }

    private void startRow(AttributeMap attributeMap) throws IOException, ReportProcessingException {
        this.firstCellSeen = false;
        --this.expectedTableRowCount;
        String string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        CSSNumericValue cSSNumericValue = this.computeRowHeight(string);
        this.sectionHeight.add(cSSNumericValue);
        this.performStyleProcessing(attributeMap);
        AttributeList attributeList = this.buildAttributeList(attributeMap);
        this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attributeList, false);
    }

    private void startTable(AttributeMap attributeMap) throws ReportProcessingException, IOException {
        Object object;
        String string;
        PageBreakDefinition pageBreakDefinition;
        Integer n = (Integer)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "table-row-count");
        this.expectedTableRowCount = n == null ? -1 : n;
        if (this.isSectionPagebreakBefore(attributeMap)) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        String string2 = null;
        int n2 = this.getCurrentRole();
        if (this.contentProcessingState == 1) {
            this.contentProcessingState = 2;
            if (n2 == 1) {
                pageBreakDefinition = new PageBreakDefinition(this.isResetPageNumber());
                string2 = this.createMasterPage(this.pageHeaderOnReportHeader, this.pageFooterOnReportHeader);
                if (string2 == null) {
                    string2 = this.currentMasterPage.getStyleName();
                }
            } else if (n2 == 2) {
                pageBreakDefinition = new PageBreakDefinition(this.isResetPageNumber());
                string2 = this.createMasterPage(this.pageHeaderOnReportFooter, this.pageFooterOnReportFooter);
                if (string2 == null && this.isSectionPagebreakBefore(attributeMap)) {
                    string2 = this.currentMasterPage.getStyleName();
                }
            } else if (n2 == 5 || n2 == 6) {
                pageBreakDefinition = null;
            } else if (this.currentMasterPage == null || this.isPagebreakPending()) {
                string2 = this.createMasterPage(true, true);
                this.setPagebreakDefinition(null);
                if (string2 == null) {
                    string2 = this.currentMasterPage.getStyleName();
                }
                pageBreakDefinition = new PageBreakDefinition(this.isResetPageNumber());
            } else {
                pageBreakDefinition = null;
            }
        } else if (this.isPagebreakPending() && n2 != 5 && n2 != 6) {
            pageBreakDefinition = this.getPagebreakDefinition();
            this.setPagebreakDefinition(null);
            string2 = this.createMasterPage(true, true);
            if (string2 == null || this.isSectionPagebreakBefore(attributeMap)) {
                string2 = this.currentMasterPage.getStyleName();
            }
        } else {
            pageBreakDefinition = null;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        if (this.detailBandProcessingState == 4 && string2 != null) {
            xmlWriter.writeCloseTag();
            this.detailBandProcessingState = 3;
        }
        if (this.tableLayoutConfig == 0 && this.variables != null) {
            Element element;
            OfficeStyle officeStyle;
            if (string2 != null) {
                officeStyle = this.deriveStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
                officeStyle.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", string2);
                if (pageBreakDefinition.isResetPageNumber()) {
                    element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", (Object)"1");
                }
                if (this.isColumnBreakPending()) {
                    element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "break-before", (Object)"column");
                    this.setColumnBreakPending(false);
                }
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", officeStyle.getStyleName(), false);
                string2 = null;
            } else if (this.isColumnBreakPending()) {
                this.setColumnBreakPending(false);
                officeStyle = this.deriveStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
                element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", (Object)"1");
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", officeStyle.getStyleName(), false);
            } else {
                StyleUtilities.copyStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, false);
            }
            xmlWriter.writeText(this.variables);
            xmlWriter.writeCloseTag();
            this.variables = null;
        }
        boolean bl = this.isKeepTableWithNext();
        boolean bl2 = "true".equals(attributeMap.getAttribute("http://openoffice.org/2005/report", KEEP_TOGETHER));
        boolean bl3 = this.isTableMergeActive();
        boolean bl4 = this.sectionKeepTogether = bl3 && bl2;
        if (string2 != null || !bl3 && (bl2 || bl) || this.isColumnBreakPending()) {
            Element element;
            string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            object = this.deriveStyle("table", string);
            if (string2 != null) {
                object.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", (Object)string2);
                if (pageBreakDefinition.isResetPageNumber()) {
                    element = this.produceFirstChild((Section)object, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", (Object)"1");
                }
            }
            if (this.isColumnBreakPending()) {
                element = this.produceFirstChild((Section)object, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "break-before", (Object)"column");
                this.setColumnBreakPending(false);
            }
            if (!bl3) {
                if (bl2) {
                    element = this.produceFirstChild((Section)object, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                    element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, (Object)"false");
                }
            } else if (this.detailBandProcessingState == 0) {
                this.detailBandProcessingState = 1;
            } else if (this.detailBandProcessingState == 2) {
                this.detailBandProcessingState = 3;
            }
            if (bl) {
                boolean bl5 = true;
                if (n2 == 4) {
                    bl5 = this.isParentKeepTogether();
                }
                Element element2 = this.produceFirstChild((Section)object, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                element2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, (Object)"false");
                if (bl5) {
                    element2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, (Object)ALWAYS);
                }
            }
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)((OfficeStyle)((Object)object)).getStyleName());
        } else {
            if (bl3) {
                if (this.detailBandProcessingState == 4) {
                    return;
                }
                if (this.detailBandProcessingState == 0) {
                    if (bl) {
                        string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                        object = this.deriveStyle("table", string);
                        Element element = this.produceFirstChild((Section)object, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, (Object)"false");
                        String string3 = (String)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "has-group-footer");
                        if (string3 != null && string3.equals("true")) {
                            element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, (Object)ALWAYS);
                        }
                        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)((OfficeStyle)((Object)object)).getStyleName());
                    }
                    this.detailBandProcessingState = 1;
                } else if (this.detailBandProcessingState == 2) {
                    this.detailBandProcessingState = 3;
                }
            }
            this.performStyleProcessing(attributeMap);
        }
        string = ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attributeMap);
        object = ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attributeMap);
        AttributeList attributeList = this.buildAttributeList(attributeMap);
        xmlWriter.writeTag(string, (String)object, attributeList, false);
    }

    private boolean isParentKeepTogether() {
        PageContext pageContext = this.getCurrentContext();
        if (pageContext != null && (pageContext = pageContext.getParent()) != null) {
            return pageContext.getKeepTogether() == 1;
        }
        return false;
    }

    private boolean isTableMergeActive() {
        return this.getCurrentRole() == 9 && this.tableLayoutConfig == 2;
    }

    private void openSection() throws IOException {
        if (this.isRepeatingSection()) {
            return;
        }
        if (this.getCurrentRole() == 11 || this.getCurrentRole() == 12 || this.getCurrentRole() == 13) {
            return;
        }
        PageContext pageContext = this.getCurrentContext();
        Integer n = pageContext.getColumnCount();
        if (n != null && !pageContext.isSectionOpen()) {
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", this.generateSectionStyle(n));
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, this.sectionNames.generateName("Section"));
            this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "section", attributeList, false);
            pageContext.setSectionOpen(true);
        }
    }

    protected void startReportSection(AttributeMap attributeMap, int n) throws IOException, DataSourceException, ReportProcessingException {
        this.sectionHeight = new LengthCalculator();
        if (n == 11 || n == 12 || n == 13) {
            this.startBuffering(new OfficeStylesCollection(), true);
        } else if (n == 7) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
            this.pageHeaderOnReportHeader = PageSection.isPrintWithReportHeader(attributeMap);
            this.pageHeaderOnReportFooter = PageSection.isPrintWithReportFooter(attributeMap);
        } else if (n == 8) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
            this.pageFooterOnReportHeader = PageSection.isPrintWithReportHeader(attributeMap);
            this.pageFooterOnReportFooter = PageSection.isPrintWithReportFooter(attributeMap);
        } else if (n == 5 || n == 6) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
        } else if (n == 10) {
            this.startBuffering(this.getGlobalStylesCollection(), false);
        } else {
            this.contentProcessingState = 1;
            if (n == 3 || n == 4) {
                this.startBuffering(this.getContentStylesCollection(), true);
            }
            if (n != 9) {
                this.detailBandProcessingState = 0;
            }
        }
    }

    protected void startGroup(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        Object object;
        Object object2;
        super.startGroup(attributeMap);
        PageContext pageContext = new PageContext(this.getCurrentContext());
        this.activePageContext.push((Object)pageContext);
        Object object3 = attributeMap.getAttribute("http://openoffice.org/2005/report", "reset-page-number");
        if ("true".equals(object3)) {
            this.setPagebreakDefinition(new PageBreakDefinition(true));
        }
        if ("whole-group".equals(object2 = attributeMap.getAttribute("http://openoffice.org/2005/report", KEEP_TOGETHER))) {
            pageContext.setKeepTogether(1);
        } else if ("with-first-detail".equals(object2) && pageContext.getKeepTogether() != 1) {
            pageContext.setKeepTogether(2);
        }
        Object object4 = attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count");
        Integer n = this.parseInt(object4);
        if (n != null) {
            pageContext.setColumnCount(n);
        }
        if ("true".equals(object = attributeMap.getAttribute("http://openoffice.org/2005/report", "start-new-column"))) {
            this.setColumnBreakPending(true);
        }
    }

    protected void startGroupInstance(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (this.getGroupContext().isGroupWithRepeatingSection()) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
    }

    protected void endGroup(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (this.getGroupContext().isGroupWithRepeatingSection()) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        super.endGroup(attributeMap);
        this.finishSection();
        this.activePageContext.pop();
    }

    private void finishSection() throws ReportProcessingException {
        PageContext pageContext = this.getCurrentContext();
        if (pageContext.isSectionOpen()) {
            pageContext.setSectionOpen(false);
            try {
                this.getXmlWriter().writeCloseTag();
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("IOError", (Exception)iOException);
            }
        }
    }

    protected void endReportSection(AttributeMap attributeMap, int n) throws IOException, DataSourceException, ReportProcessingException {
        if (n == 11 || n == 12 || n == 13) {
            this.finishBuffering();
            return;
        }
        CSSNumericValue cSSNumericValue = this.sectionHeight.getResult();
        if (n == 7) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setHeader(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), cSSNumericValue);
        } else if (n == 8) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setFooter(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), cSSNumericValue);
        } else if (n == 5) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setHeader(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), cSSNumericValue);
        } else if (n == 6) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setFooter(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), cSSNumericValue);
        } else if (n == 10) {
            this.variables = this.variables == null ? this.finishBuffering().getXmlBuffer() : this.variables + this.finishBuffering().getXmlBuffer();
        } else if (n == 3) {
            String string = this.finishBuffering().getXmlBuffer();
            int n2 = this.getGroupContext().getParent().getIterationCount();
            boolean bl = "true".equals(attributeMap.getAttribute("http://openoffice.org/2005/report", "repeat-section"));
            if (!bl || n2 > 0) {
                this.getXmlWriter().writeText(string);
            }
        } else if (n == 4) {
            String string = this.finishBuffering().getXmlBuffer();
            this.getXmlWriter().writeText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        block5: {
            super.endReport(reportStructureRoot);
            this.variablesDeclarations = null;
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
                attributeList.addNamespaceDeclaration("config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
                attributeList.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
                OutputStream outputStream = this.getOutputRepository().createOutputStream("settings.xml", "text/xml");
                XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)this.createTagDescription());
                xmlWriter.setAlwaysAddNamespace(true);
                xmlWriter.writeXmlDeclaration("UTF-8");
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-settings", attributeList, false);
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "settings", false);
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item-set", NAME, "ooo:configuration-settings", false);
                AttributeList attributeList2 = new AttributeList();
                attributeList2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:config:1.0", NAME, "TableRowKeep");
                attributeList2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "type", "boolean");
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item", attributeList2, false);
                xmlWriter.writeText("true");
                xmlWriter.writeCloseTag();
                xmlWriter.writeCloseTag();
                xmlWriter.writeCloseTag();
                xmlWriter.writeCloseTag();
                xmlWriter.close();
                if (!this.getInputRepository().isReadable("meta.xml")) break block5;
                InputStream inputStream = this.getInputRepository().createInputStream("meta.xml");
                try {
                    OutputStream outputStream2 = this.getOutputRepository().createOutputStream("meta.xml", "text/xml");
                    IOUtils.getInstance().copyStreams(inputStream, outputStream2);
                    outputStream2.close();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed to write settings document");
            }
        }
    }

    protected void endOther(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        String string = ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attributeMap);
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attributeMap);
        boolean bl = ObjectUtilities.equal((Object)"http://jfreereport.sourceforge.net/namespaces/engine", (Object)string);
        boolean bl2 = ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)string);
        if (this.isTableMergeActive() && this.detailBandProcessingState == 4 && bl2 && ObjectUtilities.equal((Object)"table-columns", (Object)string2)) {
            this.finishBuffering();
            return;
        }
        if (bl && (ObjectUtilities.equal((Object)"image", (Object)string2) || ObjectUtilities.equal((Object)"object-ole", (Object)string2))) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        if (this.tableLayoutConfig != 0 && bl2 && ObjectUtilities.equal((Object)"table-cell", (Object)string2) && !this.isRepeatingSection() && this.variables != null) {
            String string3 = this.sectionKeepTogether && this.expectedTableRowCount > 0 ? VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT : VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT;
            StyleUtilities.copyStyle("paragraph", string3, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", string3, false);
            xmlWriter.writeText(this.variables);
            xmlWriter.writeCloseTag();
            this.variables = null;
        }
        if (bl2 && (ObjectUtilities.equal((Object)"table-cell", (Object)string2) || ObjectUtilities.equal((Object)"covered-table-cell", (Object)string2))) {
            this.firstCellSeen = true;
        }
        if (bl2 && ObjectUtilities.equal((Object)"table", (Object)string2)) {
            if (this.getCurrentRole() == 9) {
                if (!this.isTableMergeActive()) {
                    xmlWriter.writeCloseTag();
                } else if (this.detailBandProcessingState == 1) {
                    int n = this.getCurrentContext().getKeepTogether();
                    if (n == 2) {
                        xmlWriter.writeCloseTag();
                        this.detailBandProcessingState = 2;
                    } else {
                        this.detailBandProcessingState = 4;
                    }
                } else if (this.detailBandProcessingState == 3) {
                    this.detailBandProcessingState = 4;
                }
            } else {
                xmlWriter.writeCloseTag();
            }
            if (this.isSectionPagebreakAfter(attributeMap)) {
                this.setPagebreakDefinition(new PageBreakDefinition(false));
            }
        } else {
            xmlWriter.writeCloseTag();
        }
    }

    protected void endGroupBody(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (this.tableLayoutConfig == 2 && this.detailBandProcessingState == 4) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            this.detailBandProcessingState = 0;
        }
    }

    protected void endContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        this.finishSection();
        OfficeDocumentReportTarget.BufferState bufferState = this.finishBuffering();
        XmlWriter xmlWriter = this.getXmlWriter();
        Map map = this.variablesDeclarations.getDefinedMappings();
        if (!map.isEmpty()) {
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "variable-decls", false);
            for (Map.Entry entry : map.entrySet()) {
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, (String)entry.getKey());
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (String)entry.getValue());
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "variable-decl", attributeList, true);
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeStream(bufferState.getXmlAsReader());
        xmlWriter.setLineEmpty(true);
        xmlWriter.writeCloseTag();
    }

    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.text";
    }
}

