/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.cache;

import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class FirstLevelFontCache
implements FontCache {
    private HashMap backend;
    private FontCache secondLevelCache;

    public FirstLevelFontCache(FontCache fontCache) {
        this.secondLevelCache = fontCache;
        this.backend = new HashMap();
    }

    public FontMetrics getFontMetrics(FontKey fontKey) {
        FontMetrics fontMetrics = (FontMetrics)this.backend.get(fontKey);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        if (this.secondLevelCache == null) {
            return null;
        }
        FontMetrics fontMetrics2 = this.secondLevelCache.getFontMetrics(fontKey);
        if (fontMetrics2 != null) {
            this.backend.put(fontKey.clone(), fontMetrics2);
            return fontMetrics2;
        }
        return null;
    }

    public void putFontMetrics(FontKey fontKey, FontMetrics fontMetrics) {
        this.backend.put(fontKey, fontMetrics);
        if (this.secondLevelCache != null) {
            this.secondLevelCache.putFontMetrics(fontKey, fontMetrics);
        }
    }

    public void commit() {
        this.backend.clear();
        this.secondLevelCache = null;
    }
}

