/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;

public class EncodingFactory
implements ResourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceCreationException, ResourceLoadingException {
        SimpleResource simpleResource;
        InputStream inputStream = resourceData.getResourceAsStream(resourceManager);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            Object object = objectInputStream.readObject();
            if (!(object instanceof External8BitEncodingData)) {
                throw new ResourceCreationException("This is no 8Bit Encoding data");
            }
            External8BitEncodingData external8BitEncodingData = (External8BitEncodingData)object;
            External8BitEncodingCore external8BitEncodingCore = new External8BitEncodingCore(external8BitEncodingData);
            simpleResource = new SimpleResource(resourceData.getKey(), (Object)external8BitEncodingCore, resourceData.getVersion(resourceManager));
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ResourceLoadingException("Failed to load resource", (Exception)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ResourceCreationException("Missing class definition: Failed to create encoding.");
            }
        }
        objectInputStream.close();
        return simpleResource;
    }

    public Class getFactoryType() {
        return Encoding.class;
    }

    public void initializeDefaults() {
    }
}

