/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.manual;

import java.util.Locale;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;

public final class Ascii
implements Encoding {
    public String getName() {
        return "ASCII";
    }

    public String getName(Locale locale) {
        return this.getName();
    }

    public boolean isUnicodeCharacterSupported(int n) {
        return (n & 0xFFFFFF80) == 0;
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer) {
        int n = codePointBuffer.getLength();
        if (byteBuffer == null) {
            byteBuffer = new ByteBuffer(n);
        } else if (byteBuffer.getLength() < n) {
            byteBuffer.ensureSize(n);
        }
        byte[] byArray = byteBuffer.getData();
        int[] nArray = codePointBuffer.getData();
        int n2 = byteBuffer.getOffset();
        int n3 = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n3; ++i) {
            int n4 = nArray[i];
            if (!this.isUnicodeCharacterSupported(n4)) continue;
            byArray[n2] = (byte)(n4 & 0x7F);
            ++n2;
        }
        byteBuffer.setCursor(n2);
        return byteBuffer;
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer) {
        int n = byteBuffer.getLength();
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n);
        } else if (codePointBuffer.getLength() < n) {
            codePointBuffer.ensureSize(n);
        }
        int[] nArray = codePointBuffer.getData();
        byte[] byArray = byteBuffer.getData();
        int n2 = codePointBuffer.getOffset();
        int n3 = byteBuffer.getCursor();
        for (int i = byteBuffer.getOffset(); i < n3; ++i) {
            nArray[n2] = byArray[i] & 0x7F;
            ++n2;
        }
        codePointBuffer.setCursor(n2);
        return codePointBuffer;
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        int n = codePointBuffer.getLength();
        if (byteBuffer == null) {
            byteBuffer = new ByteBuffer(n);
        } else if (byteBuffer.getLength() < n) {
            byteBuffer.ensureSize(n);
        }
        byte[] byArray = byteBuffer.getData();
        int[] nArray = codePointBuffer.getData();
        int n2 = byteBuffer.getOffset();
        int n3 = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n3; ++i) {
            int n4 = nArray[i];
            if (this.isUnicodeCharacterSupported(n4)) {
                byArray[n2] = (byte)(n4 & 0x7F);
                ++n2;
                continue;
            }
            if (EncodingErrorType.REPLACE.equals(encodingErrorType)) {
                byArray[n2] = 63;
                ++n2;
                continue;
            }
            if (!EncodingErrorType.FAIL.equals(encodingErrorType)) continue;
            throw new EncodingException();
        }
        byteBuffer.setCursor(n2);
        return byteBuffer;
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        int n = byteBuffer.getLength();
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n);
        } else if (codePointBuffer.getLength() < n) {
            codePointBuffer.ensureSize(n);
        }
        int[] nArray = codePointBuffer.getData();
        byte[] byArray = byteBuffer.getData();
        int n2 = codePointBuffer.getOffset();
        int n3 = byteBuffer.getCursor();
        for (int i = byteBuffer.getOffset(); i < n3; ++i) {
            nArray[n2] = byArray[i] & 0x7F;
            ++n2;
        }
        codePointBuffer.setCursor(n2);
        return codePointBuffer;
    }
}

