/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.parser.FormulaParseException;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.parser.TokenMgrError;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.StaticArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class Formula
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(Formula.class);
    private LValue rootReference;
    private static final long serialVersionUID = -1176925812499923546L;

    public Formula(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            FormulaParser formulaParser = new FormulaParser();
            this.rootReference = formulaParser.parse(string);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new FormulaParseException(tokenMgrError);
        }
    }

    public Formula(LValue lValue) {
        if (lValue == null) {
            throw new NullPointerException();
        }
        this.rootReference = lValue;
    }

    public void initialize(FormulaContext formulaContext) throws EvaluationException {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.rootReference.initialize(formulaContext);
    }

    public LValue getRootReference() {
        return this.rootReference;
    }

    public TypeValuePair evaluateTyped() {
        try {
            TypeValuePair typeValuePair = this.rootReference.evaluate();
            if (typeValuePair == null) {
                return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_NA_VALUE);
            }
            Type type = typeValuePair.getType();
            if (type.isFlagSet("type.error")) {
                logger.debug((Object)("Error: " + typeValuePair.getValue()));
            } else if (type.isFlagSet("type.array")) {
                Object object = typeValuePair.getValue();
                if (object instanceof ArrayCallback) {
                    return new TypeValuePair(type, new StaticArrayCallback((ArrayCallback)object));
                }
            } else {
                Object object = typeValuePair.getValue();
                if (object instanceof Number) {
                    return new TypeValuePair(type, NumberUtil.performTuneRounding(NumberUtil.getAsBigDecimal((Number)object)));
                }
            }
            return typeValuePair;
        }
        catch (EvaluationException evaluationException) {
            return new TypeValuePair(ErrorType.TYPE, evaluationException.getErrorValue());
        }
        catch (Exception exception) {
            logger.warn((Object)"Evaluation failed unexpectedly: ", (Throwable)exception);
            return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public Object evaluate() {
        return this.evaluateTyped().getValue();
    }

    public Object clone() throws CloneNotSupportedException {
        Formula formula = (Formula)super.clone();
        formula.rootReference = (LValue)this.rootReference.clone();
        return formula;
    }
}

