/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class DateDifFunction
implements Function {
    public static final String YEARS_CODE = "y";
    public static final String MONTHS_CODE = "m";
    public static final String DAYS_CODE = "d";
    public static final String DAYS_IGNORING_YEARS = "yd";
    public static final String MONTHS_IGNORING_YEARS = "ym";
    public static final String DAYS_IGNORING_MONTHS_YEARS = "md";
    private static final long serialVersionUID = 81013707499607068L;

    public String getCanonicalName() {
        return "DATEDIF";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n;
        if (parameterCallback.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Date date = typeRegistry.convertToDate(parameterCallback.getType(0), parameterCallback.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameterCallback.getType(1), parameterCallback.getValue(1));
        String string = typeRegistry.convertToText(parameterCallback.getType(2), parameterCallback.getValue(2));
        if (date == null || date2 == null || string == null || "".equals(string)) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = formulaContext.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone, locale);
        gregorianCalendar2.setTime(date2);
        if (YEARS_CODE.equals(string)) {
            n = gregorianCalendar2.get(1) - gregorianCalendar.get(1);
        } else if (MONTHS_CODE.equals(string)) {
            int n2 = gregorianCalendar.get(2);
            int n3 = gregorianCalendar2.get(2);
            int n4 = gregorianCalendar.get(1);
            int n5 = gregorianCalendar2.get(1);
            n = (n5 - n4) * 12 + n3 - n2;
        } else if (DAYS_IGNORING_MONTHS_YEARS.equals(string)) {
            gregorianCalendar.set(1, gregorianCalendar2.get(1));
            gregorianCalendar.set(2, gregorianCalendar2.get(2));
            n = gregorianCalendar2.get(5) - gregorianCalendar.get(5);
        } else if (DAYS_CODE.equals(string)) {
            int n6 = gregorianCalendar.get(6);
            int n7 = gregorianCalendar2.get(6);
            int n8 = gregorianCalendar.get(1);
            int n9 = gregorianCalendar2.get(1);
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar(timeZone, locale);
            n = n7 - n6;
            int n10 = Math.max(n8, n9);
            for (int i = Math.min(n8, n9); i < n10; ++i) {
                gregorianCalendar3.set(1, i);
                n += gregorianCalendar3.getActualMaximum(6);
            }
        } else if (MONTHS_IGNORING_YEARS.equals(string)) {
            int n11 = gregorianCalendar.get(2);
            int n12 = gregorianCalendar2.get(2);
            n = n12 - n11;
        } else if (DAYS_IGNORING_YEARS.equals(string)) {
            gregorianCalendar.set(1, gregorianCalendar2.get(1));
            int n13 = gregorianCalendar.get(6);
            int n14 = gregorianCalendar2.get(6);
            n = Math.abs(n13 - n14);
        } else {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)n));
    }
}

