/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.dummy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.dummy.NullOutputStream;

public class DummyContentItem
implements ContentItem,
Serializable {
    private ContentLocation parent;
    private String name;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    public DummyContentItem(ContentLocation contentLocation, String string) {
        if (contentLocation != null) {
            throw new NullPointerException("Parent must not be null");
        }
        this.parent = contentLocation;
        this.name = string;
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(EMPTY_BUFFER);
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return RepositoryUtilities.buildName(this, "/");
    }

    public Object getAttribute(String string, String string2) {
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    public boolean delete() {
        return false;
    }
}

