/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.stream;

import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.stream.StreamContentItem;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.libraries.repository.stream.WrappedInputStream;
import org.pentaho.reporting.libraries.repository.stream.WrappedOutputStream;

public class StreamContentLocation
implements ContentLocation {
    private ContentItem contentItem;
    private StreamRepository repository;
    private static final ContentEntity[] EMPTY_CONTENT_ENTITY = new ContentEntity[0];

    public StreamContentLocation(StreamRepository streamRepository) {
        if (streamRepository == null) {
            throw new NullPointerException();
        }
        this.repository = streamRepository;
    }

    public ContentEntity[] listContents() throws ContentIOException {
        WrappedInputStream wrappedInputStream = this.repository.getInputStream();
        if (wrappedInputStream != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, wrappedInputStream, this.repository.getOutputStream());
        }
        if (this.contentItem == null) {
            return EMPTY_CONTENT_ENTITY;
        }
        return new ContentEntity[]{this.contentItem};
    }

    public ContentEntity getEntry(String string) throws ContentIOException {
        WrappedInputStream wrappedInputStream = this.repository.getInputStream();
        if (wrappedInputStream != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, wrappedInputStream, this.repository.getOutputStream());
        }
        if (this.contentItem == null) {
            throw new ContentIOException("No such item");
        }
        if (this.contentItem.getName().equals(string)) {
            return this.contentItem;
        }
        throw new ContentIOException("No such item");
    }

    public ContentItem createItem(String string) throws ContentCreationException {
        WrappedInputStream wrappedInputStream = this.repository.getInputStream();
        WrappedOutputStream wrappedOutputStream = this.repository.getOutputStream();
        if (wrappedInputStream != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, wrappedInputStream, wrappedOutputStream);
        }
        if (this.contentItem == null && wrappedOutputStream != null) {
            this.contentItem = new StreamContentItem(string, this, wrappedInputStream, wrappedOutputStream);
            return this.contentItem;
        }
        throw new ContentCreationException("Failed to create the item. Item already exists or the repository is read-only");
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        throw new ContentCreationException("A stream repository never creates sub-locations");
    }

    public boolean exists(String string) {
        if (this.contentItem != null) {
            return this.contentItem.getName().equals(string);
        }
        WrappedInputStream wrappedInputStream = this.repository.getInputStream();
        if (wrappedInputStream != null) {
            return this.repository.getContentName().equals(string);
        }
        return false;
    }

    public String getName() {
        return "root";
    }

    public Object getContentId() {
        return this.getName();
    }

    public Object getAttribute(String string, String string2) {
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

