%% Generated by lilypond-book.py
%% Options: [indent=0\mm,verbatim,doctitle,alt=[image of music],texidoc,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
  force-assignment = #""
  line-width = #(- line-width (* mm  3.000000))
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "time-signature-printing-only-the-numerator-as-a-number-instead-of-the-fraction.ly"
\sourcefileline 0
%% Do not edit this file; it is auto-generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.12.3"

\header {
  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
Sometimes, a time signature should not print the whole fraction (e.g.
7/4), but only the numerator (7 in this case). This can be easily done
by using \\override Staff.TimeSignature #'style = #'single-digit to
change the style permanently. By using \\revert Staff.TimeSignature
#'style, this setting can be reversed. To apply the single-digit style
to only one time signature, use the \\override command and prefix it
with a \\once. 

"
  doctitle = "Time signature printing only the numerator as a number (instead of the fraction)"
} % begin verbatim

\relative c'' {
  \time 3/4 
  c4 c c
  % Change the style permanently
  \override Staff.TimeSignature #'style = #'single-digit
  \time 2/4 
  c c
  \time 3/4 
  c c c
  % Revert to default style:
  \revert Staff.TimeSignature #'style
  \time 2/4
  c c
  % single-digit style only for the next time signature
  \once \override Staff.TimeSignature #'style = #'single-digit
  \time 5/4
  c c c c c
  \time 2/4
  c c
}



% ****************************************************************
% end ly snippet
% ****************************************************************
