/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.ErrorManager;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class OpenProjectFolderAction
extends AbstractAction
implements ContextAwareAction {
    public OpenProjectFolderAction() {
        super(NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_action"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new ContextAction(context);
    }

    private static final class ContextAction
    extends AbstractAction {
        private final Set<Project> projects = new HashSet<Project>();

        public ContextAction(Lookup context) {
            for (DataFolder d : context.lookupAll(DataFolder.class)) {
                Project p = null;
                try {
                    p = ProjectManager.getDefault().findProject(d.getPrimaryFile());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                if (p == null) continue;
                this.projects.add(p);
            }
            if (this.projects.isEmpty()) {
                this.putValue("hideWhenDisabled", true);
            }
            this.projects.removeAll(Arrays.asList(OpenProjectList.getDefault().getOpenProjects()));
            int size = this.projects.size();
            if (size == 1) {
                String name = ProjectUtils.getInformation((Project)this.projects.iterator().next()).getDisplayName();
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_one", (Object)name));
            } else if (size > 1) {
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_multiple", (Object)size));
            } else {
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_action"));
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    OpenProjectList.getDefault().open(ContextAction.this.projects.toArray(new Project[ContextAction.this.projects.size()]), false, true);
                }
            });
        }
    }
}

