/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.view.DesignerWidgetIdentityCode;
import org.netbeans.modules.websvc.design.view.WsitWidget;
import org.netbeans.modules.websvc.design.view.ZoomManager;
import org.netbeans.modules.websvc.design.view.widget.OperationsWidget;
import org.openide.filesystems.FileObject;

public class DesignView
extends JPanel {
    public static final Object messageLayerKey = new Object();
    private FileObject implementationClass;
    private Service service;
    private ServiceModel serviceModel;
    private ObjectScene scene;
    private ZoomManager zoomer;
    private Widget mainLayer;
    private Widget messageWidget;
    private LabelWidget headerWidget;
    private Widget contentWidget;
    private Widget mainWidget;
    private Widget separatorWidget;
    private OperationsWidget operationsWidget;

    public DesignView(Service service, FileObject fileObject) {
        super(new BorderLayout());
        this.service = service;
        this.implementationClass = fileObject;
        this.serviceModel = ServiceModel.getServiceModel(fileObject);
        this.scene = new ObjectScene(){

            public Comparable<DesignerWidgetIdentityCode> getIdentityCode(Object object) {
                return new DesignerWidgetIdentityCode(DesignView.this.scene, object);
            }
        };
        JComponent jComponent = this.scene.createView();
        this.zoomer = new ZoomManager((Scene)this.scene);
        this.scene.getActions().addAction(ActionFactory.createCycleObjectSceneFocusAction());
        this.scene.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.mainLayer = new LayerWidget((Scene)this.scene);
        this.mainLayer.setPreferredLocation(new Point(0, 0));
        this.mainLayer.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)12));
        this.scene.addChild(this.mainLayer);
        this.mainWidget = new Widget((Scene)this.scene);
        this.mainWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)12));
        this.headerWidget = new LabelWidget((Scene)this.scene, this.getServiceName());
        this.serviceModel.addServiceChangeListener(new ServiceChangeListener(){

            @Override
            public void propertyChanged(String string, String string2, String string3) {
                if (string.equals("serviceName") || string.equals("portName") && DesignView.this.service.getWsdlUrl() != null) {
                    DesignView.this.headerWidget.setLabel(DesignView.this.getServiceName());
                }
            }

            @Override
            public void operationAdded(MethodModel methodModel) {
            }

            @Override
            public void operationRemoved(MethodModel methodModel) {
            }

            @Override
            public void operationChanged(MethodModel methodModel, MethodModel methodModel2) {
            }
        });
        this.headerWidget.setFont(this.scene.getFont().deriveFont(1));
        this.headerWidget.setForeground(Color.GRAY);
        this.headerWidget.setBorder(BorderFactory.createEmptyBorder((int)6, (int)28, (int)0, (int)0));
        this.mainWidget.addChild((Widget)this.headerWidget);
        this.separatorWidget = new SeparatorWidget((Scene)this.scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.separatorWidget.setForeground(Color.ORANGE);
        this.mainWidget.addChild(this.separatorWidget);
        this.contentWidget = new Widget((Scene)this.scene);
        this.contentWidget.setBorder(BorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)20));
        this.contentWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)16));
        this.mainWidget.addChild(this.contentWidget);
        this.operationsWidget = new OperationsWidget(this.scene, service, this.serviceModel);
        this.contentWidget.addChild((Widget)this.operationsWidget);
        WsitWidget wsitWidget = new WsitWidget(this.scene, service, fileObject);
        this.contentWidget.addChild((Widget)wsitWidget);
        jComponent.removeMouseWheelListener((MouseWheelListener)((Object)jComponent));
        final JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        this.mainLayer.addChild(this.mainWidget);
        this.messageWidget = new Widget((Scene)this.scene);
        this.messageWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)4));
        this.mainLayer.addChild(this.messageWidget);
        this.scene.addObject(messageLayerKey, new Widget[]{this.messageWidget});
        this.scene.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                int n = jScrollPane.getViewport().getWidth();
                if (n <= ((DesignView)DesignView.this).scene.getBounds().width) {
                    DesignView.this.mainWidget.setMinimumSize(new Dimension(n, 0));
                }
            }
        });
        this.getContent().putClientProperty("print.printable", Boolean.TRUE);
    }

    public void addToolbarActions(JToolBar jToolBar) {
        jToolBar.addSeparator();
        this.zoomer.addToolbarActions(jToolBar);
        jToolBar.addSeparator();
        this.operationsWidget.addToolbarActions(jToolBar);
    }

    public JComponent getContent() {
        return this.scene.getView();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.scene.getView().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.scene.getView().requestFocusInWindow();
    }

    private String getServiceName() {
        String string = this.serviceModel.getServiceName();
        if (this.service.getWsdlUrl() != null) {
            string = string + " [" + this.serviceModel.getPortName() + "]";
        }
        return string;
    }
}

