/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanel;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanelFactory;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private ToolBarDesignEditor comp;
    private PersistenceView view;
    private PUDataObject puDataObject;
    private PersistenceUnitPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private Project project;
    private boolean needInit = true;
    private RequestProcessor.Task repaintingTask;

    public PersistenceToolBarMVElement(PUDataObject pUDataObject) {
        super((XmlMultiViewDataObject)pUDataObject);
        this.puDataObject = pUDataObject;
        this.project = FileOwnerQuery.getOwner((FileObject)pUDataObject.getPrimaryFile());
        this.addAction = new AddAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Add"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Remove"));
        this.comp = new ToolBarDesignEditor();
        this.factory = new PersistenceUnitPanelFactory(this.comp, pUDataObject);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            if (!this.puDataObject.viewCanBeDisplayed()) {
                this.view = new PersistenceView();
                this.view.setRoot(Node.EMPTY);
                this.comp.setContentView((PanelView)this.view);
                return;
            }
            this.needInit = !this.repaintView();
        }
    }

    private boolean repaintView() {
        this.view = new PersistenceView();
        this.view.initialize(this.puDataObject);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            Node node = this.view.getPersistenceUnitsNode();
            Children children = node.getChildren();
            if (children.getNodesCount() > 0) {
                node = children.getNodes()[0];
            }
            this.view.selectNode(node);
        }
        this.view.checkValidity();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("persistence_unit_added_or_removed".equals(string)) {
            this.repaintingTask.schedule(100);
        } else if (("data modified".equals(string) || "data changed".equals(string)) && !this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            this.needInit = true;
        } else if ("non ui pu classes modified".equals(string) && this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit;
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit2 = persistenceUnit = propertyChangeEvent.getNewValue() instanceof org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit ? (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)propertyChangeEvent.getNewValue() : null;
            if (persistenceUnit != null) {
                PersistenceUnitPanel persistenceUnitPanel;
                SectionContainer sectionContainer = this.view.getPersistenceUnitsCont();
                SectionContainerNode sectionContainerNode = (SectionContainerNode)sectionContainer.getNode();
                Children children = sectionContainerNode.getChildren();
                NodeSectionPanel nodeSectionPanel = null;
                Node[] nodeArray = children.getNodes();
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    Node node = nodeArray[i];
                    PersistenceUnitNode persistenceUnitNode = (PersistenceUnitNode)node;
                    String string2 = persistenceUnitNode.getDisplayName();
                    if (!string2.equals(persistenceUnit.getName())) continue;
                    nodeSectionPanel = sectionContainer.getSection(node);
                    break;
                }
                if ((persistenceUnitPanel = (PersistenceUnitPanel)((nodeArray = nodeSectionPanel != null && nodeSectionPanel instanceof SectionPanel ? (SectionPanel)nodeSectionPanel : null).getInnerPanel() != null && nodeArray.getInnerPanel() instanceof PersistenceUnitPanel ? nodeArray.getInnerPanel() : null)) != null) {
                    persistenceUnitPanel.initEntityList();
                } else {
                    this.needInit = true;
                }
            } else {
                this.needInit = true;
            }
        }
    }

    private void validateUnitName(PersistenceUnitWizardPanel persistenceUnitWizardPanel) {
        try {
            if (!persistenceUnitWizardPanel.isNameUnique()) {
                persistenceUnitWizardPanel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
            } else {
                persistenceUnitWizardPanel.setErrorMessage(null);
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            persistenceUnitWizardPanel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath()));
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)sectionPanel.getKey();
            ConfirmDialog confirmDialog = new ConfirmDialog(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_ConfirmRemove", (Object)persistenceUnit.getName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)confirmDialog);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(confirmDialog.getValue())) {
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                PersistenceToolBarMVElement.this.puDataObject.removePersistenceUnit(persistenceUnit);
            }
        }

        @Override
        public boolean isEnabled() {
            boolean bl = PersistenceToolBarMVElement.this.puDataObject.getPersistence().sizePersistenceUnit() <= 1 && PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion().equals("2.0");
            return !bl;
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            boolean bl = Util.isSupportedJavaEEVersion(PersistenceToolBarMVElement.this.project);
            final PersistenceUnitWizardPanel persistenceUnitWizardPanel = bl && ProviderUtil.isValidServerInstanceOrNone(PersistenceToolBarMVElement.this.project) ? new PersistenceUnitWizardPanelDS(PersistenceToolBarMVElement.this.project, null, true) : new PersistenceUnitWizardPanelJdbc(PersistenceToolBarMVElement.this.project, null, true);
            final NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)new WrapperPanel(persistenceUnitWizardPanel), NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_NewPersistenceUnit"), 2, -1, null, null);
            persistenceUnitWizardPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    if (propertyChangeEvent.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                        PersistenceToolBarMVElement.this.validateUnitName(persistenceUnitWizardPanel);
                        notifyDescriptor.setValid(((Boolean)object).booleanValue());
                    }
                }
            });
            if (!persistenceUnitWizardPanel.isValidPanel()) {
                PersistenceToolBarMVElement.this.validateUnitName(persistenceUnitWizardPanel);
                notifyDescriptor.setValid(false);
            }
            if ((object = DialogDisplayer.getDefault().notify(notifyDescriptor)) == NotifyDescriptor.OK_OPTION) {
                String string = PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion();
                org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = null;
                persistenceUnit = "2.0".equals(string) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
                if (bl) {
                    Library library;
                    PersistenceUnitWizardPanelDS persistenceUnitWizardPanelDS = (PersistenceUnitWizardPanelDS)persistenceUnitWizardPanel;
                    if (persistenceUnitWizardPanelDS.getDatasource() != null && !"".equals(persistenceUnitWizardPanelDS.getDatasource().trim())) {
                        if (persistenceUnitWizardPanelDS.isJTA()) {
                            persistenceUnit.setJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                        } else {
                            persistenceUnit.setNonJtaDataSource(persistenceUnitWizardPanelDS.getDatasource());
                            persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                        }
                    }
                    Provider provider = persistenceUnitWizardPanelDS.getSelectedProvider();
                    if (persistenceUnitWizardPanelDS.isNonDefaultProviderEnabled()) {
                        persistenceUnit.setProvider(persistenceUnitWizardPanelDS.getNonDefaultProvider());
                        library = PersistenceLibrarySupport.getLibrary(provider);
                        if (library != null && !Util.isDefaultProvider(PersistenceToolBarMVElement.this.project, provider)) {
                            Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, library);
                            provider = null;
                        }
                    }
                    if (provider != null && provider.getAnnotationProcessor() != null && (library = PersistenceLibrarySupport.getLibrary(provider)) != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, library, "classpath/processor");
                    }
                } else {
                    PersistenceUnitWizardPanelJdbc persistenceUnitWizardPanelJdbc = (PersistenceUnitWizardPanelJdbc)persistenceUnitWizardPanel;
                    persistenceUnit = ProviderUtil.buildPersistenceUnit(persistenceUnitWizardPanelJdbc.getPersistenceUnitName(), persistenceUnitWizardPanelJdbc.getSelectedProvider(), persistenceUnitWizardPanelJdbc.getPersistenceConnection(), string);
                    persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                    Library library = PersistenceLibrarySupport.getLibrary(persistenceUnitWizardPanelJdbc.getSelectedProvider());
                    if (library != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, library);
                    }
                    JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(persistenceUnitWizardPanelJdbc.getPersistenceConnection().getDriverClass());
                    PersistenceLibrarySupport.addDriver(PersistenceToolBarMVElement.this.project, jDBCDriverArray[0]);
                }
                persistenceUnit.setName(persistenceUnitWizardPanel.getPersistenceUnitName());
                ProviderUtil.setTableGeneration(persistenceUnit, persistenceUnitWizardPanel.getTableGeneration(), PersistenceToolBarMVElement.this.project);
                PersistenceToolBarMVElement.this.puDataObject.addPersistenceUnit(persistenceUnit);
                PersistenceToolBarMVElement.this.comp.setLastActive((Object)persistenceUnit);
            }
        }
    }

    private class PersistenceUnitNode
    extends AbstractNode {
        PersistenceUnitNode(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
            super(Children.LEAF);
            this.setDisplayName(persistenceUnit.getName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("persistence_multiview_design_persistenceUnitNode");
        }
    }

    private class PersistenceView
    extends SectionView {
        private SectionContainer persistenceUnitsCont;
        private Node persistenceUnitsNode;

        public SectionContainer getPersistenceUnitsCont() {
            return this.persistenceUnitsCont;
        }

        public Node getPersistenceUnitsNode() {
            return this.persistenceUnitsNode;
        }

        PersistenceView() {
            super((InnerPanelFactory)PersistenceToolBarMVElement.this.factory);
        }

        void initialize(PUDataObject pUDataObject) {
            Persistence persistence = pUDataObject.getPersistence();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] persistenceUnitArray = persistence.getPersistenceUnit();
            Node[] nodeArray = new Node[persistenceUnitArray.length];
            Children.Array array = new Children.Array();
            for (int i = 0; i < persistenceUnitArray.length; ++i) {
                nodeArray[i] = new PersistenceUnitNode(persistenceUnitArray[i]);
            }
            array.add(nodeArray);
            this.persistenceUnitsNode = new SectionContainerNode((Children)array);
            this.persistenceUnitsNode.setDisplayName(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont = new SectionContainer((SectionView)this, this.persistenceUnitsNode, NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont.setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.addAction});
            Children.Array array2 = new Children.Array();
            array2.add(new Node[]{this.persistenceUnitsNode});
            AbstractNode abstractNode = new AbstractNode((Children)array2);
            SectionPanel[] sectionPanelArray = new SectionPanel[persistenceUnitArray.length];
            for (int i = 0; i < persistenceUnitArray.length; ++i) {
                sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], nodeArray[i].getDisplayName(), (Object)persistenceUnitArray[i], false, false);
                sectionPanelArray[i].setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.removeAction});
                this.persistenceUnitsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
            }
            this.addSection((NodeSectionPanel)this.persistenceUnitsCont);
            this.setRoot((Node)abstractNode);
        }

        public Error validateView() {
            PersistenceValidator persistenceValidator = new PersistenceValidator((PUDataObject)PersistenceToolBarMVElement.this.dObj);
            List<Error> list = persistenceValidator.validate();
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }
    }
}

