/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.xml.xam.Model;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class FacesModelPropertyChangeListener
implements PropertyChangeListener {
    private final PageFlowController pfc;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");
    private boolean isWellFormed = true;
    private static final String NEWLINE = "\n";

    public FacesModelPropertyChangeListener(PageFlowController pageFlowController) {
        this.pfc = pageFlowController;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LogRecord logRecord = new LogRecord(Level.FINE, "Faces Config File Changed:" + this.pfc.getConfigDataObject().getName());
        logRecord.setSourceClassName("FacesModelPropertyChangeListener");
        logRecord.setSourceMethodName("propertyChangeEvent.");
        logRecord.setParameters(new Object[]{propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()});
        LOGGER.log(logRecord);
        if (this.pfc.getView().isShowing()) {
            this.runEventNow(propertyChangeEvent);
        } else {
            this.setGraphDirty(propertyChangeEvent);
        }
    }

    private final void setGraphDirty(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("managed-bean-class") && !propertyChangeEvent.getPropertyName().equals("managed-bean-name") && propertyChangeEvent.getNewValue() != Model.State.NOT_SYNCED) {
            if (propertyChangeEvent.getOldValue() == Model.State.NOT_WELL_FORMED) {
                this.isWellFormed = true;
            } else if (propertyChangeEvent.getNewValue() == Model.State.NOT_WELL_FORMED) {
                this.isWellFormed = false;
            }
            this.pfc.setGraphDirtyWellFormed(this.isWellFormed);
        }
    }

    protected final void runEventNow(final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getOldValue() == Model.State.NOT_WELL_FORMED) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PageFlowView pageFlowView = FacesModelPropertyChangeListener.this.pfc.getView();
                    if (pageFlowView == null) {
                        return;
                    }
                    pageFlowView.removeUserMalFormedFacesConfig();
                    FacesModelPropertyChangeListener.this.setupGraph(propertyChangeEvent);
                }
            });
        } else if (!propertyChangeEvent.getPropertyName().equals("managed-bean-class") && !propertyChangeEvent.getPropertyName().equals("managed-bean-name") && propertyChangeEvent.getNewValue() != Model.State.NOT_SYNCED) {
            if (propertyChangeEvent.getPropertyName().equals("navigation-case")) {
                final NavigationCase navigationCase = (NavigationCase)propertyChangeEvent.getNewValue();
                final NavigationCase navigationCase2 = (NavigationCase)propertyChangeEvent.getOldValue();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FacesModelPropertyChangeListener.this.pfc.getView() == null) {
                            return;
                        }
                        FacesModelPropertyChangeListener.this.navigationCaseEventHandler(navigationCase, navigationCase2);
                    }
                });
            } else if (propertyChangeEvent.getPropertyName().equals("navigation-rule")) {
                final NavigationRule navigationRule = (NavigationRule)propertyChangeEvent.getNewValue();
                final NavigationRule navigationRule2 = (NavigationRule)propertyChangeEvent.getOldValue();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FacesModelPropertyChangeListener.this.pfc.getView() == null) {
                            return;
                        }
                        FacesModelPropertyChangeListener.this.navigationRuleEventHandler(navigationRule, navigationRule2);
                    }
                });
            } else if (propertyChangeEvent.getNewValue() == Model.State.NOT_WELL_FORMED) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageFlowView pageFlowView = FacesModelPropertyChangeListener.this.pfc.getView();
                        if (pageFlowView == null) {
                            return;
                        }
                        pageFlowView.clearGraph();
                        pageFlowView.warnUserMalFormedFacesConfig();
                    }
                });
            } else if (propertyChangeEvent.getPropertyName().equals("textContent")) {
                this.setupGraphInAWTThread(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName().equals("from-view-id") || propertyChangeEvent.getPropertyName().equals("to-view-id")) {
                final String string = FacesModelUtility.getViewIdFiltiered((String)propertyChangeEvent.getOldValue());
                final String string2 = FacesModelUtility.getViewIdFiltiered((String)propertyChangeEvent.getNewValue());
                final Object object = propertyChangeEvent.getSource();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FacesModelPropertyChangeListener.this.pfc.getView() == null) {
                            return;
                        }
                        FacesModelPropertyChangeListener.this.replaceFromViewIdToViewIdEventHandler(propertyChangeEvent, object, string, string2);
                    }
                });
            } else if (propertyChangeEvent.getPropertyName().equals("from-outcome")) {
                final String string = (String)propertyChangeEvent.getOldValue();
                final String string3 = (String)propertyChangeEvent.getNewValue();
                final NavigationCase navigationCase = (NavigationCase)propertyChangeEvent.getSource();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FacesModelPropertyChangeListener.this.pfc.getView() == null) {
                            return;
                        }
                        FacesModelPropertyChangeListener.this.replaceFromOutcomeEventHandler(navigationCase, string, string3);
                    }
                });
            } else {
                this.setupGraphInAWTThread(propertyChangeEvent);
            }
        }
    }

    private final void replaceFromOutcomeEventHandler(NavigationCase navigationCase, String string, String string2) {
        NavigationCaseEdge navigationCaseEdge = this.pfc.getNavCase2NavCaseEdge(navigationCase);
        PageFlowView pageFlowView = this.pfc.getView();
        pageFlowView.renameEdgeWidget(navigationCaseEdge, string2, string);
        pageFlowView.validateGraph();
    }

    private final void replaceFromViewIdToViewIdEventHandler(PropertyChangeEvent propertyChangeEvent, Object object, String string, String string2) {
        LOGGER.entering("\n\nFacesModelPropertyChangeListener", "replaceFromViewIdToViewIdEventHandler");
        NavigationCase navigationCase = object instanceof NavigationCase ? (NavigationCase)object : null;
        NavigationRule navigationRule = object instanceof NavigationRule ? (NavigationRule)object : null;
        Page page = this.pfc.getPageName2Page(string);
        Page page2 = this.pfc.getPageName2Page(string2);
        LOGGER.finest("OldPageNode: " + page + NEWLINE + "NewPageNode: " + page2 + NEWLINE);
        boolean bl = false;
        if (page2 != null && this.pfc.getView().getNodeEdges(page2).size() > 0) {
            bl = true;
        }
        if (page != null && !this.pfc.isPageInAnyFacesConfig(string) && !bl) {
            LOGGER.finest("CASE 1: OldPage is not null and does not exist in the facesconfig anymore.  This is the firsttime the new page is linked.");
            FileObject fileObject = this.pfc.getWebFolder().getFileObject(string2);
            if (fileObject != null && this.pfc.containsWebFile(fileObject)) {
                try {
                    Node node = DataObject.find((FileObject)fileObject).getNodeDelegate();
                    page.replaceWrappedNode(node);
                    this.pfc.getView().resetNodeWidget(page, true);
                    this.pfc.getView().validateGraph();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            } else {
                this.pfc.changeToAbstractNode(page, string2);
            }
        } else if (page == null && !this.pfc.isPageInAnyFacesConfig(string)) {
            LOGGER.finest("CASE 2: OldPage was removed before.");
        } else if (navigationCase != null && this.pfc.isPageInAnyFacesConfig(string)) {
            LOGGER.finest("CASE 3: NavCase is not null");
            NavigationCaseEdge navigationCaseEdge = this.pfc.removeNavCase2NavCaseEdge(navigationCase);
            NavigationCaseEdge navigationCaseEdge2 = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), navigationCase);
            this.pfc.putNavCase2NavCaseEdge(navigationCase, navigationCaseEdge2);
            this.navigationCaseEdgeEventHandler(navigationCaseEdge2, navigationCaseEdge);
        } else if (navigationRule != null && this.pfc.isPageInAnyFacesConfig(string)) {
            LOGGER.finest("CASE 4: NavRule is not null.");
            List list = navigationRule.getNavigationCases();
            this.pfc.putNavRule2String(navigationRule, FacesModelUtility.getViewIdFiltiered(string2));
            for (NavigationCase navigationCase2 : list) {
                LOGGER.finest("CASE 4: Redrawing NavRules Case.");
                NavigationCaseEdge navigationCaseEdge = null;
                NavigationCaseEdge navigationCaseEdge3 = null;
                navigationCaseEdge3 = this.pfc.removeNavCase2NavCaseEdge(navigationCase2);
                navigationCaseEdge = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), navigationCase2);
                this.pfc.putNavCase2NavCaseEdge(navigationCase, navigationCaseEdge);
                this.navigationCaseEdgeEventHandler(navigationCaseEdge, navigationCaseEdge3);
            }
        } else {
            LOGGER.finest("CASE 5: Setup Graph");
            this.setupGraph(propertyChangeEvent);
        }
        LOGGER.exiting("FacesModelPropertyChangeListener", "replaceFromViewIdToViewIdEventHandler");
    }

    private void setupGraph(PropertyChangeEvent propertyChangeEvent) {
        LOGGER.fine("\n\nRe-setting Page Flow Editor because of change in faces config xml file.\nSource Class:  org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener\nMethod Name: setupGraph(PropertyChangeEvent ev)\nEvent: " + propertyChangeEvent + NEWLINE + "PropertyName:" + propertyChangeEvent.getPropertyName() + NEWLINE + "New Value: " + propertyChangeEvent.getNewValue() + NEWLINE + "Old Value: " + propertyChangeEvent.getOldValue() + NEWLINE + "Source: " + propertyChangeEvent.getSource());
        LogRecord logRecord = new LogRecord(Level.FINE, "Faces Config Change Re-Setting Graph");
        logRecord.setSourceClassName("org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener");
        logRecord.setSourceMethodName("setupGraph(PropertyChangeEvent)");
        logRecord.setParameters(new Object[]{propertyChangeEvent});
        LOGGER.log(logRecord);
        this.pfc.setupGraph();
    }

    private final void navigationCaseEventHandler(NavigationCase navigationCase, NavigationCase navigationCase2) {
        NavigationCaseEdge navigationCaseEdge = null;
        NavigationCaseEdge navigationCaseEdge2 = null;
        if (navigationCase != null) {
            navigationCaseEdge = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), navigationCase);
            this.pfc.putNavCase2NavCaseEdge(navigationCase, navigationCaseEdge);
        }
        if (navigationCase2 != null) {
            navigationCaseEdge2 = this.pfc.removeNavCase2NavCaseEdge(navigationCase2);
        }
        this.navigationCaseEdgeEventHandler(navigationCaseEdge, navigationCaseEdge2);
    }

    private final void navigationCaseEdgeEventHandler(NavigationCaseEdge navigationCaseEdge, NavigationCaseEdge navigationCaseEdge2) {
        PageFlowView pageFlowView = this.pfc.getView();
        if (navigationCaseEdge != null && navigationCaseEdge.getToViewId() != null && navigationCaseEdge.getFromViewId() != null) {
            Page page = this.pfc.getPageName2Page(navigationCaseEdge.getFromViewId());
            Page page2 = this.pfc.getPageName2Page(navigationCaseEdge.getToViewId());
            if (page == null) {
                page = this.pfc.createPage(navigationCaseEdge.getFromViewId());
                pageFlowView.createNode(page, null, null);
            }
            if (page2 == null) {
                page2 = this.pfc.createPage(navigationCaseEdge.getToViewId());
                pageFlowView.createNode(page2, null, null);
            }
            this.pfc.createEdge(navigationCaseEdge);
        }
        if (navigationCaseEdge2 != null) {
            pageFlowView.removeEdge(navigationCaseEdge2);
            this.removePageIfNoReference(navigationCaseEdge2.getToViewId());
        }
        pageFlowView.validateGraph();
    }

    private final void removePageIfNoReference(String string) {
        Page page;
        if (!(string == null || (page = this.pfc.getPageName2Page(string)) == null || this.pfc.isPageInAnyFacesConfig(string) || page.isDataNode() && !this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG))) {
            PageFlowView pageFlowView = this.pfc.getView();
            if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG) && !this.pfc.isPageInAnyFacesConfig(string)) {
                pageFlowView.removeNodeWithEdges(page);
                this.pfc.removePageName2Page(page, true);
                pageFlowView.validateGraph();
            } else if (!this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                pageFlowView.removeNodeWithEdges(page);
                this.pfc.removePageName2Page(page, true);
                pageFlowView.validateGraph();
            }
        }
    }

    private final void navigationRuleEventHandler(NavigationRule navigationRule, NavigationRule navigationRule2) {
        if (navigationRule2 != null) {
            String string = this.pfc.removeNavRule2String(navigationRule2);
            List list = navigationRule2.getNavigationCases();
            for (NavigationCase navigationCase : list) {
                this.navigationCaseEventHandler(null, navigationCase);
            }
            this.removePageIfNoReference(string);
        }
        if (navigationRule != null) {
            this.pfc.putNavRule2String(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
        }
    }

    private final void setupGraphInAWTThread(final PropertyChangeEvent propertyChangeEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FacesModelPropertyChangeListener.this.pfc.getView() == null) {
                    return;
                }
                FacesModelPropertyChangeListener.this.setupGraph(propertyChangeEvent);
            }
        });
    }
}

