/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.layout.SceneElementComparator;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class MapActionUtility {
    public static Action handleEscape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
            if (CONNECT_WIDGET != null) {
                CONNECT_WIDGET.removeFromParent();
                CONNECT_WIDGET = null;
            }
        }
    };
    public static Action handleRename = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene) {
                PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
                PageFlowSceneElement pageFlowSceneElement = MapActionUtility.getSelectedPageFlowSceneElement(pageFlowScene);
                Widget widget = pageFlowScene.findWidget(pageFlowSceneElement);
                assert (widget != null);
                if (widget instanceof VMDNodeWidget) {
                    LabelWidget labelWidget = ((VMDNodeWidget)widget).getNodeNameWidget();
                    InplaceEditorProvider.EditorController editorController = this.findEditorController(labelWidget.getActions().getActions());
                    if (editorController != null) {
                        editorController.openEditor((Widget)labelWidget);
                    }
                } else if (widget instanceof VMDConnectionWidget) {
                    List list = widget.getChildren();
                    for (Widget widget2 : list) {
                        InplaceEditorProvider.EditorController editorController;
                        if (!(widget2 instanceof LabelWidget) || (editorController = this.findEditorController(widget2.getActions().getActions())) == null) continue;
                        editorController.openEditor(widget2);
                    }
                }
            }
        }

        public InplaceEditorProvider.EditorController findEditorController(List<WidgetAction> list) {
            for (WidgetAction widgetAction : list) {
                if (!(widgetAction instanceof InplaceEditorProvider.EditorController)) continue;
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)widgetAction);
                return editorController;
            }
            return null;
        }
    };
    public static final Action handleTabAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            MapActionUtility.handleTabActionEvent(actionEvent, bl);
        }
    };
    public static final Action handleCtrlTab = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            MapActionUtility.handleTabActionEvent(actionEvent, bl);
        }
    };
    public static final Action handleDownArrow = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
            boolean bl = false;
            MapActionUtility.handleArrow(pageFlowScene, bl);
        }
    };
    public static final Action handleUpArrow = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
            boolean bl = true;
            MapActionUtility.handleArrow(pageFlowScene, bl);
        }
    };
    private static ConnectDecorator CONNECT_DECORATOR_DEFAULT = null;
    private static ConnectionWidget CONNECT_WIDGET = null;
    public static Action handleLinkStart = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            PageFlowSceneElement pageFlowSceneElement;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (pageFlowSceneElement = MapActionUtility.getSelectedPageFlowSceneElement(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                Widget widget = null;
                if (pageFlowSceneElement instanceof Page) {
                    widget = pageFlowScene.findWidget(pageFlowSceneElement);
                } else if (pageFlowSceneElement instanceof Pin) {
                    widget = pageFlowScene.findWidget((Pin)pageFlowSceneElement);
                }
                if (widget != null) {
                    CONNECT_DECORATOR_DEFAULT = ActionFactory.createDefaultConnectDecorator();
                    CONNECT_DECORATOR_DEFAULT.createTargetAnchor(widget);
                    CONNECT_WIDGET = CONNECT_DECORATOR_DEFAULT.createConnectionWidget((Scene)pageFlowScene);
                    CONNECT_WIDGET.setSourceAnchor(CONNECT_DECORATOR_DEFAULT.createSourceAnchor(widget));
                    CONNECT_WIDGET.setTargetAnchor(CONNECT_DECORATOR_DEFAULT.createSourceAnchor(widget));
                    pageFlowScene.getConnectionLayer().addChild((Widget)CONNECT_WIDGET);
                    pageFlowScene.validate();
                }
            }
        }
    };
    public static Action handleLinkEnd = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene) {
                PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
                if (CONNECT_WIDGET != null) {
                    Anchor anchor = CONNECT_WIDGET.getSourceAnchor();
                    Anchor anchor2 = CONNECT_WIDGET.getTargetAnchor();
                    if (anchor != null && anchor2 != null) {
                        Object object2 = pageFlowScene.findObject(CONNECT_WIDGET.getSourceAnchor().getRelatedWidget());
                        Page page = null;
                        Pin pin = null;
                        if (pageFlowScene.isPin(object2)) {
                            pin = (Pin)object2;
                            page = pin.getPage();
                        }
                        if (pageFlowScene.isNode(object2)) {
                            page = (Page)object2;
                        }
                        Object object3 = pageFlowScene.findObject(CONNECT_WIDGET.getTargetAnchor().getRelatedWidget());
                        Page page2 = null;
                        if (pageFlowScene.isPin(object3)) {
                            page2 = ((Pin)object3).getPage();
                        }
                        if (pageFlowScene.isNode(object3)) {
                            page2 = (Page)object3;
                        }
                        if (page != null && page2 != null) {
                            pageFlowScene.getPageFlowView().getPageFlowController().createLink(page, page2, pin);
                        }
                        CONNECT_WIDGET.removeFromParent();
                        CONNECT_WIDGET = null;
                        pageFlowScene.validate();
                    }
                }
            }
        }
    };
    public static final Action handleOpenPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene) {
                PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
                HashSet hashSet = new HashSet(pageFlowScene.getSelectedObjects());
                for (Object e : hashSet) {
                    if (!(e instanceof PageFlowSceneElement)) continue;
                    MapActionUtility.openPageFlowSceneElement((PageFlowSceneElement)e);
                }
            }
        }
    };
    public static Action handleNewWebForm = new AbstractAction(){
        PageFlowScene scene;
        private static final String DEFAULT_DOC_BASE_FOLDER = "web";

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene) {
                try {
                    this.scene = (PageFlowScene)((Object)object);
                    PageFlowController pageFlowController = this.scene.getPageFlowView().getPageFlowController();
                    FileObject fileObject = pageFlowController.getWebFolder();
                    String string = FileUtil.findFreeFileName((FileObject)fileObject, (String)"Templates/JSP_Servlet/JSP.jsp", (String)"jsp");
                    string = JOptionPane.showInputDialog("Select Page Name", (Object)string);
                    this.createIndexJSP(fileObject, string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        private void createIndexJSP(FileObject fileObject, String string) throws IOException {
            FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
            if (fileObject2 == null) {
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            dataObject.createFromTemplate(dataFolder, string);
        }
    };
    public static final Action handleZoomPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            Page page;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)pageFlowScene.findWidget(page);
                if (vMDNodeWidget.isMinimized()) {
                    vMDNodeWidget.expandWidget();
                } else {
                    vMDNodeWidget.collapseWidget();
                }
            }
        }
    };
    public static final Action handleUnZoomPage = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    public static Action handlePopup = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Point point;
            Object object;
            Object object2;
            Object object3 = actionEvent.getSource();
            if (!(object3 instanceof PageFlowScene)) {
                return;
            }
            PageFlowScene pageFlowScene = (PageFlowScene)((Object)object3);
            PopupMenuProvider popupMenuProvider = pageFlowScene.getPopupMenuProvider();
            PageFlowSceneElement pageFlowSceneElement = MapActionUtility.getSelectedPageFlowSceneElement(pageFlowScene);
            if (pageFlowSceneElement != null && pageFlowSceneElement instanceof PageFlowSceneElement) {
                object2 = pageFlowScene.findWidget(pageFlowSceneElement);
                assert (object2 != null);
                if (pageFlowSceneElement instanceof NavigationCaseEdge) {
                    object = (NavigationCaseEdge)pageFlowSceneElement;
                    VMDConnectionWidget vMDConnectionWidget = (VMDConnectionWidget)pageFlowScene.findWidget(object);
                    point = vMDConnectionWidget.getFirstControlPoint();
                } else {
                    point = object2.getLocation();
                }
            } else {
                object = pageFlowScene.getClientArea();
                point = pageFlowScene.convertSceneToLocal(new Point(((Rectangle)object).width / 2, ((Rectangle)object).height / 2));
                object2 = pageFlowScene;
            }
            assert (object2 != null);
            assert (point != null);
            object = popupMenuProvider.getPopupMenu(object2, point);
            if (object != null) {
                ((JPopupMenu)object).show(pageFlowScene.getView(), point.x, point.y);
            }
        }
    };
    public static Action handleRightCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            Page page;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                MapActionUtility.movePage(pageFlowScene, page, 5, 0);
            }
        }
    };
    public static Action handleLeftCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            Page page;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                MapActionUtility.movePage(pageFlowScene, page, -5, 0);
            }
        }
    };
    public static Action handleUpCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            Page page;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                MapActionUtility.movePage(pageFlowScene, page, 0, -5);
            }
        }
    };
    public static Action handleDownCtrlArrowKey = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFlowScene pageFlowScene;
            Page page;
            Object object = actionEvent.getSource();
            if (object instanceof PageFlowScene && (page = MapActionUtility.getSelectedPage(pageFlowScene = (PageFlowScene)((Object)object))) != null) {
                MapActionUtility.movePage(pageFlowScene, page, 0, 5);
            }
        }
    };

    private MapActionUtility() {
    }

    public static ActionMap initActionMap() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("handleTab", handleTabAction);
        actionMap.put("handleCtrlTab", handleCtrlTab);
        actionMap.put("handleEscape", handleEscape);
        actionMap.put("handleLinkStart", handleLinkStart);
        actionMap.put("handleLinkEnd", handleLinkEnd);
        actionMap.put("handleZoomPage", handleZoomPage);
        actionMap.put("handleUnZoomPage", handleZoomPage);
        actionMap.put("handleOpenPage", handleOpenPage);
        actionMap.put("handleLeftArrowKey", handleCtrlTab);
        actionMap.put("handleRightArrowKey", handleTabAction);
        actionMap.put("handleUpArrowKey", handleUpArrow);
        actionMap.put("handleDownArrowKey", handleDownArrow);
        actionMap.put("handleRename", handleRename);
        actionMap.put("handlePopup", handlePopup);
        actionMap.put("handleLeftCtrlArrowKey", handleLeftCtrlArrowKey);
        actionMap.put("handleRightCtrlArrowKey", handleRightCtrlArrowKey);
        actionMap.put("handleDownCtrlArrowKey", handleDownCtrlArrowKey);
        actionMap.put("handleUpCtrlArrowKey", handleUpCtrlArrowKey);
        return actionMap;
    }

    public static InputMap initInputMap() {
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "handleTab");
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "handleCtrlTab");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "handleEscape");
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "handleLinkStart");
        inputMap.put(KeyStroke.getKeyStroke(69, 0), "handleLinkEnd");
        inputMap.put(KeyStroke.getKeyStroke(90, 0), "handleZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(85, 0), "handleUnZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(80, 0), "handlePopup");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "handleOpenPage");
        inputMap.put(KeyStroke.getKeyStroke(83, 1), "handleLinkStart");
        inputMap.put(KeyStroke.getKeyStroke(69, 1), "handleLinkEnd");
        inputMap.put(KeyStroke.getKeyStroke(90, 1), "handleZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(85, 1), "handleUnZoomPage");
        inputMap.put(KeyStroke.getKeyStroke(80, 1), "handlePopup");
        inputMap.put(KeyStroke.getKeyStroke(82, 2), "handleRename");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "handleLeftArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "handleRightArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "handleUpArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "handleDownArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(226, 0), "handleLeftArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(227, 0), "handleRightArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(224, 0), "handleUpArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(225, 0), "handleDownArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(37, 2), "handleLeftCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(226, 2), "handleLeftCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(39, 2), "handleRightCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(227, 2), "handleRightCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 2), "handleUpCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(38, 2), "handleUpCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 2), "handleDownCtrlArrowKey");
        inputMap.put(KeyStroke.getKeyStroke(40, 2), "handleDownCtrlArrowKey");
        return inputMap;
    }

    private static final void handleTabActionEvent(ActionEvent actionEvent, boolean bl) {
        Object object = actionEvent.getSource();
        if (!(object instanceof PageFlowScene)) {
            return;
        }
        PageFlowScene pageFlowScene = (PageFlowScene)((Object)object);
        MapActionUtility.handleTab(pageFlowScene, bl);
    }

    private static final void handleTab(PageFlowScene pageFlowScene, boolean bl) {
        PageFlowSceneElement pageFlowSceneElement = SceneElementComparator.getNextSelectableElement(pageFlowScene, bl, true, true, false);
        if (pageFlowSceneElement != null) {
            Anchor anchor;
            if (CONNECT_WIDGET != null && pageFlowScene.getConnectionLayer().getChildren().contains(CONNECT_WIDGET)) {
                if (pageFlowSceneElement instanceof Page) {
                    assert (CONNECT_DECORATOR_DEFAULT != null);
                    anchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(pageFlowScene.findWidget(pageFlowSceneElement));
                    CONNECT_WIDGET.setTargetAnchor(anchor);
                    pageFlowScene.validate();
                } else if (pageFlowSceneElement instanceof Pin) {
                    Widget widget = pageFlowScene.findWidget(((Pin)pageFlowSceneElement).getPage());
                    anchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(widget);
                    CONNECT_WIDGET.setTargetAnchor(anchor);
                    pageFlowScene.validate();
                }
            }
            anchor = new HashSet();
            anchor.add(pageFlowSceneElement);
            pageFlowScene.setHoveredObject(pageFlowSceneElement);
            pageFlowScene.setSelectedObjects((Set)anchor);
            pageFlowScene.setFocusedObject(pageFlowSceneElement);
        } else {
            pageFlowScene.setSelectedObjects(new HashSet());
            pageFlowScene.setHoveredObject(null);
        }
    }

    private static final void handleArrow(PageFlowScene pageFlowScene, boolean bl) {
        PageFlowSceneElement pageFlowSceneElement = SceneElementComparator.getNextSelectableElement(pageFlowScene, bl, false, false, true);
        if (pageFlowSceneElement != null) {
            Anchor anchor;
            if (CONNECT_WIDGET != null && pageFlowScene.getConnectionLayer().getChildren().contains(CONNECT_WIDGET)) {
                anchor = null;
                if (pageFlowSceneElement instanceof Page) {
                    assert (CONNECT_DECORATOR_DEFAULT != null);
                    anchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(pageFlowScene.findWidget(pageFlowSceneElement));
                } else if (pageFlowSceneElement instanceof Pin) {
                    Widget widget = pageFlowScene.findWidget(((Pin)pageFlowSceneElement).getPage());
                    anchor = CONNECT_DECORATOR_DEFAULT.createTargetAnchor(widget);
                }
                if (anchor != null) {
                    CONNECT_WIDGET.setTargetAnchor(anchor);
                    pageFlowScene.validate();
                }
            }
            anchor = new HashSet();
            anchor.add(pageFlowSceneElement);
            pageFlowScene.setSelectedObjects((Set)anchor);
        }
    }

    public static void openPageFlowSceneElement(PageFlowSceneElement pageFlowSceneElement) {
        OpenCookie openCookie = (OpenCookie)pageFlowSceneElement.getNode().getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
        }
    }

    public static Page getSelectedPage(PageFlowScene pageFlowScene) {
        assert (pageFlowScene != null);
        PageFlowSceneElement pageFlowSceneElement = MapActionUtility.getSelectedPageFlowSceneElement(pageFlowScene);
        if (pageFlowSceneElement != null && pageFlowSceneElement instanceof Page) {
            return (Page)pageFlowSceneElement;
        }
        return null;
    }

    public static PageFlowSceneElement getSelectedPageFlowSceneElement(PageFlowScene pageFlowScene) {
        assert (pageFlowScene != null);
        Iterator iterator = pageFlowScene.getSelectedObjects().iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            return (PageFlowSceneElement)e;
        }
        return null;
    }

    public static void movePage(PageFlowScene pageFlowScene, Page page, int n, int n2) {
        assert (pageFlowScene != null);
        assert (page != null);
        Widget widget = pageFlowScene.findWidget(page);
        Point point = widget.getLocation();
        point.translate(n, n2);
        widget.setPreferredLocation(point);
        pageFlowScene.validate();
    }
}

