/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class AssemblerConfiguration
extends BasicCompilerConfiguration {
    public AssemblerConfiguration(String baseDir, AssemblerConfiguration master) {
        super(baseDir, master);
    }

    public void assign(AssemblerConfiguration conf) {
        super.assign(conf);
    }

    public AssemblerConfiguration clone() {
        AssemblerConfiguration clone = new AssemblerConfiguration(this.getBaseDir(), (AssemblerConfiguration)this.getMaster());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        String options = "$(AS) $(ASFLAGS) ";
        options = options + this.getAllOptions2(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public String getAsFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getAsFlags(AbstractCompiler compiler) {
        String options = this.getAsFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        AssemblerConfiguration master;
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        String options = "";
        options = options + this.getAsFlagsBasic(compiler) + " ";
        for (master = this; master != null; master = (AssemblerConfiguration)master.getMaster()) {
            options = options + master.getCommandLineConfiguration().getValue() + " ";
        }
        if (master != null) {
            // empty if block
        }
        options = options + this.getAllOptions2(compiler) + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public Sheet getGeneralSheet(MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler assemblerCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.Assembler);
        Sheet.Set basicSet = this.getBasicSet();
        basicSet.remove("StripSymbols");
        sheet.put(basicSet);
        if (this.getMaster() != null) {
            sheet.put(this.getInputSet());
        }
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(AssemblerConfiguration.getString("ToolTxt1"));
        set4.setShortDescription(AssemblerConfiguration.getString("ToolHint1"));
        if (assemblerCompiler != null) {
            set4.put((Node.Property)new StringNodeProp(this.getTool(), assemblerCompiler.getName(), false, "Tool", AssemblerConfiguration.getString("ToolTxt2"), AssemblerConfiguration.getString("ToolHint2")));
        }
        sheet.put(set4);
        String[] texts = new String[]{AssemblerConfiguration.getString("AdditionalOptionsTxt1"), AssemblerConfiguration.getString("AdditionalOptionsHint"), AssemblerConfiguration.getString("AdditionalOptionsTxt2"), AssemblerConfiguration.getString("AllOptionsTxt")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(AssemblerConfiguration.getString("CommandLineTxt"));
        set2.setShortDescription(AssemblerConfiguration.getString("CommandLineHint"));
        if (assemblerCompiler != null) {
            set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, assemblerCompiler, null, texts));
        }
        sheet.put(set2);
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(AssemblerConfiguration.class, (String)s);
    }
}

