/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class ActionRescanJavaSourceTaskFactoryImpl
extends EditorAwareJavaSourceTaskFactory {
    public ActionRescanJavaSourceTaskFactoryImpl() {
        super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
    }

    public CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
        return new RescanTask(fileObject);
    }

    public JavaSource.Priority getPriority() {
        return JavaSource.Priority.LOW;
    }

    public JavaSource.Phase getPhase() {
        return JavaSource.Phase.RESOLVED;
    }

    private static class RescanTask
    implements CancellableTask<CompilationInfo> {
        FileObject file;

        public RescanTask(FileObject fileObject) {
            this.file = fileObject;
        }

        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            if (ActionManager.anyFormOpened() && AppFrameworkSupport.isFrameworkLibAvailable(this.file) && (RescanTask.isApplicationSourceFile(this.file) || RescanTask.isOpenedForm(this.file))) {
                ActionManager.lazyRescan(this.file);
            }
        }

        private static boolean isApplicationSourceFile(FileObject fileObject) {
            String string = AppFrameworkSupport.getAppClassNameFromProjectConfig(FileOwnerQuery.getOwner((FileObject)fileObject));
            if (string != null) {
                return string.equals(AppFrameworkSupport.getClassNameForFile(fileObject));
            }
            return false;
        }

        private static boolean isOpenedForm(FileObject fileObject) {
            block4: {
                if (fileObject.existsExt("form") && fileObject.hasExt("java")) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject instanceof FormDataObject) {
                            FormDataObject formDataObject = (FormDataObject)dataObject;
                            return formDataObject.getFormEditor().isOpened();
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }
}

