/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.openide.util.Exceptions;

public class JavaCodeTemplateFilter
implements CodeTemplateFilter,
Task<CompilationController> {
    private static final Logger LOG = Logger.getLogger(JavaCodeTemplateFilter.class.getName());
    private int startOffset;
    private int endOffset;
    private Tree.Kind ctx = null;

    private JavaCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.startOffset = n;
        this.endOffset = jTextComponent.getSelectionStart() == n ? jTextComponent.getSelectionEnd() : -1;
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public synchronized boolean accept(CodeTemplate codeTemplate) {
        return this.ctx != null && this.getTemplateContexts(codeTemplate).contains((Object)this.ctx);
    }

    public synchronized void run(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.PARSED);
        Tree tree = compilationController.getTreeUtilities().pathFor(this.startOffset).getLeaf();
        if (this.endOffset >= 0 && this.startOffset != this.endOffset && compilationController.getTreeUtilities().pathFor(this.endOffset).getLeaf() != tree) {
            return;
        }
        this.ctx = tree.getKind();
    }

    private EnumSet<Tree.Kind> getTemplateContexts(CodeTemplate codeTemplate) {
        List list = codeTemplate.getContexts();
        ArrayList<Tree.Kind> arrayList = new ArrayList<Tree.Kind>();
        if (list != null) {
            for (String string : list) {
                Tree.Kind kind = Tree.Kind.valueOf(string);
                if (kind != null) {
                    arrayList.add(kind);
                    continue;
                }
                LOG.warning("Invalid code template context '" + string + "', ignoring.");
            }
        }
        if (arrayList.size() > 0) {
            return EnumSet.copyOf(arrayList);
        }
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new JavaCodeTemplateFilter(jTextComponent, n);
        }
    }
}

