/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.document;

import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.structure.document.ComponentWidget;
import org.netbeans.modules.vmd.structure.document.DocumentScene;

public class DocumentController
implements DesignDocumentAwareness,
DesignListener {
    private DataObjectContext context;
    private JToolBar toolbarRepresentation;
    private JScrollPane scrollPane;
    private DesignDocument document;
    private DocumentScene scene;
    private JComponent view;

    public DocumentController(DataObjectContext context) {
        this.context = context;
        this.scene = new DocumentScene();
        this.view = this.scene.createView();
        this.scrollPane = new JScrollPane(this.view);
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    public void setDesignDocument(final DesignDocument newDocument) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocumentController.this.updateDocumentReference(newDocument);
            }
        });
    }

    public void attach() {
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void deattach() {
        this.context.removeDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbarRepresentation == null) {
            this.toolbarRepresentation = new JToolBar();
            this.toolbarRepresentation.setFloatable(false);
        }
        return this.toolbarRepresentation;
    }

    private void updateDocumentReference(DesignDocument wantedDocument) {
        if (this.document == wantedDocument) {
            return;
        }
        if (this.document != null) {
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
        }
        this.document = wantedDocument;
        if (this.document != null) {
            this.document.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            this.designChanged(null);
        } else {
            this.scene.setupLoadingDocument();
        }
    }

    public void designChanged(DesignEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final DesignDocument document = DocumentController.this.document;
                if (document != null) {
                    document.getTransactionManager().readAccess(new Runnable(){

                        @Override
                        public void run() {
                            DocumentController.this.updateScene(document);
                        }
                    });
                }
            }
        });
    }

    private void updateScene(DesignDocument document) {
        if (document == null) {
            return;
        }
        this.scene.clear();
        Collection selectedComponents = document.getSelectedComponents();
        DesignComponent rootComponent = document.getRootComponent();
        ComponentWidget widget = new ComponentWidget(this.scene, rootComponent, selectedComponents.contains(rootComponent));
        this.scene.setRootNode(document, widget);
        this.updateForChildren(selectedComponents, widget, rootComponent);
        this.scene.validate();
    }

    private void updateForChildren(Collection<DesignComponent> selectedComponents, ComponentWidget widget, DesignComponent component) {
        for (DesignComponent child : component.getComponents()) {
            ComponentWidget childWidget = new ComponentWidget(this.scene, child, selectedComponents.contains(child));
            widget.addChildComponentWidget(childWidget);
            this.updateForChildren(selectedComponents, childWidget, child);
        }
    }
}

