/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public class ActionRegistry
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ActionRegistry.class.getName());
    private static final String PATH = "Databases/Explorer/";
    private static final String ACTIONS = "/Actions";
    private final ChangeSupport changeSupport;
    private final List<Action> actions = new CopyOnWriteArrayList<Action>();
    private Lookup.Result lookupResult;

    public ActionRegistry(String entryName) {
        this.changeSupport = new ChangeSupport((Object)this);
        this.loadActions(entryName);
    }

    private void loadActions(String entryName) {
        Lookup lookup = Lookups.forPath((String)(PATH + entryName + ACTIONS));
        this.lookupResult = lookup.lookupResult(Object.class);
        this.initActions();
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ActionRegistry.this.initActions();
                ActionRegistry.this.changeSupport.fireChange();
            }
        });
    }

    private void initActions() {
        this.actions.clear();
        Collection actionList = this.lookupResult.allInstances();
        for (Object action : actionList) {
            if (action instanceof Action) {
                this.actions.add((Action)action);
                continue;
            }
            if (action instanceof JSeparator) {
                this.actions.add(null);
                continue;
            }
            LOGGER.log(Level.INFO, "Cannot use " + action.getClass() + " instance as DB Explorer Action");
        }
    }

    public Collection<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.changeSupport.fireChange();
    }
}

