/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.TagLastCharResultItem;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.filesystems.FileObject;

public class CompletionQuery
extends AsyncCompletionQuery {
    private JTextComponent component;
    private FileObject primaryFile;
    private CompletionContextImpl context;

    public CompletionQuery(FileObject primaryFile) {
        this.primaryFile = primaryFile;
    }

    protected void prepareQuery(JTextComponent component) {
        this.component = component;
    }

    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        XMLSyntaxSupport support = (XMLSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
        CompletionResultItem endTagResultItem = CompletionUtil.getEndTagCompletionItem(this.component, (BaseDocument)doc);
        List<CompletionResultItem> completionItems = null;
        if (!support.noCompletion(this.component) && CompletionUtil.canProvideCompletion((BaseDocument)doc)) {
            completionItems = this.getCompletionItems(doc, caretOffset);
        }
        if (endTagResultItem != null) {
            resultSet.addItem((CompletionItem)endTagResultItem);
        }
        if (completionItems != null && completionItems.size() > 0) {
            resultSet.addAllItems(completionItems);
        } else if (endTagResultItem != null && !(endTagResultItem instanceof TagLastCharResultItem)) {
            endTagResultItem.setExtraPaintGap(-5);
        }
        resultSet.finish();
    }

    List<CompletionResultItem> getCompletionItems(Document doc, int caretOffset) {
        List<CompletionResultItem> completionItems = null;
        XMLSyntaxSupport support = (XMLSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
        this.context = new CompletionContextImpl(this.primaryFile, support, caretOffset);
        if (!this.context.initContext() || !this.context.initModels()) {
            return null;
        }
        switch (this.context.getCompletionType()) {
            case COMPLETION_TYPE_ELEMENT_VALUE: {
                completionItems = CompletionUtil.getElementValues(this.context);
                if (completionItems != null && completionItems.size() > 0) break;
            }
            case COMPLETION_TYPE_ELEMENT: {
                completionItems = CompletionUtil.getElements(this.context);
                break;
            }
            case COMPLETION_TYPE_ATTRIBUTE: {
                completionItems = CompletionUtil.getAttributes(this.context);
                break;
            }
            case COMPLETION_TYPE_ATTRIBUTE_VALUE: {
                completionItems = CompletionUtil.getAttributeValues(this.context);
                break;
            }
            case COMPLETION_TYPE_ENTITY: {
                break;
            }
            case COMPLETION_TYPE_NOTATION: {
                break;
            }
        }
        return completionItems;
    }
}

