/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.InputOutput;

public class ReconfigureProject {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP = new RequestProcessor(ReconfigureProject.class.getName(), 1);
    private final Project makeProject;
    private final ConfigurationDescriptorProvider pdp;
    private final boolean isSunCompiler;
    private CompilerSet compilerSet;
    private final int platform;
    private DataObject configure;
    private DataObject cmake;
    private DataObject qmake;
    private DataObject make;
    private String cFlags;
    private String cxxFlags;
    private String linkerFlags;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private Future<Integer> lastTask;
    private Set<ExecutionListener> listeners = new WeakSet();
    private InputOutput tab;

    public ReconfigureProject(Project makeProject) {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        this.makeProject = makeProject;
        this.pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        assert (this.pdp != null && this.pdp.gotDescriptor());
        MakeConfiguration configuration = this.pdp.getConfigurationDescriptor().getActiveConfiguration();
        assert (configuration != null && configuration.getConfigurationType().getValue() == 0);
        CompilerSet2Configuration set = configuration.getCompilerSet();
        this.compilerSet = set.getCompilerSet();
        assert (this.compilerSet != null);
        this.isSunCompiler = this.compilerSet.getCompilerFlavor().isSunStudioCompiler();
        Folder important = this.pdp.getConfigurationDescriptor().getExternalFileItems();
        for (Item item : important.getAllItemsAsArray()) {
            DataObject dao = item.getDataObject();
            if (dao == null) continue;
            String mime = dao.getPrimaryFile().getMIMEType();
            if ("text/sh".equals(mime)) {
                if (!"configure".equals(dao.getPrimaryFile().getName())) continue;
                this.configure = dao;
                continue;
            }
            if ("text/x-cmake".equals(mime)) {
                this.cmake = dao;
                continue;
            }
            if ("text/x-qtproject".equals(mime)) {
                this.qmake = dao;
                continue;
            }
            if (!"text/x-make".equals(mime)) continue;
            if (dao.getPrimaryFile().hasExt("mk")) {
                if (this.make != null) continue;
                this.make = dao;
                continue;
            }
            this.make = dao;
        }
        this.platform = configuration.getDevelopmentHost().getBuildPlatform();
    }

    public void addExecutionListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeExecutionListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    private String escapeFlags(String flags) {
        if (!(flags.indexOf(32) <= 0 && flags.indexOf(61) <= 0 || flags.startsWith("\""))) {
            flags = "\"" + flags + "\"";
        }
        return flags;
    }

    public void reconfigure(final String cFlags, final String cxxFlags, final String linkerFlags, final InputOutput io) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ReconfigureProject.this.reconfigure(cFlags, cxxFlags, linkerFlags, ReconfigureProject.this.getRestOptions(), true, io);
                }
            });
        } else {
            this.reconfigure(cFlags, cxxFlags, linkerFlags, this.getRestOptions(), true, io);
        }
    }

    public void reconfigure(String cFlags, String cxxFlags, String linkerFlags, String otherOptions, boolean waitFinished, InputOutput io) {
        this.tab = io;
        if (waitFinished) {
            final AtomicInteger res = new AtomicInteger();
            final AtomicBoolean finished = new AtomicBoolean(false);
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void executionFinished(int rc) {
                    res.set(rc);
                    finished.set(true);
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        finished.notifyAll();
                    }
                }
            };
            this.addExecutionListener(listener);
            this._reconfigure(cFlags, cxxFlags, linkerFlags, otherOptions);
            AtomicBoolean atomicBoolean = finished;
            synchronized (atomicBoolean) {
                while (true) {
                    try {
                        do {
                            finished.wait();
                        } while (!finished.get());
                        return;
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        }
        this._reconfigure(cFlags, cxxFlags, linkerFlags, otherOptions);
    }

    private void _reconfigure(String cFlags, String cxxFlags, String linkerFlags, String otherOptions) {
        cFlags = this.escapeFlags(cFlags);
        cxxFlags = this.escapeFlags(cxxFlags);
        linkerFlags = this.escapeFlags(linkerFlags);
        this.cFlags = cFlags;
        this.cxxFlags = cxxFlags;
        this.linkerFlags = linkerFlags;
        if (this.cmake != null && this.make != null) {
            String arguments = this.getConfigureArguments(this.cmake.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
            ExecutionSupport ses = (ExecutionSupport)this.cmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (ses != null) {
                try {
                    List vars = ImportUtils.parseEnvironment((String)arguments);
                    for (String s : ImportUtils.quoteList((List)vars)) {
                        int i = arguments.indexOf(s);
                        if (i < 0) continue;
                        arguments = arguments.substring(0, i) + arguments.substring(i + s.length());
                    }
                    ses.setArguments(new String[]{arguments});
                    ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                        listener.executionStarted(pid);
                    }
                }

                public void executionFinished(int rc) {
                    if (rc == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                            listener.executionFinished(rc);
                        }
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.cmake.getPrimaryFile().getPath(), arguments});
            }
            if (this.canceled.get()) {
                listener.executionFinished(-1);
            } else {
                this.lastTask = CMakeAction.performAction((Node)this.cmake.getNodeDelegate(), (ExecutionListener)listener, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.qmake != null && this.make != null) {
            String arguments = this.getConfigureArguments(this.qmake.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
            ExecutionSupport ses = (ExecutionSupport)this.qmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (ses != null) {
                try {
                    ses.setArguments(new String[]{arguments});
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                        listener.executionStarted(pid);
                    }
                }

                public void executionFinished(int rc) {
                    if (rc == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                            listener.executionFinished(rc);
                        }
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.qmake.getPrimaryFile().getPath(), arguments});
            }
            if (this.canceled.get()) {
                listener.executionFinished(-1);
            } else {
                this.lastTask = QMakeAction.performAction((Node)this.qmake.getNodeDelegate(), (ExecutionListener)listener, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.configure != null && this.make != null) {
            String arguments = this.getConfigureArguments(this.configure.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
            ShellExecSupport ses = (ShellExecSupport)this.configure.getNodeDelegate().getCookie(ShellExecSupport.class);
            if (ses != null) {
                try {
                    ses.setArguments(new String[]{arguments});
                    List vars = ImportUtils.parseEnvironment((String)arguments);
                    ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                        listener.executionStarted(pid);
                    }
                }

                public void executionFinished(int rc) {
                    if (rc == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                            listener.executionFinished(rc);
                        }
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configure.getPrimaryFile().getPath(), arguments});
            }
            if (this.canceled.get()) {
                listener.executionFinished(-1);
            } else {
                this.lastTask = ShellRunAction.performAction((Node)this.configure.getNodeDelegate(), (ExecutionListener)listener, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.make != null) {
            this.postClean(true);
        } else assert (false);
    }

    private void postClean(final boolean notifyStart) {
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
                if (notifyStart) {
                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                        listener.executionStarted(pid);
                    }
                }
            }

            public void executionFinished(int rc) {
                ReconfigureProject.this.postMake();
            }
        };
        if (TRACE) {
            logger.log(Level.INFO, "#make -f {0} clean", this.make.getPrimaryFile().getPath());
        }
        if (this.canceled.get()) {
            listener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)this.make.getNodeDelegate(), (String)"clean", (ExecutionListener)listener, null, (Project)this.makeProject, null, (InputOutput)this.tab);
        }
    }

    private void postMake() {
        String arguments = this.getConfigureArguments(this.make.getPrimaryFile().getPath(), null, this.cFlags, this.cxxFlags, this.linkerFlags, this.isSunCompiler());
        if (TRACE) {
            logger.log(Level.INFO, "#make -f {0}", this.make.getPrimaryFile().getPath());
        }
        Node node = this.make.getNodeDelegate();
        ExecutionSupport ses = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        List vars = ImportUtils.parseEnvironment((String)arguments);
        if (ses != null) {
            try {
                ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                    listener.executionFinished(rc);
                }
            }
        };
        if (this.canceled.get()) {
            listener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)node, (String)"", (ExecutionListener)listener, null, (Project)this.makeProject, (List)vars, (InputOutput)this.tab);
        }
    }

    public void cancel() {
        this.canceled.set(true);
        Future<Integer> task = this.lastTask;
        if (task != null) {
            task.cancel(true);
        }
    }

    private String getConfigureArguments(String configure, String otherOptions, String cCompilerFlags, String cppCompilerFlags, String ldFlags, boolean isSunCompiler) {
        StringBuilder buf = new StringBuilder();
        if (otherOptions != null && otherOptions.length() > 0) {
            buf.append(otherOptions);
            buf.append(' ');
        }
        if (configure.endsWith("CMakeLists.txt")) {
            buf.append(" -G \"Unix Makefiles\"");
            buf.append(" -DCMAKE_BUILD_TYPE=Debug");
            buf.append(" -DCMAKE_C_COMPILER=").append(this.getCCompilerName());
            buf.append(" -DCMAKE_CXX_COMPILER=").append(this.getCppCompilerName());
            buf.append(" -DCMAKE_C_FLAGS_DEBUG=").append(cCompilerFlags);
            buf.append(" -DCMAKE_CXX_FLAGS_DEBUG=").append(cppCompilerFlags);
            buf.append(" -DCMAKE_EXE_LINKER_FLAGS_DEBUG=").append(ldFlags);
        } else if (configure.endsWith(".pro")) {
            if (isSunCompiler && (this.platform == 1 || this.platform == 0)) {
                buf.append(" -spec solaris-cc");
            }
            if (this.platform == 4) {
                buf.append(" -spec macx-g++");
            }
            buf.append(" QMAKE_CC=").append(this.getCCompilerName());
            buf.append(" QMAKE_CXX=").append(this.getCppCompilerName());
            buf.append(" QMAKE_CFLAGS=").append(cCompilerFlags);
            buf.append(" QMAKE_CXXFLAGS=").append(cppCompilerFlags);
            buf.append(" QMAKE_LDFLAGS=").append(ldFlags);
        } else {
            buf.append(" CC=").append(this.getCCompilerName());
            buf.append(" CXX=").append(this.getCppCompilerName());
            buf.append(" CFLAGS=").append(cCompilerFlags);
            buf.append(" CXXFLAGS=").append(cppCompilerFlags);
            buf.append(" LDFLAGS=").append(ldFlags);
        }
        return buf.toString();
    }

    public CompilerOptions getLastCompilerOptions() {
        String lastFlags = this.getLastFlags();
        if (lastFlags == null) {
            return null;
        }
        DataObject dao = this.getImportant();
        if (dao == null) {
            return null;
        }
        String mime = dao.getPrimaryFile().getMIMEType();
        CompilerOptions options = new CompilerOptions();
        if ("text/sh".equals(mime)) {
            options.CFlags = this.getFlags(lastFlags, "CFLAGS=");
            options.CppFlags = this.getFlags(lastFlags, "CXXFLAGS=");
            options.CCompiler = this.getFlags(lastFlags, "CC=");
            options.CppCompiler = this.getFlags(lastFlags, "CXX=");
            options.LinkerFlags = this.getFlags(lastFlags, "LDFLAGS=");
        } else if ("text/x-cmake".equals(mime)) {
            options.CFlags = this.getFlags(lastFlags, "-DCMAKE_C_FLAGS_DEBUG=");
            options.CppFlags = this.getFlags(lastFlags, "-DCMAKE_CXX_FLAGS_DEBUG=");
            options.CCompiler = this.getFlags(lastFlags, "-DCMAKE_C_COMPILER=");
            options.CppCompiler = this.getFlags(lastFlags, "-DCMAKE_CXX_COMPILER=");
            options.LinkerFlags = this.getFlags(lastFlags, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=");
        } else if ("text/x-qtproject".equals(mime)) {
            options.CFlags = this.getFlags(lastFlags, "QMAKE_CFLAGS=");
            options.CppFlags = this.getFlags(lastFlags, "QMAKE_CXXFLAGS=");
            options.CCompiler = this.getFlags(lastFlags, "QMAKE_CC=");
            options.CppCompiler = this.getFlags(lastFlags, "QMAKE_CXX=");
            options.LinkerFlags = this.getFlags(lastFlags, "QMAKE_LDFLAGS=");
        } else if ("text/x-make".equals(mime)) {
            options.CFlags = this.getFlags(lastFlags, "CFLAGS=");
            options.CppFlags = this.getFlags(lastFlags, "CXXFLAGS=");
            options.CCompiler = this.getFlags(lastFlags, "CC=");
            options.CppCompiler = this.getFlags(lastFlags, "CXX=");
            options.LinkerFlags = this.getFlags(lastFlags, "LDFLAGS=");
        }
        return options;
    }

    public String getRestOptions() {
        String lastFlags = this.getLastFlags();
        if (lastFlags == null) {
            return "";
        }
        DataObject dao = this.getImportant();
        if (dao == null) {
            return "";
        }
        String mime = dao.getPrimaryFile().getMIMEType();
        if ("text/sh".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "CFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "CXXFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "CC=", false);
            lastFlags = this.removeFlag(lastFlags, "CXX=", false);
            lastFlags = this.removeFlag(lastFlags, "LDFLAGS=", false);
        } else if ("text/x-cmake".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_BUILD_TYPE=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_C_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_CXX_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_C_COMPILER=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_CXX_COMPILER=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-G", false);
        } else if ("text/x-qtproject".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CXXFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CC=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CXX=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_LDFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "-spec solaris-cc", true);
            lastFlags = this.removeFlag(lastFlags, "-spec macx-g++", true);
        } else if ("text/x-make".equals(mime)) {
            return "";
        }
        return lastFlags.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String removeFlag(String flags, String key, boolean noValue) {
        int i = flags.indexOf(key);
        if (i < 0) return flags.trim();
        if (key.charAt(key.length() - 1) == '=') {
            String rest = flags.substring(i + key.length());
            if (rest.startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return flags.trim();
                return flags.substring(0, i) + rest.substring(j + 1);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return flags.substring(0, i);
            return flags.substring(0, i) + rest.substring(j + 1);
        }
        String rest = flags.substring(i + key.length());
        if (rest.startsWith(" ")) {
            if (noValue) {
                return flags.substring(0, i) + rest;
            }
            if ((rest = rest.substring(1)).startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return flags.trim();
                return flags.substring(0, i) + rest.substring(j + 1);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return flags.substring(0, i);
            return flags.substring(0, i) + rest.substring(j + 1);
        }
        if (rest.length() != 0) return flags.trim();
        return flags.substring(0, i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFlags(String flags, String key) {
        int i = flags.indexOf(key);
        if (i < 0) return null;
        if (key.charAt(key.length() - 1) == '=') {
            String rest = flags.substring(i + key.length());
            if (rest.startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return null;
                return rest.substring(1, j);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return rest;
            return rest.substring(0, j);
        }
        String rest = flags.substring(i + key.length());
        if (rest.startsWith(" ")) {
            if ((rest = rest.substring(1)).startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return null;
                return rest.substring(1, j);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return rest;
            return rest.substring(0, j);
        }
        if (rest.length() != 0) return null;
        return "";
    }

    public boolean isSunCompiler() {
        return this.isSunCompiler;
    }

    public CompilerSet getCompilerSet() {
        return this.compilerSet;
    }

    private String getCCompilerName() {
        String path = this.getToolPath(PredefinedToolKind.CCompiler);
        if (path == null) {
            if (this.isSunCompiler()) {
                return "cc";
            }
            return "gcc";
        }
        return path;
    }

    private String getCppCompilerName() {
        String path = this.getToolPath(PredefinedToolKind.CCCompiler);
        if (path == null) {
            if (this.isSunCompiler()) {
                return "CC";
            }
            return "g++";
        }
        return path;
    }

    private String getToolPath(PredefinedToolKind tool) {
        Tool compiler = this.compilerSet.findTool((ToolKind)tool);
        if (compiler == null) {
            return null;
        }
        return this.escapeFlags(compiler.getPath());
    }

    public DataObject getImportant() {
        if (this.cmake != null && this.make != null) {
            return this.cmake;
        }
        if (this.qmake != null && this.make != null) {
            return this.qmake;
        }
        if (this.configure != null && this.make != null) {
            return this.configure;
        }
        if (this.make != null) {
            return this.make;
        }
        return null;
    }

    public String getLastFlags() {
        String[] args;
        ExecutionSupport ses;
        if (this.cmake != null && this.make != null) {
            String[] args2;
            ExecutionSupport ses2 = (ExecutionSupport)this.cmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (ses2 != null && (args2 = ses2.getArguments()) != null && args2.length > 0) {
                return args2[0];
            }
        } else if (this.qmake != null && this.make != null) {
            String[] args3;
            ExecutionSupport ses3 = (ExecutionSupport)this.qmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (ses3 != null && (args3 = ses3.getArguments()) != null && args3.length > 0) {
                return args3[0];
            }
        } else if (this.configure != null && this.make != null) {
            String[] args4;
            ShellExecSupport ses4 = (ShellExecSupport)this.configure.getNodeDelegate().getCookie(ShellExecSupport.class);
            if (ses4 != null && (args4 = ses4.getArguments()) != null && args4.length > 0) {
                return args4[0];
            }
        } else if (this.make != null && (ses = (ExecutionSupport)this.make.getNodeDelegate().getCookie(ExecutionSupport.class)) != null && (args = ses.getEnvironmentVariables()) != null && args.length > 0) {
            List list = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i]);
            }
            list = ImportUtils.quoteList(list);
            StringBuilder b = new StringBuilder();
            for (String s : list) {
                b.append(s).append(' ');
            }
            return b.toString();
        }
        return null;
    }

    public static final class CompilerOptions {
        public String CFlags;
        public String CppFlags;
        public String CCompiler;
        public String CppCompiler;
        public String LinkerFlags;
    }
}

