/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class HashMapRepository
implements Repository {
    private final Map<CharSequence, Unit> units;
    private final Object unitsLock = new Lock();

    public void debugDistribution() {
    }

    public HashMapRepository() {
        this.units = new ConcurrentHashMap<CharSequence, Unit>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getUnit(CharSequence name) {
        assert (name != null);
        Unit unit = this.units.get(name);
        if (unit == null) {
            Object object = this.unitsLock;
            synchronized (object) {
                unit = this.units.get(name);
                if (unit == null) {
                    unit = new Unit(name);
                    this.units.put(name, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent obj) {
        assert (obj != null);
        this.getUnit(key.getUnit()).put(key, obj);
    }

    public Persistent get(Key key) {
        return this.getUnit(key.getUnit()).get(key);
    }

    public Persistent tryGet(Key key) {
        return this.get(key);
    }

    public void remove(Key key) {
        this.getUnit(key.getUnit()).remove(key);
    }

    public void hang(Key key, Persistent obj) {
        this.put(key, obj);
    }

    public void debugClear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.unitsLock;
        synchronized (object) {
            this.units.clear();
        }
    }

    public void openUnit(int unitId, String unitName) {
    }

    public synchronized void closeUnit(String unitName, boolean cleanRepository, Set<String> requiredUnits) {
        this.removeUnit(unitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeUnit(String unitName) {
        Iterator<CharSequence> iter = this.units.keySet().iterator();
        while (iter.hasNext()) {
            CharSequence key = iter.next();
            if (!((Object)key).toString().equals(unitName)) continue;
            Object object = this.unitsLock;
            synchronized (object) {
                iter.remove();
                return;
            }
        }
    }

    public void cleanCaches() {
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
    }

    public void startup(int persistMechanismVersion) {
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static class Unit {
        private Map<Key, Persistent> map = new ConcurrentHashMap<Key, Persistent>();
        private CharSequence name;

        public Unit(CharSequence name) {
            this.name = name;
        }

        public void put(Key key, Persistent obj) {
            assert (key.getUnit().equals(this.name));
            this.map.put(key, obj);
        }

        public Persistent get(Key key) {
            assert (key.getUnit().equals(this.name));
            return this.map.get(key);
        }

        void remove(Key key) {
            assert (key.getUnit().equals(this.name));
            this.map.remove(key);
        }
    }
}

