/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class DataTableMetadataFactory {
    static final HashMap<String, Class<?>> stringToClass = new HashMap();

    static DataTableMetadata create(Map map) {
        try {
            FileObject rootFolder = FileUtil.getConfigRoot();
            String columnsFolderPath = (String)map.get("columns");
            FileObject columnsFolder = rootFolder.getFileObject(columnsFolderPath);
            List columns = (List)columnsFolder.getAttribute("instanceCreate");
            if (columns == null) {
                return null;
            }
            return new DataTableMetadata((String)map.get("name"), columns, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static List<DataTableMetadata.Column> createColumnsList(Map<?, ?> map) {
        try {
            FileObject rootFolder = FileUtil.getConfigRoot();
            String columnsFolderPath = (String)map.get("columns");
            FileObject columnsFolder = rootFolder.getFileObject(columnsFolderPath);
            FileObject[] columnFiles = columnsFolder.getChildren();
            ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
            for (int i = 0; i < columnFiles.length; ++i) {
                Object obj = columnFiles[i].getAttribute("instanceCreate");
                if (obj == null || !(obj instanceof DataTableMetadata.Column)) continue;
                columns.add((DataTableMetadata.Column)obj);
            }
            return columns;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static DataTableMetadata.Column createColumn(Map map) {
        try {
            Class<Object> clazz;
            String expression;
            String shortName;
            String name;
            block4: {
                name = DataTableMetadataFactory.getStringValue(map, "name");
                shortName = DataTableMetadataFactory.getStringValue(map, "shortname");
                expression = DataTableMetadataFactory.getStringValue(map, "expression");
                try {
                    clazz = Class.forName(DataTableMetadataFactory.getStringValue(map, "class"));
                }
                catch (ClassNotFoundException ex) {
                    clazz = stringToClass.get(DataTableMetadataFactory.getStringValue(map, "class"));
                    if (clazz != null) break block4;
                    clazz = String.class;
                }
            }
            return new DataTableMetadata.Column(name, clazz, shortName, shortName, expression);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getStringValue(Map map, String key) {
        return (String)map.get(key);
    }

    static {
        stringToClass.put("byte", Byte.class);
        stringToClass.put("short", Short.class);
        stringToClass.put("int", Integer.class);
        stringToClass.put("long", Long.class);
        stringToClass.put("double", Double.class);
        stringToClass.put("float", Float.class);
        stringToClass.put("string", String.class);
        stringToClass.put("timestamp", Time.class);
    }
}

