/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.List;
import org.netbeans.modules.dlight.util.DLightLogger;

public final class DataRow {
    private List<String> colnames;
    private List<? extends Object> data;

    public DataRow(List<String> colnames, List<? extends Object> data) {
        this.colnames = colnames;
        DLightLogger.assertTrue((data != null ? 1 : 0) != 0, (String)"data parameter should not be null");
        this.data = data;
    }

    public Long getLongValue(String columnName) {
        Long result = null;
        int idx = this.colnames.indexOf(columnName);
        if (idx >= 0) {
            result = (Long)this.data.get(idx);
        }
        return result;
    }

    public String getStringValue(String columnName) {
        return this.getStringValue(this.colnames.indexOf(columnName));
    }

    public String getStringValue(int idx) {
        String result = null;
        if (idx >= 0) {
            result = String.valueOf(this.data.get(idx));
        }
        return result;
    }

    public Double getDoubleValue(String columnName) {
        return this.getDoubleValue(this.colnames.indexOf(columnName));
    }

    public Double getDoubleValue(int idx) {
        Double result = null;
        if (idx >= 0) {
            result = (Double)this.data.get(idx);
        }
        return result;
    }

    public Float getFloatValue(String columnName) {
        return this.getFloatValue(this.colnames.indexOf(columnName));
    }

    public Float getFloatValue(int idx) {
        Float result = null;
        if (idx >= 0) {
            result = (Float)this.data.get(idx);
        }
        return result;
    }

    public List<String> getColumnNames() {
        return this.colnames;
    }

    public List<? extends Object> getData() {
        return this.data;
    }

    public Object getData(String columnName) {
        int idx = this.colnames.indexOf(columnName);
        if (idx >= 0) {
            return this.data.get(idx);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(" *");
        for (String string : this.colnames) {
            sb.append(string).append("* | *");
        }
        sb.append("\n");
        for (Object object : this.data) {
            sb.append(object.toString()).append(" | ");
        }
        return sb.toString();
    }
}

