/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;

public final class DLightToolConfiguration {
    private final String id;
    private final List<DataCollectorConfiguration> dataCollectors;
    private final List<IndicatorDataProviderConfiguration> indicatorDataProvidersConfiguration;
    private final List<IndicatorConfiguration> indicators;
    private String shortName;
    private String longName;
    private boolean visible;
    private String iconPath = null;
    private String shortDescription;
    FeatureDescriptor detailsDescription;

    public DLightToolConfiguration(String id) {
        this(id, id);
    }

    public DLightToolConfiguration(String id, String name) {
        this.id = id;
        this.shortName = name;
        this.longName = name;
        this.visible = true;
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = Collections.synchronizedList(new ArrayList());
        this.indicatorDataProvidersConfiguration = Collections.synchronizedList(new ArrayList());
    }

    public void setFeatureDescriptor(FeatureDescriptor descriptor) {
        this.detailsDescription = descriptor;
    }

    public void addDataCollectorConfiguration(DataCollectorConfiguration collector) {
        this.dataCollectors.add(collector);
    }

    public void setIcon(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setDescription(String description) {
        this.shortDescription = description;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getID() {
        return this.id;
    }

    public void addIndicatorConfiguration(IndicatorConfiguration indicator) {
        this.indicators.add(indicator);
    }

    public void addIndicatorDataProviderConfiguration(IndicatorDataProviderConfiguration indDataProvider) {
        if (indDataProvider == null) {
            throw new NullPointerException("An attempt to add NULL IndicatorDataProviderConfiguration");
        }
        this.indicatorDataProvidersConfiguration.add(indDataProvider);
    }

    List<DataCollectorConfiguration> getDataCollectors() {
        return this.dataCollectors;
    }

    List<IndicatorDataProviderConfiguration> getIndicatorDataProviders() {
        return this.indicatorDataProvidersConfiguration;
    }

    List<IndicatorConfiguration> getIndicators() {
        return this.indicators;
    }

    String getShortName() {
        return this.shortName;
    }

    String getLongName() {
        return this.longName;
    }

    String getDescription() {
        return this.shortDescription;
    }

    boolean isVisible() {
        return this.visible;
    }

    static {
        DLightToolConfigurationAccessor.setDefault(new DLightToolConfigurationAccessorImpl());
    }

    private static final class DLightToolConfigurationAccessorImpl
    extends DLightToolConfigurationAccessor {
        private DLightToolConfigurationAccessorImpl() {
        }

        @Override
        public List<DataCollectorConfiguration> getDataCollectors(DLightToolConfiguration conf) {
            return conf.getDataCollectors();
        }

        @Override
        public List<IndicatorDataProviderConfiguration> getIndicatorDataProviders(DLightToolConfiguration conf) {
            return conf.getIndicatorDataProviders();
        }

        @Override
        public List<IndicatorConfiguration> getIndicators(DLightToolConfiguration conf) {
            return conf.getIndicators();
        }

        @Override
        public String getToolName(DLightToolConfiguration conf) {
            return conf.getShortName();
        }

        @Override
        public String getDetailedToolName(DLightToolConfiguration conf) {
            return conf.getLongName();
        }

        @Override
        public String getIconPath(DLightToolConfiguration conf) {
            return conf.iconPath;
        }

        @Override
        public String getToolDescription(DLightToolConfiguration conf) {
            return conf.getDescription();
        }
    }
}

