/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.Classes;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ClassicModuleJCRD;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.ExtendedModuleJCRD;
import com.sun.javacard.validator.FolderOrJar;
import com.sun.javacard.validator.JavaCardXML;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.WebModule;
import com.sun.javacard.validator.WebModuleJCRD;
import java.io.File;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public abstract class Module
extends FolderOrJar {
    protected Classes classes;
    private JavaCardXML javaCardXML;
    protected ModuleJCRD jcrd;

    public Module(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        File file = new File(this.folder, "META-INF/MANIFEST.MF");
        if (!file.exists()) {
            this.addError(ErrorKey.JCRDDoesNotExist, new Object[0]);
        } else {
            if (this instanceof WebModule) {
                this.jcrd = new WebModuleJCRD(this, file);
            } else if (this instanceof ExtendedModule) {
                this.jcrd = new ExtendedModuleJCRD(this, file);
            } else if (this instanceof ClassicModule) {
                this.jcrd = new ClassicModuleJCRD(this, file);
            }
            this.addItem(this.jcrd);
            this.jcrd.initialize();
        }
        File file2 = new File(this.folder, "META-INF/javacard.xml");
        if (file2.exists()) {
            this.javaCardXML = new JavaCardXML(file2);
            this.addItem(this.javaCardXML);
            this.javaCardXML.initialize();
        }
    }

    @Override
    public void processInternal() {
        if (!this.isOk()) {
            return;
        }
        this.jcrd.process();
        if (this.javaCardXML != null) {
            this.javaCardXML.process();
        }
        this.classes.processInternal();
    }

    @Override
    public String getItemDisplayName() {
        return "Module[" + this.folder.getName() + "]";
    }

    public boolean hasClass(String string) {
        if (this.classes.containsInAPI(string)) {
            return true;
        }
        return this.classes.getNames().contains(string);
    }

    private InputStream getClassFileStream(String string) {
        return this.classes.getClassFileStream(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterface(String string) throws Exception {
        InputStream inputStream = this.getClassFileStream(string);
        if (inputStream == null) {
            throw new Exception("class does not exists");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(inputStream, "dummy");
            javaClass = classParser.parse();
            boolean bl = javaClass.isInterface();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublic(String string) throws Exception {
        InputStream inputStream = this.getClassFileStream(string);
        if (inputStream == null) {
            throw new Exception("class does not exists");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(inputStream, "dummy");
            javaClass = classParser.parse();
            boolean bl = javaClass.isPublic();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConcreteClass(String string) {
        InputStream inputStream = this.getClassFileStream(string);
        if (inputStream == null) {
            return false;
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(inputStream, "dummy");
            javaClass = classParser.parse();
            if (javaClass.isAbstract() || javaClass.isAbstract()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShareableInterface(String string) throws Exception {
        if (string.equals("javacard.framework.Shareable")) {
            return true;
        }
        InputStream inputStream = this.getClassFileStream(string);
        if (inputStream == null) {
            throw new Exception("File for class " + string + " does not exists.");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(inputStream, "dummy");
            javaClass = classParser.parse();
            if (javaClass.isInterface()) {
                for (String string2 : javaClass.getInterfaceNames()) {
                    if (!this.isShareableInterface(string2)) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            int n = 0;
            return n != 0;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public JavaCardXML getJavaCardXML() {
        return this.javaCardXML;
    }

    public ModuleJCRD getJCRD() {
        return this.jcrd;
    }

    public Classes getClasses() {
        return this.classes;
    }
}

