/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.openide.util.Exceptions;

public class PHyperlinkProcessor
extends HyperlinkProcessor {
    private BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);

    @Override
    public void process(HyperlinkEnv hyperlinkEnv) {
        String string = hyperlinkEnv.getAttribName();
        if (hyperlinkEnv.getType().isValueHyperlink()) {
            if (string.endsWith("-ref")) {
                this.beansRefHyperlinkProcessor.process(hyperlinkEnv);
            }
        } else if (hyperlinkEnv.getType().isAttributeHyperlink()) {
            String string2;
            String string3 = ContextUtilities.getLocalNameFromTag(string);
            if (string3.endsWith("-ref")) {
                string3 = string3.substring(0, string3.indexOf("-ref"));
            }
            if ((string2 = new BeanClassFinder(hyperlinkEnv.getBeanAttributes(), hyperlinkEnv.getFileObject()).findImplementationClass()) == null) {
                return;
            }
            JavaSource javaSource = JavaUtils.getJavaSource(hyperlinkEnv.getFileObject());
            if (javaSource == null) {
                return;
            }
            final String string4 = string3;
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        ElementUtilities elementUtilities = compilationController.getElementUtilities();
                        if (string2 == null) {
                            return;
                        }
                        TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string2, compilationController);
                        Property[] propertyArray = new PropertyFinder(typeElement.asType(), string4, elementUtilities, MatchType.PREFIX).findProperties();
                        if (propertyArray.length > 0 && propertyArray[0].getSetter() != null) {
                            ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)propertyArray[0].getSetter());
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv hyperlinkEnv) {
        if (hyperlinkEnv.getType().isValueHyperlink()) {
            return super.getSpan(hyperlinkEnv);
        }
        if (hyperlinkEnv.getType().isAttributeHyperlink()) {
            return new int[]{hyperlinkEnv.getTokenStartOffset(), hyperlinkEnv.getTokenEndOffset()};
        }
        return null;
    }
}

