/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.jumpto;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.jumpto.AbstractBeanTypeDescriptor;
import org.netbeans.modules.spring.beans.jumpto.BeanAliasTypeDescriptor;
import org.netbeans.modules.spring.beans.jumpto.BeanTypeDescriptor;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SpringBeansTypeProvider
implements TypeProvider {
    private Set<AbstractBeanTypeDescriptor> cache;
    private String lastRefreshText;
    private SearchType lastRefreshSearchType;
    private volatile boolean isCancelled = false;

    public String name() {
        return "springbeans";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SpringBeansTypeProvider.class, (String)"LBL_SpringBeansType");
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        SearchType searchType;
        assert (context.getProject() == null);
        this.isCancelled = false;
        boolean cacheRefresh = false;
        String searchText = context.getText();
        final NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)searchText, (SearchType)(searchType = context.getSearchType()));
        if (matcher == null) {
            return;
        }
        if (this.lastRefreshText == null || this.lastRefreshSearchType == null || !searchText.startsWith(this.lastRefreshText) || this.lastRefreshSearchType != searchType || this.cache == null) {
            cacheRefresh = true;
            final HashSet<AbstractBeanTypeDescriptor> currCache = new HashSet<AbstractBeanTypeDescriptor>();
            Future prjHandle = OpenProjects.getDefault().openProjects();
            Project[] projects = null;
            try {
                projects = (Project[])prjHandle.get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (projects == null) {
                return;
            }
            if (this.isCancelled) {
                return;
            }
            for (Project project : projects) {
                SpringScope scope;
                ProjectSpringScopeProvider scopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
                if (scopeProvider == null || (scope = scopeProvider.getSpringScope()) == null) continue;
                if (this.isCancelled) {
                    return;
                }
                final HashSet processed = new HashSet();
                List<SpringConfigModel> models = scope.getAllConfigModels();
                for (SpringConfigModel model : models) {
                    try {
                        if (this.isCancelled) {
                            return;
                        }
                        model.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                            @Override
                            public void run(SpringConfigModel.DocumentAccess docAccess) {
                                File file = docAccess.getFile();
                                if (processed.contains(file)) {
                                    return;
                                }
                                processed.add(file);
                                if (SpringBeansTypeProvider.this.isCancelled) {
                                    return;
                                }
                                FileObject fo = docAccess.getFileObject();
                                FileSpringBeans fileBeans = docAccess.getSpringBeans().getFileBeans(fo);
                                List<SpringBean> beans = fileBeans.getBeans();
                                for (SpringBean bean : beans) {
                                    String id = bean.getId();
                                    if (id != null && matcher.accept(id)) {
                                        currCache.add(new BeanTypeDescriptor(id, bean));
                                    }
                                    for (String name : bean.getNames()) {
                                        if (!matcher.accept(name)) continue;
                                        currCache.add(new BeanTypeDescriptor(name, bean));
                                    }
                                }
                                for (String alias : fileBeans.getAliases()) {
                                    if (!matcher.accept(alias)) continue;
                                    currCache.add(new BeanAliasTypeDescriptor(alias, fo));
                                }
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            if (!this.isCancelled) {
                this.cache = currCache;
                this.lastRefreshText = searchText;
                this.lastRefreshSearchType = searchType;
            }
        }
        if (this.cache != null) {
            ArrayList<AbstractBeanTypeDescriptor> beans = new ArrayList<AbstractBeanTypeDescriptor>(this.cache.size());
            for (AbstractBeanTypeDescriptor beanTypeDescriptor : this.cache) {
                if (!cacheRefresh && !matcher.accept(beanTypeDescriptor.getSimpleName())) continue;
                beans.add(beanTypeDescriptor);
            }
            result.addResult(beans);
        }
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void cleanup() {
        this.isCancelled = false;
        this.cache = null;
        this.lastRefreshText = null;
        this.lastRefreshSearchType = null;
    }
}

