/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.execute;

import java.io.File;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.MavenJavaExecutor;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.util.NbBundle;

public final class RunUtils {
    private static boolean warningShown = false;

    private RunUtils() {
    }

    public static ExecutorTask executeMaven(RunConfig config) {
        AbstractMavenExecutor exec;
        AuxiliaryProperties props;
        String val;
        boolean useEmbedded = false;
        if (config.getProject() != null && "false".equalsIgnoreCase(val = (props = (AuxiliaryProperties)config.getProject().getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.useExternalMaven", true))) {
            useEmbedded = true;
        }
        if (!useEmbedded && MavenSettings.canFindExternalMaven()) {
            exec = new MavenCommandLineExecutor(config);
        } else {
            if (!warningShown && DontShowAgainSettings.getDefault().showWarningAboutEmbeddedBuild()) {
                WarnPanel panel = new WarnPanel(NbBundle.getMessage(RunUtils.class, (String)"HINT_EmbeddedBuild"));
                NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (panel.disabledWarning()) {
                    DontShowAgainSettings.getDefault().dontshowWarningAboutEmbeddedBuildAnymore();
                }
                warningShown = true;
            }
            exec = new MavenJavaExecutor(config);
        }
        return RunUtils.executeMavenImpl(config.getTaskDisplayName(), exec);
    }

    public static RunConfig createRunConfig(File execDir, Project prj, String displayName, List<String> goals) {
        BeanRunConfig brc = new BeanRunConfig();
        brc.setExecutionName(displayName);
        brc.setExecutionDirectory(execDir);
        brc.setProject(prj);
        brc.setTaskDisplayName(displayName);
        brc.setGoals(goals);
        return brc;
    }

    private static ExecutorTask executeMavenImpl(String runtimeName, MavenExecutor exec) {
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, exec.getInputOutput());
        exec.setTask(task);
        return task;
    }

    public static boolean hasApplicationCompileOnSaveEnabled(Project prj) {
        String cos = ((AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.compile.on.save", true);
        return cos != null && ("all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos));
    }

    public static boolean hasApplicationCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasApplicationCompileOnSaveEnabled(prj);
        }
        return false;
    }

    public static boolean hasTestCompileOnSaveEnabled(Project prj) {
        String cos = ((AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.compile.on.save", true);
        return cos == null || "all".equalsIgnoreCase(cos) || "test".equalsIgnoreCase(cos);
    }

    public static boolean hasTestCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasTestCompileOnSaveEnabled(prj);
        }
        return false;
    }
}

