/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SelectReactorDirectoryPanel
extends JPanel {
    private File basedir;
    private Project project;
    private JButton btnDirectory;
    private JButton btnReactor;
    private JLabel lblDirectory;
    private JLabel lblText;
    private JTextField txtDirectory;

    public SelectReactorDirectoryPanel(File basedir, Project prj) {
        this.initComponents();
        this.btnReactor.setCursor(Cursor.getPredefinedCursor(12));
        this.btnReactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://maven.apache.org/plugins/maven-reactor-plugin/index.html"));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.basedir = basedir;
        this.project = prj;
        String relative = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), basedir);
        this.txtDirectory.setText(relative);
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.btnReactor = new JButton();
        this.lblDirectory = new JLabel();
        this.txtDirectory = new JTextField();
        this.btnDirectory = new JButton();
        this.lblText.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.lblText.text"));
        this.lblText.setVerticalAlignment(1);
        this.btnReactor.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.btnReactor.text"));
        this.btnReactor.setBorderPainted(false);
        this.btnReactor.setContentAreaFilled(false);
        this.btnReactor.setHorizontalAlignment(4);
        this.lblDirectory.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.lblDirectory.text"));
        this.txtDirectory.setEditable(false);
        this.btnDirectory.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.btnDirectory.text"));
        this.btnDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectReactorDirectoryPanel.this.btnDirectoryActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.lblText, -1, 488, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblDirectory).addPreferredGap(0).add((Component)this.txtDirectory, -1, 143, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnDirectory)).add((Component)this.btnReactor)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.lblText, -1, 118, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnReactor).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblDirectory).add((Component)this.txtDirectory, -2, -1, -2).add((Component)this.btnDirectory)).add(24, 24, 24)));
    }

    private void btnDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"TIT_ReactorDir"));
        FileObject current = this.project.getProjectDirectory();
        String rel = this.txtDirectory.getText().trim();
        if (rel.length() == 0) {
            rel = "../";
        }
        File selected = FileUtilities.resolveFilePath(FileUtil.toFile((FileObject)current), rel);
        chooser.setSelectedFile(selected);
        int ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"BTN_ReactorDir"));
        if (ret == 0) {
            selected = chooser.getSelectedFile();
            String relative = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)current), selected);
            this.txtDirectory.setText(relative);
        }
    }

    public String getRelativePath() {
        return this.txtDirectory.getText();
    }
}

