/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class GotoActionView
extends AbstractAction {
    public GotoActionView() {
        super(NbBundle.getMessage(GotoActionView.class, (String)"rails-goto-action-view"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GotoActionView.class).getString("editor-popup-goto-action-view"));
    }

    private FileObject getCurrentFile() {
        Node[] activatedNodes = TopComponent.getRegistry().getActivatedNodes();
        if (activatedNodes == null || activatedNodes.length != 1) {
            return null;
        }
        DataObject dobj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dobj == null) {
            return null;
        }
        FileObject fo = dobj.getPrimaryFile();
        return fo;
    }

    @Override
    public boolean isEnabled() {
        FileObject fo = this.getCurrentFile();
        if (fo == null) {
            return false;
        }
        String mimeType = fo.getMIMEType();
        if ("application/x-httpd-eruby".equals(mimeType)) {
            return true;
        }
        if ("text/x-ruby".equals(mimeType)) {
            String name = fo.getName();
            if (name.endsWith("_controller") || name.endsWith("_helper")) {
                return true;
            }
            if (this.isModel(fo)) {
                return true;
            }
            String ext = fo.getExt();
            if (!ext.equals("rb")) {
                for (String e : RubyUtils.RUBY_VIEW_EXTS) {
                    if (!ext.equalsIgnoreCase(e)) continue;
                    return true;
                }
            }
            return false;
        }
        return "haml".equals(fo.getExt());
    }

    private boolean isModel(FileObject fo) {
        FileObject grandParent;
        FileObject parent = fo.getParent();
        if (parent == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        while (parent != null && !GotoActionView.isProjectDir(project, parent) && !"app".equals(parent.getName()) && (grandParent = parent.getParent()) != null) {
            if ("models".equals(parent.getName()) && "app".equals(grandParent.getName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean isProjectDir(Project project, FileObject fo) {
        if (project == null) {
            return false;
        }
        return project.getProjectDirectory().equals(fo);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JTextComponent pane = GsfUtilities.getOpenPane();
        FileObject fo = this.getCurrentFile();
        if (fo != null && pane != null) {
            this.actionPerformed(pane, fo);
        }
    }

    private void actionPerformed(JTextComponent target, FileObject fo) {
        if (fo != null) {
            if (fo.getName().endsWith("_controller")) {
                this.gotoView(target, fo, "_controller", "controllers");
            } else if (fo.getName().endsWith("_helper")) {
                this.gotoView(target, fo, "_helper", "helpers");
            } else if (this.isModel(fo)) {
                this.gotoView(target, fo, "", "models");
            } else if (RubyUtils.isRhtmlFile((FileObject)fo)) {
                this.gotoAction(target, fo);
            } else {
                String ext = fo.getExt();
                for (String e : RubyUtils.RUBY_VIEW_EXTS) {
                    if (!ext.equalsIgnoreCase(e)) continue;
                    this.gotoAction(target, fo);
                    return;
                }
                Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToControllers"));
            }
        }
    }

    private void notFound(JTextComponent target) {
        Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(GotoActionView.class, (String)"ControllerNotFound"));
    }

    private void gotoView(JTextComponent target, FileObject file, String fileSuffix, String parentAppDir) {
        String methodName;
        FileObject viewFile;
        if (!file.getName().endsWith(fileSuffix) && !this.isModel(file)) {
            Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToActions"));
            return;
        }
        FileObject controllerFile = file;
        int offset = 0;
        if (target.getCaret() != null) {
            offset = target.getCaret().getDot();
        }
        if ((viewFile = RubyUtils.getRailsViewFor((FileObject)file, (String)(methodName = AstUtilities.getMethodName((FileObject)controllerFile, (int)offset)), (String)fileSuffix, (String)parentAppDir, (boolean)false)) == null) {
            this.notFound(target);
        } else {
            GsfUtilities.open((FileObject)viewFile, (int)0, null);
        }
    }

    private void gotoAction(JTextComponent target, FileObject file) {
        String ext = file.getExt();
        boolean found = false;
        for (String e : RubyUtils.RUBY_VIEW_EXTS) {
            if (!ext.equalsIgnoreCase(e)) continue;
            found = true;
            break;
        }
        if (!RubyUtils.isRhtmlFile((FileObject)file) && !found) {
            Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToViews"));
            return;
        }
        FileObject controllerFile = RubyUtils.getRailsControllerFor((FileObject)file);
        String action = this.getActionName(file);
        if (controllerFile == null) {
            this.notFound(target);
            return;
        }
        int offset = AstUtilities.findOffset((FileObject)controllerFile, (String)action);
        GsfUtilities.open((FileObject)controllerFile, (int)offset, (String)("def " + action));
    }

    private String getActionName(FileObject view) {
        String action = view.getName();
        int dot = action.indexOf(".");
        if (dot != -1) {
            action = action.substring(0, dot);
        }
        return action;
    }
}

