/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerUiUtils;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProjectVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsInstallationValidator;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public final class PanelConfigureProject
implements WizardDescriptor.Panel,
WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    private WizardDescriptor wizardDescriptor;
    private int type;
    private PanelConfigureProjectVisual component;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public PanelConfigureProject(int type) {
        this.type = type;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new PanelConfigureProjectVisual(this, this.type);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        switch (this.type) {
            case 0: {
                return new HelpCtx(this.getClass().getName() + "_APP");
            }
            case 2: {
                return new HelpCtx(this.getClass().getName() + "_EXT");
            }
        }
        return new HelpCtx(PanelConfigureProject.class);
    }

    public boolean isValid() {
        this.getComponent();
        return this.component.valid(this.wizardDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.component.read(this.wizardDescriptor);
        Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
        if (substitute != null) {
            this.wizardDescriptor.putProperty("NewProjectWizard_Title", substitute);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor d = (WizardDescriptor)settings;
        this.component.store(d);
        d.putProperty("NewProjectWizard_Title", null);
    }

    public boolean isFinishPanel() {
        RubyPlatform platform = this.component.getPlatform();
        if (platform == null) {
            return false;
        }
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null) {
            return false;
        }
        if (this.component.needWarSupport() && !gemManager.isGemInstalled("warbler")) {
            return false;
        }
        if (!RailsServerUiUtils.isValidServer(this.component.getServer())) {
            return false;
        }
        return RailsInstallationValidator.getRailsInstallation(platform).isValid();
    }

    public void validate() throws WizardValidationException {
        this.getComponent();
        this.component.validate(this.wizardDescriptor);
    }
}

