/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.sql.PHPSQLCompletion;
import org.netbeans.modules.php.editor.sql.ui.SelectConnectionPanel;
import org.openide.filesystems.FileObject;

public class DatabaseConnectionSupport {
    private static final String PROP_DBCONN = "dbconn";

    public static DatabaseConnection selectDatabaseConnection(Document doc, boolean mySQLOnly, boolean passwordRequired) {
        DatabaseConnection dbconn = DatabaseConnectionSupport.getDatabaseConnection(doc, false);
        dbconn = SelectConnectionPanel.selectConnection(dbconn, mySQLOnly, passwordRequired);
        DatabaseConnectionSupport.setDatabaseConnection(doc, dbconn, true);
        return dbconn;
    }

    public static DatabaseConnection selectDatabaseConnection() {
        return DatabaseConnectionSupport.selectDatabaseConnection(null, false, false);
    }

    public static DatabaseConnection selectDatabaseConnection(boolean mySQLOnly, boolean passwordRequired) {
        return DatabaseConnectionSupport.selectDatabaseConnection(null, mySQLOnly, passwordRequired);
    }

    public static DatabaseConnection selectDatabaseConnection(Document doc) {
        return DatabaseConnectionSupport.selectDatabaseConnection(doc, false, false);
    }

    private static DatabaseConnection getDatabaseConnection(String connectionName, boolean reconnect) {
        DatabaseConnection dbconn = null;
        if (connectionName != null) {
            dbconn = ConnectionManager.getDefault().getConnection(connectionName);
        }
        if (dbconn != null && dbconn.getJDBCConnection() == null && reconnect) {
            ConnectionManager.getDefault().showConnectionDialog(dbconn);
        }
        return dbconn;
    }

    public static DatabaseConnection getDatabaseConnection(Document doc, boolean reconnect) {
        if (doc == null) {
            return null;
        }
        Project project = DatabaseConnectionSupport.getProject(doc);
        String name = project != null ? DatabaseConnectionSupport.getProjectPreferences(project).get(PROP_DBCONN, null) : null;
        return DatabaseConnectionSupport.getDatabaseConnection(name, reconnect);
    }

    private static Preferences getProjectPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, PHPSQLCompletion.class, (boolean)false);
    }

    private static Project getProject(Document doc) {
        if (doc == null) {
            return null;
        }
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (fo != null) {
            return FileOwnerQuery.getOwner((FileObject)fo);
        }
        return null;
    }

    private static void setDatabaseConnection(Project project, DatabaseConnection dbconn) {
        if (project == null) {
            return;
        }
        Preferences prefs = DatabaseConnectionSupport.getProjectPreferences(project);
        if (dbconn != null) {
            prefs.put(PROP_DBCONN, dbconn.getName());
        } else {
            prefs.remove(PROP_DBCONN);
        }
    }

    private static void setDatabaseConnection(Document doc, DatabaseConnection dbconn, boolean forProject) {
        Project project = DatabaseConnectionSupport.getProject(doc);
        if (project != null) {
            DatabaseConnectionSupport.setDatabaseConnection(DatabaseConnectionSupport.getProject(doc), dbconn);
        }
    }
}

