/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.openide.util.ChangeSupport;

public abstract class AbstractProjectWebServiceViewImpl
implements ProjectWebServiceViewImpl {
    private ChangeSupport serviceListeners;
    private ChangeSupport clientListeners;
    private Reference<Project> project;

    protected AbstractProjectWebServiceViewImpl(Project project) {
        this.project = new WeakReference<Project>(project);
        this.serviceListeners = new ChangeSupport((Object)this);
        this.clientListeners = new ChangeSupport((Object)this);
    }

    @Override
    public void addChangeListener(ChangeListener l, ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                this.serviceListeners.addChangeListener(l);
                break;
            }
            case CLIENT: {
                this.clientListeners.addChangeListener(l);
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l, ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                if (this.serviceListeners == null) break;
                this.serviceListeners.removeChangeListener(l);
                break;
            }
            case CLIENT: {
                if (this.clientListeners == null) break;
                this.clientListeners.removeChangeListener(l);
            }
        }
    }

    protected void fireChange(ProjectWebServiceView.ViewType viewType) {
        switch (viewType) {
            case SERVICE: {
                this.serviceListeners.fireChange();
                return;
            }
            case CLIENT: {
                this.clientListeners.fireChange();
                return;
            }
        }
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            AbstractProjectWebServiceViewImpl other = (AbstractProjectWebServiceViewImpl)object;
            return other.getProject() == this.getProject();
        }
        return false;
    }

    public int hashCode() {
        super.hashCode();
        int hash = 3;
        hash = 23 * hash + (this.getProject() != null ? this.getProject().hashCode() : 0);
        return hash;
    }

    protected Project getProject() {
        return this.project.get();
    }
}

