/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant.registries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.netbeans.installer.infra.build.ant.utils.Utils;
import org.netbeans.installer.infra.lib.registries.ManagerException;
import org.netbeans.installer.infra.lib.registries.impl.RegistriesManagerImpl;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.helper.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBundle
extends Task {
    private List<Component> componentObjects = new LinkedList<Component>();
    private File root;
    private File target;
    private Platform platform;
    private Vector<Property> properties = new Vector();
    private Vector<BundleProperty> bundleProperties = new Vector();
    private boolean keepTempBundles = false;

    public void setRoot(File root) {
        this.root = root;
    }

    public void setPlatform(String platform) {
        try {
            this.platform = StringUtils.parsePlatform((String)platform);
        }
        catch (ParseException e) {
            this.log(e.getMessage());
        }
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public Component createComponent() {
        Component component = new Component();
        this.componentObjects.add(component);
        return component;
    }

    public void addProperty(Property p) {
        this.properties.addElement(p);
    }

    public void addBundleProperty(BundleProperty p) {
        this.bundleProperties.addElement(p);
    }

    public void setKeepTempBundles(boolean keepTempBundles) {
        this.keepTempBundles = keepTempBundles;
    }

    public void execute() throws BuildException {
        try {
            LinkedList<String> components = new LinkedList<String>();
            for (Component component : this.componentObjects) {
                components.add(component.getUid() + "," + component.getVersion());
            }
            System.out.println("Creating bundle: " + this.platform + ": " + components);
            Properties props = this.readProperties(this.properties);
            Properties bundleprops = this.readProperties(this.bundleProperties);
            RegistriesManagerImpl impl = new RegistriesManagerImpl();
            File bundle = impl.createBundle(this.root, this.platform, components.toArray(new String[components.size()]), props, bundleprops);
            Utils.copy(bundle, this.target);
            if (!this.keepTempBundles) {
                impl.deleteBundles(this.root);
            }
        }
        catch (ManagerException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(Vector<? extends Property> antProperties) throws IOException {
        Properties props = new Properties();
        for (Property property : antProperties) {
            if (property.getName() != null) {
                if (property.getValue() != null) {
                    props.setProperty(property.getName(), property.getValue());
                    continue;
                }
                if (property.getLocation() == null) continue;
                props.setProperty(property.getName(), new File(property.getLocation().getFileName()).getAbsolutePath());
                continue;
            }
            if (property.getFile() == null && property.getUrl() == null) continue;
            InputStream is = null;
            try {
                is = property.getFile() != null ? new FileInputStream(property.getFile()) : property.getUrl().openStream();
                Properties loadedProps = new Properties();
                loadedProps.load(is);
                is.close();
                if (property.getPrefix() != null) {
                    for (Object p : loadedProps.keySet()) {
                        props.setProperty(property.getPrefix() + p, loadedProps.getProperty(p.toString()));
                    }
                    continue;
                }
                props.putAll((Map<?, ?>)loadedProps);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return props;
    }

    public static class BundleProperty
    extends Property {
    }

    public static class Component {
        private String uid;
        private String version;

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getUid() {
            return this.uid;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

