/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class DefaultBindingTypeFilter<T extends Element>
extends Filter<T> {
    private WebBeansModelImplementation myImpl;

    DefaultBindingTypeFilter() {
    }

    static <T extends Element> DefaultBindingTypeFilter<T> get(Class<T> clazz) {
        DefaultBindingTypeFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new DefaultBindingTypeFilter<T>();
        }
        if (clazz.equals(TypeElement.class)) {
            return new DefaultBindingTypeFilter<T>();
        }
        return null;
    }

    void init(WebBeansModelImplementation webBeansModelImplementation) {
        this.myImpl = webBeansModelImplementation;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            List<? extends AnnotationMirror> list = this.getImplementation().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
            HashSet<String> hashSet = new HashSet<String>();
            Object object = list.iterator();
            while (object.hasNext()) {
                AnnotationMirror annotationMirror = object.next();
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                String string = typeElement.getQualifiedName().toString();
                if ("javax.enterprise.inject.Any".equals(string) || "javax.inject.Named".equals(string) || !this.isQualifier(typeElement)) continue;
                hashSet.add(string);
            }
            if (hashSet.contains("javax.enterprise.inject.Default") || element instanceof TypeElement && AnnotationObjectProvider.checkSuper((TypeElement)element, "javax.enterprise.inject.Default", this.getImplementation().getHelper()) != null || element instanceof ExecutableElement && (object = MemberCheckerFilter.getSpecialized(element, this.getImplementation(), "javax.enterprise.inject.Default")) != null || hashSet.size() == 0) continue;
            iterator.remove();
        }
    }

    private boolean isQualifier(TypeElement typeElement) {
        return AnnotationObjectProvider.isQualifier(typeElement, this.getImplementation().getHelper());
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }
}

