/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.navigation.JavaElement;
import org.netbeans.modules.web.beans.navigation.WebBeansNavigationOptions;

final class Utils {
    Utils() {
    }

    static void firstRow(JTree jTree) {
        int n = jTree.getRowCount();
        if (n > 0) {
            jTree.setSelectionRow(0);
            Utils.scrollTreeToSelectedRow(jTree);
        }
    }

    static void scrollTreeToSelectedRow(final JTree jTree) {
        final int n = jTree.getLeadSelectionRow();
        if (n >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTree.scrollRectToVisible(jTree.getRowBounds(n));
                }
            });
        }
    }

    static void previousRow(JTree jTree) {
        int n = jTree.getRowCount();
        if (n > 0) {
            int n2 = jTree.getSelectionModel().getMinSelectionRow();
            if (n2 == -1) {
                n2 = n - 1;
            } else if (--n2 < 0) {
                n2 = n - 1;
            }
            jTree.setSelectionRow(n2);
            Utils.scrollTreeToSelectedRow(jTree);
        }
    }

    static void nextRow(JTree jTree) {
        int n = jTree.getRowCount();
        if (n > 0) {
            int n2 = jTree.getSelectionModel().getMinSelectionRow();
            if (n2 == -1) {
                n2 = 0;
                jTree.setSelectionRow(n2);
            } else {
                ++n2;
            }
            jTree.setSelectionRow(n2 % n);
            Utils.scrollTreeToSelectedRow(jTree);
        }
    }

    static void lastRow(JTree jTree) {
        int n = jTree.getRowCount();
        if (n > 0) {
            jTree.setSelectionRow(n - 1);
            Utils.scrollTreeToSelectedRow(jTree);
        }
    }

    static boolean patternMatch(JavaElement javaElement, String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = string;
        string3 = string.trim().length() == 0 ? string + ".*" : string.replaceAll(Pattern.quote("*"), Matcher.quoteReplacement(".*")).replaceAll(Pattern.quote("?"), Matcher.quoteReplacement(".")) + (string.endsWith("$") ? "" : ".*");
        String string4 = javaElement.getName();
        try {
            Pattern pattern = Pattern.compile(string3, WebBeansNavigationOptions.isCaseSensitive() ? 0 : 2);
            Matcher matcher = pattern.matcher(string4);
            return matcher.matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            if (WebBeansNavigationOptions.isCaseSensitive()) {
                return string4.startsWith(string);
            }
            return string4.toLowerCase().startsWith(string2);
        }
    }

    static String format(Element element, DeclaredType declaredType, CompilationInfo compilationInfo) {
        return Utils.format(element, declaredType, compilationInfo, false, false);
    }

    static String format(Element element, DeclaredType declaredType, CompilationInfo compilationInfo, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        Utils.format(element, declaredType, compilationInfo, stringBuilder, bl, bl2);
        return stringBuilder.toString();
    }

    static void format(Element element, DeclaredType declaredType, CompilationInfo compilationInfo, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (element == null) {
            return;
        }
        Set<javax.lang.model.element.Modifier> set = element.getModifiers();
        switch (element.getKind()) {
            case PACKAGE: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                if (bl) {
                    stringBuilder.append(Utils.toString(set));
                    if (set.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                if (bl) {
                    switch (element.getKind()) {
                        case CLASS: {
                            stringBuilder.append("class ");
                            break;
                        }
                        case INTERFACE: {
                            stringBuilder.append("interface ");
                            break;
                        }
                        case ENUM: {
                            stringBuilder.append("enum ");
                            break;
                        }
                        case ANNOTATION_TYPE: {
                            stringBuilder.append("@interface ");
                        }
                    }
                }
                TypeElement typeElement = (TypeElement)element;
                stringBuilder.append(bl2 ? typeElement.getQualifiedName().toString() : typeElement.getSimpleName().toString());
                Utils.formatTypeParameters(typeElement.getTypeParameters(), compilationInfo, stringBuilder, bl2);
                break;
            }
            case CONSTRUCTOR: {
                break;
            }
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                ExecutableType executableType = (ExecutableType)compilationInfo.getTypes().asMemberOf(declaredType, executableElement);
                TypeMirror typeMirror = executableType.getReturnType();
                List<? extends TypeVariable> list = executableType.getTypeVariables();
                if (bl) {
                    stringBuilder.append(Utils.toString(set));
                    if (set.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (list != null && list.size() > 0) {
                        Utils.formatTypeMirrors(list, stringBuilder, bl2);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                    }
                    Utils.formatTypeMirror(typeMirror, stringBuilder, bl2);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(executableElement.getSimpleName().toString());
                stringBuilder.append("(");
                List<? extends TypeMirror> list2 = executableType.getParameterTypes();
                Utils.formatTypeMirrors(list2, stringBuilder, bl2);
                if (executableElement.isVarArgs()) {
                    stringBuilder.append("...");
                }
                stringBuilder.append(")");
                List<? extends TypeMirror> list3 = executableElement.getThrownTypes();
                if (!list3.isEmpty()) {
                    stringBuilder.append(" throws ");
                    Utils.formatTypeMirrors(list3, stringBuilder, bl2);
                }
                if (bl) {
                    Object object;
                    AnnotationValue annotationValue = executableElement.getDefaultValue();
                    if (annotationValue == null || (object = annotationValue.getValue()) == null) break;
                    stringBuilder.append(" default ");
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                    } else if (object instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(object));
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(object instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(typeMirror, stringBuilder, bl2);
                if (list == null || list.size() <= 0) break;
                stringBuilder.append(":");
                Utils.formatTypeMirrors(list, stringBuilder, bl2);
                break;
            }
            case TYPE_PARAMETER: {
                break;
            }
            case FIELD: {
                VariableElement variableElement = (VariableElement)element;
                TypeMirror typeMirror = compilationInfo.getTypes().asMemberOf(declaredType, variableElement);
                if (bl) {
                    stringBuilder.append(Utils.toString(set));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    Utils.formatTypeMirror(typeMirror, stringBuilder, bl2);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(variableElement.getSimpleName().toString());
                if (bl) {
                    Object object = variableElement.getConstantValue();
                    if (object == null) break;
                    stringBuilder.append(" = ");
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                    } else if (object instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(object));
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(object instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(typeMirror, stringBuilder, bl2);
                break;
            }
            case ENUM_CONSTANT: {
                break;
            }
        }
    }

    static String toString(Set<javax.lang.model.element.Modifier> set) {
        return Modifier.toString(Utils.getIntModifiers(set));
    }

    static int getIntModifiers(Set<javax.lang.model.element.Modifier> set) {
        int n = 0;
        if (set.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            n |= 0x400;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            n |= 0x10;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.NATIVE)) {
            n |= 0x100;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.PRIVATE)) {
            n |= 2;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            n |= 4;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            n |= 1;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            n |= 8;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.STRICTFP)) {
            n |= 0x800;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.SYNCHRONIZED)) {
            n |= 0x20;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.TRANSIENT)) {
            n |= 0x80;
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.VOLATILE)) {
            n |= 0x40;
        }
        return n;
    }

    static void formatTypeParameters(List<? extends TypeParameterElement> list, CompilationInfo compilationInfo, StringBuilder stringBuilder, boolean bl) {
        if (list == null || list.size() == 0) {
            return;
        }
        boolean bl2 = true;
        if (list.size() > 0) {
            stringBuilder.append("<");
            bl2 = true;
            for (TypeParameterElement typeParameterElement : list) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                Utils.format(typeParameterElement, null, compilationInfo, stringBuilder, false, bl);
            }
            stringBuilder.append(">");
        }
    }

    static void formatTypeMirrors(List<? extends TypeMirror> list, StringBuilder stringBuilder, boolean bl) {
        if (list == null || list.size() == 0) {
            return;
        }
        boolean bl2 = true;
        for (TypeMirror typeMirror : list) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            Utils.formatTypeMirror(typeMirror, stringBuilder, bl);
        }
    }

    static void formatTypeMirror(TypeMirror typeMirror, StringBuilder stringBuilder, boolean bl) {
        if (typeMirror == null) {
            return;
        }
        switch (typeMirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                stringBuilder.append(typeMirror);
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                stringBuilder.append(typeVariable.asElement().getSimpleName().toString());
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                stringBuilder.append("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    Utils.formatTypeMirror(wildcardType.getExtendsBound(), stringBuilder, bl);
                }
                if (wildcardType.getSuperBound() == null) break;
                stringBuilder.append(" super ");
                Utils.formatTypeMirror(wildcardType.getSuperBound(), stringBuilder, bl);
                break;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                Element element = declaredType.asElement();
                if (element instanceof TypeElement) {
                    stringBuilder.append(bl ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
                } else {
                    stringBuilder.append(element.getSimpleName().toString());
                }
                List<? extends TypeMirror> list = declaredType.getTypeArguments();
                if (list.isEmpty()) break;
                stringBuilder.append("<");
                Utils.formatTypeMirrors(list, stringBuilder, bl);
                stringBuilder.append(">");
                break;
            }
            case ARRAY: {
                int n = 0;
                while (typeMirror.getKind() == TypeKind.ARRAY) {
                    ++n;
                    typeMirror = ((ArrayType)typeMirror).getComponentType();
                }
                Utils.formatTypeMirror(typeMirror, stringBuilder, bl);
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("[]");
                }
                break;
            }
        }
    }
}

