/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.RegistryType;
import org.netbeans.installer.product.components.Group;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.components.ProductConfigurationLogic;
import org.netbeans.installer.product.dependencies.Conflict;
import org.netbeans.installer.product.dependencies.InstallAfter;
import org.netbeans.installer.product.dependencies.Requirement;
import org.netbeans.installer.product.filters.GroupFilter;
import org.netbeans.installer.product.filters.OrFilter;
import org.netbeans.installer.product.filters.ProductFilter;
import org.netbeans.installer.product.filters.RegistryFilter;
import org.netbeans.installer.product.filters.TrueFilter;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.ExecutionMode;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.Feature;
import org.netbeans.installer.utils.helper.FinishHandler;
import org.netbeans.installer.utils.helper.NbiProperties;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.PropertyContainer;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry
implements PropertyContainer {
    private static Registry instance;
    private File localDirectory;
    private File localRegistryFile;
    private File localProductCache;
    private String localRegistryStubUri = "resource:org/netbeans/installer/product/default-registry.xml";
    private String bundledRegistryUri = "resource:data/registry.xml";
    private List<String> remoteRegistryUris = new ArrayList<String>();
    private String registrySchemaUri = "resource:org/netbeans/installer/product/registry.xsd";
    private String stateFileSchemaUri = "resource:org/netbeans/installer/product/state-file.xsd";
    private String stateFileStubUri = "resource:org/netbeans/installer/product/default-state-file.xml";
    private List<Feature> features = new LinkedList<Feature>();
    private List<ExtendedUri> includes = new LinkedList<ExtendedUri>();
    private RegistryNode registryRoot = new Group();
    private NbiProperties properties;
    private Platform targetPlatform;
    private FinishHandler finishHandler;
    public static final String DEFAULT_LOCAL_PRODUCT_CACHE_DIRECTORY_NAME = "product-cache";
    public static final String LOCAL_PRODUCT_CACHE_DIRECTORY_PROPERTY = "nbi.product.local.cache.directory.name";
    public static final String DEFAULT_LOCAL_REGISTRY_FILE_NAME = "registry.xml";
    public static final String DEFAULT_BUNDLED_REGISTRY_FILE_NAME = "registry.xml";
    public static final String LOCAL_PRODUCT_REGISTRY_PROPERTY = "nbi.product.local.registry.file.name";
    public static final String DEFAULT_LOCAL_PRODUCT_REGISTRY_STUB_URI = "resource:org/netbeans/installer/product/default-registry.xml";
    public static final String LOCAL_PRODUCT_REGISTRY_STUB_PROPERTY = "nbi.product.local.registry.stub";
    public static final String DEFAULT_BUNDLED_PRODUCT_REGISTRY_URI = "resource:data/registry.xml";
    public static final String BUNDLED_PRODUCT_REGISTRY_URI_PROPERTY = "nbi.product.bundled.registry.uri";
    public static final String DEFAULT_PRODUCT_REGISTRY_SCHEMA_URI = "resource:org/netbeans/installer/product/registry.xsd";
    public static final String PRODUCT_REGISTRY_SCHEMA_URI_PROPERTY = "nbi.product.registry.schema.uri";
    public static final String REMOTE_PRODUCT_REGISTRIES_PROPERTY = "nbi.product.remote.registries";
    public static final String TARGET_COMPONENT_UID_PROPERTY = "nbi.product.target.component.uid";
    public static final String TARGET_COMPONENT_VERSION_PROPERTY = "nbi.product.target.component.version";
    public static final String SOURCE_STATE_FILE_PATH_PROPERTY = "nbi.product.source.state.file.path";
    public static final String TARGET_STATE_FILE_PATH_PROPERTY = "nbi.product.target.state.file.path";
    public static final String STATE_FILE_SCHEMA_URI_PROPERTY = "nbi.state.file.schema.uri";
    public static final String DEFAULT_STATE_FILE_SCHEMA_URI = "resource:org/netbeans/installer/product/state-file.xsd";
    public static final String DEFAULT_STATE_FILE_STUB_URI = "resource:org/netbeans/installer/product/default-state-file.xml";
    public static final String STATE_FILE_STUB_PROPERTY = "nbi.state.file.stub";
    public static final String TARGET_PLATFORM_PROPERTY = "nbi.target.platform";
    public static final String SUGGEST_INSTALL_PROPERTY = "nbi.product.suggest.install";
    public static final String SUGGEST_UNINSTALL_PROPERTY = "nbi.product.suggest.uninstall";
    public static final String FORCE_INSTALL_PROPERTY = "nbi.product.force.install";
    public static final String FORCE_UNINSTALL_PROPERTY = "nbi.product.force.uninstall";
    public static final String CREATE_BUNDLE_PATH_PROPERTY = "nbi.create.bundle.path";
    public static final String CREATE_BUNDLE_SKIP_NATIVE_LAUNCHER_PROPERTY = "nbi.create.bundle.skip.native.launcher";
    public static final String LAZY_LOAD_ICONS_PROPERTY = "nbi.product.lazy.load.icons";
    public static final String REMOVE_CORRUPTED_PRODUCTS_SILENTLY_PROPERTY = "nbi.product.remove.corrupted.products.silently";
    private static final String LOADING_LOCAL_REGISTRY_KEY = "R.loading.local.registry";
    private static final String ERROR_LOADING_LOCAL_REGISTRY_TITLE_KEY = "R.error.loading.local.registry.failed.title";
    private static final String ERROR_LOADING_LOCAL_REGISTRY_MESSAGE_KEY = "R.error.loading.local.registry.failed.msg";
    private static final String LOADING_BUNDLED_REGISTRY_KEY = "R.loading.bundled.registry";
    private static final String ERROR_LOADING_BUNDLED_REGISTRY_TITLE_KEY = "R.error.loading.bundled.registry.failed.title";
    private static final String ERROR_LOADING_BUNDLED_REGISTRY_MESSAGE_KEY = "R.error.loading.bundled.registry.failed.msg";
    private static final String LOADING_REMOTE_REGISTRY_KEY = "R.loading.remote.registry";
    private static final String ERROR_LOADING_REMOTE_REGISTRY_TITLE_KEY = "R.error.loading.remote.registry.failed.title";
    private static final String ERROR_LOADING_REMOTE_REGISTRY_MESSAGE_KEY = "R.error.loading.remote.registry.failed.msg";
    private static final String ERROR_CANNOT_DELETE_DATA_KEY = "R.error.cannot.delete.data";
    private static final String SAVE_LOCAL_REGISTRY_TITLE_KEY = "R.save.local.registry.title";
    private static final String SAVE_LOCAL_REGISTRY_DETAIL_KEY = "R.save.local.registry.detail";
    private static final String ERROR_MISSING_TARGET_COMPONENT_TITLE_KEY = "R.error.missing.target.component.title";
    private static final String ERROR_MISSING_TARGET_COMPONENT_MSG_KEY = "R.error.missing.target.component.msg";
    private static final String ERROR_VALIDATION_TITLE_KEY = "R.error.validation.title";
    private static final String ERROR_VALIDATION_MSG_KEY = "R.error.validation.msg";
    private static final String ERROR_REQUIREMENT_KEY = "R.error.matching.requirement";
    private static final String ERROR_CYCLIC_DEPENDENCY_KEY = "R.error.cyclic.dependency";
    private static final String LOADING_REGISTRY_PROPERTIES_KEY = "R.loading.registry.properties";
    private static final String LOADING_COMPONENT_KEY = "R.loading.component";
    private static final String ERROR_LOADING_COMPONENTS = "R.error.loading.components";
    private static final String ERROR_REGISTRY_FINALIZATION = "R.error.registry.finalization";
    private static final String ERROR_REGISTRY_DOCUMENT_LOADING = "R.error.registry.document.loading";
    private static final String ERROR_CANNOT_CREATE_CACHE_DIR_KEY = "R.error.cannot.create.cache.directory";
    private static final String ERROR_CACHE_IS_FILE_KEY = "R.error.cache.is.file";
    private static final String ERROR_CANNOT_READ_CACHE_KEY = "R.error.cannot.read.cache";
    private static final String ERROR_CANNOT_WRITE_CACHE_KEY = "R.error.cannot.write.cache";
    private static final String ERROR_CANNOT_CREATE_REGISTRY_KEY = "R.error.cannot.create.registry";
    private static final String ERROR_REGISTRY_IS_DIRECTORY_KEY = "R.error.registry.is.dir";
    private static final String ERROR_CANNOT_WRITE_REGISTRY_KEY = "R.error.cannot.write.registry";
    private static final String ERROR_CANNOT_PARSE_PLATFORM_KEY = "R.error.cannot.parse.platform";
    private static final String ERROR_CANNOT_LOAD_REGISTRY_KEY = "R.error.cannot.load.registry";
    private static final String ERROR_PARSER_DO_NOT_CUPPORT_SCHEMAS_KEY = "R.error.parser.not.support.schemas";
    private static final String ERROR_UNKNOWN_DEPENDENCY_KEY = "R.error.unknown.dependency";

    public static synchronized Registry getInstance() {
        if (instance == null) {
            instance = new Registry();
        }
        return instance;
    }

    public Registry() {
        this.registryRoot.setRegistryType(RegistryType.LOCAL);
        this.properties = new NbiProperties();
        this.targetPlatform = SystemUtils.getCurrentPlatform();
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
        this.localProductCache = new File(localDirectory, DEFAULT_LOCAL_PRODUCT_CACHE_DIRECTORY_NAME);
        this.localRegistryFile = new File(localDirectory, "registry.xml");
    }

    public void setFinishHandler(FinishHandler finishHandler) {
        this.finishHandler = finishHandler;
    }

    public void setTargetPlatform(Platform targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public void initializeRegistry(Progress progress) throws InitializationException {
        LogManager.logEntry("initializing product registry");
        this.setRegistryProperties();
        this.loadAllRegistries(progress);
        this.validateDependencies();
        if (System.getProperty(SOURCE_STATE_FILE_PATH_PROPERTY) != null) {
            this.loadStateFile(new File(System.getProperty(SOURCE_STATE_FILE_PATH_PROPERTY)), new Progress());
        }
        this.applyRegistryFilters();
        if (System.getProperty(SOURCE_STATE_FILE_PATH_PROPERTY) == null) {
            this.changeStatuses();
        }
        LogManager.logExit("... product registry initialization complete");
    }

    private void loadAllRegistries(Progress progress) {
        CompositeProgress compositeProgress = new CompositeProgress();
        int percentageChunk = 100 / (this.remoteRegistryUris.size() + 2);
        int percentageLeak = 100 % (this.remoteRegistryUris.size() + 2);
        compositeProgress.synchronizeTo(progress);
        compositeProgress.synchronizeDetails(true);
        compositeProgress.setPercentage(percentageLeak);
        this.loadProductRegistry(compositeProgress, this.localRegistryFile, RegistryType.LOCAL, percentageChunk, false);
        this.loadProductRegistry(compositeProgress, this.bundledRegistryUri, RegistryType.BUNDLED, percentageChunk, true);
        for (String remoteRegistryURI : this.remoteRegistryUris) {
            this.loadProductRegistry(compositeProgress, remoteRegistryURI, RegistryType.REMOTE, percentageChunk, true);
        }
    }

    private String getLoadingRegistryMessageKey(RegistryType type) {
        switch (type) {
            case BUNDLED: {
                return LOADING_BUNDLED_REGISTRY_KEY;
            }
            case LOCAL: {
                return LOADING_LOCAL_REGISTRY_KEY;
            }
            case REMOTE: {
                return LOADING_REMOTE_REGISTRY_KEY;
            }
        }
        return null;
    }

    private String getErrorLoadingRegistryTitleKey(RegistryType type) {
        switch (type) {
            case BUNDLED: {
                return ERROR_LOADING_BUNDLED_REGISTRY_TITLE_KEY;
            }
            case LOCAL: {
                return ERROR_LOADING_LOCAL_REGISTRY_TITLE_KEY;
            }
            case REMOTE: {
                return ERROR_LOADING_REMOTE_REGISTRY_TITLE_KEY;
            }
        }
        return null;
    }

    private String getErrorLoadingRegistryMessageKey(RegistryType type) {
        switch (type) {
            case BUNDLED: {
                return ERROR_LOADING_BUNDLED_REGISTRY_MESSAGE_KEY;
            }
            case LOCAL: {
                return ERROR_LOADING_LOCAL_REGISTRY_MESSAGE_KEY;
            }
            case REMOTE: {
                return ERROR_LOADING_REMOTE_REGISTRY_MESSAGE_KEY;
            }
        }
        return null;
    }

    private void loadProductRegistry(CompositeProgress compositeProgress, File registryFile, RegistryType type, int percentageChunk, boolean includes) {
        this.loadProductRegistry(compositeProgress, registryFile.toURI().toString(), registryFile, type, percentageChunk, includes);
    }

    private void loadProductRegistry(CompositeProgress compositeProgress, String registryUri, RegistryType type, int percentageChunk, boolean includes) {
        this.loadProductRegistry(compositeProgress, registryUri, registryUri, type, percentageChunk, includes);
    }

    private void loadProductRegistry(CompositeProgress compositeProgress, String registryUri, Object registryDisplayName, RegistryType type, int percentageChunk, boolean includes) {
        Progress childProgress = new Progress();
        compositeProgress.addChild(childProgress, percentageChunk);
        compositeProgress.setTitle(ResourceUtils.getString(Registry.class, this.getLoadingRegistryMessageKey(type), registryDisplayName));
        try {
            this.loadProductRegistry(registryUri, childProgress, type, includes);
        }
        catch (InitializationException e) {
            if (!UiUtils.showYesNoDialog(ResourceUtils.getString(Registry.class, this.getErrorLoadingRegistryTitleKey(type)), ResourceUtils.getString(Registry.class, this.getErrorLoadingRegistryMessageKey(type), registryDisplayName))) {
                this.finishHandler.criticalExit();
            }
            LogManager.log(1, (Throwable)e);
        }
    }

    public void finalizeRegistry(Progress progress) throws FinalizationException {
        LogManager.logEntry("finalizing product registry");
        progress.setPercentage(0);
        LogManager.log("... removing remaining installation data for all the products");
        for (Product product : this.getProducts()) {
            for (ExtendedUri uri : product.getDataUris()) {
                try {
                    FileProxy.getInstance().deleteFile(uri);
                }
                catch (IOException e) {
                    ErrorManager.notifyWarning(ResourceUtils.getString(Registry.class, ERROR_CANNOT_DELETE_DATA_KEY), e);
                }
            }
        }
        LogManager.log("... save local registry if necessary");
        if (ExecutionMode.getCurrentExecutionMode() == ExecutionMode.NORMAL) {
            progress.setTitle(ResourceUtils.getString(Registry.class, SAVE_LOCAL_REGISTRY_TITLE_KEY));
            progress.setDetail(ResourceUtils.getString(Registry.class, SAVE_LOCAL_REGISTRY_DETAIL_KEY, this.localRegistryFile));
            LogManager.log("... save registry to file " + this.localRegistryFile);
            this.saveProductRegistry(this.localRegistryFile, new ProductFilter(Status.INSTALLED), false, true, false);
        }
        LogManager.log("... save state file if necessary");
        if (System.getProperty(TARGET_STATE_FILE_PATH_PROPERTY) != null) {
            File stateFile = new File(System.getProperty(TARGET_STATE_FILE_PATH_PROPERTY));
            LogManager.log("... save state file to " + stateFile);
            this.saveStateFile(stateFile, new Progress());
        }
        progress.setPercentage(100);
        LogManager.logExit("finalizing product registry");
    }

    private void setRegistryProperties() throws InitializationException {
        LogManager.logEntry("initializing product registry properties");
        LogManager.logIndent("initializing local product cache directory");
        if (System.getProperty(LOCAL_PRODUCT_CACHE_DIRECTORY_PROPERTY) != null) {
            this.localProductCache = new File(this.localDirectory, System.getProperty(LOCAL_PRODUCT_CACHE_DIRECTORY_PROPERTY));
        }
        if (!this.localProductCache.exists()) {
            if (!this.localProductCache.mkdirs()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_CREATE_CACHE_DIR_KEY, this.localProductCache));
            }
        } else {
            if (this.localProductCache.isFile()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CACHE_IS_FILE_KEY, this.localProductCache));
            }
            if (!this.localProductCache.canRead()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_READ_CACHE_KEY, this.localProductCache));
            }
            if (!this.localProductCache.canWrite()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_WRITE_CACHE_KEY, this.localProductCache));
            }
        }
        LogManager.logUnindent("... " + this.localProductCache);
        LogManager.log("initializing local product registry file");
        if (System.getProperty(LOCAL_PRODUCT_REGISTRY_PROPERTY) != null) {
            this.localRegistryFile = new File(this.localDirectory, System.getProperty(LOCAL_PRODUCT_REGISTRY_PROPERTY));
        }
        if (!this.localRegistryFile.exists()) {
            try {
                FileUtils.copyFile(FileProxy.getInstance().getFile(this.localRegistryStubUri, true), this.localRegistryFile);
            }
            catch (DownloadException e) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_CREATE_REGISTRY_KEY), e);
            }
            catch (IOException e) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_CREATE_REGISTRY_KEY), e);
            }
        } else {
            if (this.localRegistryFile.isDirectory()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_IS_DIRECTORY_KEY, this.localRegistryFile));
            }
            if (!this.localRegistryFile.canRead()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_READ_CACHE_KEY, this.localRegistryFile));
            }
            if (!this.localRegistryFile.canWrite()) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_WRITE_REGISTRY_KEY, this.localRegistryFile));
            }
        }
        LogManager.log("    ... " + this.localRegistryFile);
        LogManager.log("    initializing local product registry stub uri");
        if (System.getProperty(LOCAL_PRODUCT_REGISTRY_STUB_PROPERTY) != null) {
            this.localRegistryStubUri = System.getProperty(LOCAL_PRODUCT_REGISTRY_STUB_PROPERTY);
        }
        LogManager.log("    ... " + this.localRegistryStubUri);
        LogManager.log("    initializing bundled product registry uri");
        if (System.getProperty(BUNDLED_PRODUCT_REGISTRY_URI_PROPERTY) != null) {
            this.bundledRegistryUri = System.getProperty(BUNDLED_PRODUCT_REGISTRY_URI_PROPERTY);
        }
        LogManager.log("    ... " + this.bundledRegistryUri);
        LogManager.log("    initializing product registry schema uri");
        if (System.getProperty(PRODUCT_REGISTRY_SCHEMA_URI_PROPERTY) != null) {
            this.registrySchemaUri = System.getProperty(PRODUCT_REGISTRY_SCHEMA_URI_PROPERTY);
        }
        LogManager.log("    ... " + this.registrySchemaUri);
        LogManager.log("    initializing remote product registries uris");
        if (System.getProperty(REMOTE_PRODUCT_REGISTRIES_PROPERTY) != null) {
            for (String remoteRegistryURI : System.getProperty(REMOTE_PRODUCT_REGISTRIES_PROPERTY).split("\n")) {
                this.remoteRegistryUris.add(remoteRegistryURI);
            }
        }
        for (String string : this.remoteRegistryUris) {
            LogManager.log("    ... " + string);
        }
        LogManager.log("    initializing state file schema uri");
        if (System.getProperty(STATE_FILE_SCHEMA_URI_PROPERTY) != null) {
            this.stateFileSchemaUri = System.getProperty(STATE_FILE_SCHEMA_URI_PROPERTY);
        }
        LogManager.log("    ... " + this.stateFileSchemaUri);
        LogManager.log("    initializing default state file uri");
        if (System.getProperty(STATE_FILE_STUB_PROPERTY) != null) {
            this.stateFileStubUri = System.getProperty(STATE_FILE_STUB_PROPERTY);
        }
        LogManager.log("    ... " + this.stateFileStubUri);
        LogManager.log("    initializing target platform");
        if (System.getProperty(TARGET_PLATFORM_PROPERTY) != null) {
            String platformString = System.getProperty(TARGET_PLATFORM_PROPERTY);
            try {
                this.targetPlatform = StringUtils.parsePlatform(platformString);
            }
            catch (ParseException e) {
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_PARSE_PLATFORM_KEY, platformString), e);
            }
        }
        LogManager.log("    ... " + (Object)((Object)this.targetPlatform));
        LogManager.logExit("initializing product registry properties");
    }

    private void validateDependencies() throws InitializationException {
        for (Product product : this.getProducts()) {
            this.validateDependencies(product);
        }
    }

    private void validateDependencies(Product product) throws InitializationException {
        this.validateRequirements(product);
        this.validateConflicts(product);
        this.validateInstallAfters(product);
    }

    private void applyRegistryFilters() {
        if (System.getProperty(TARGET_COMPONENT_UID_PROPERTY) != null && System.getProperty(TARGET_COMPONENT_VERSION_PROPERTY) != null) {
            Version version;
            String uid = System.getProperty(TARGET_COMPONENT_UID_PROPERTY);
            Product target = this.getProduct(uid, version = Version.getVersion(System.getProperty(TARGET_COMPONENT_VERSION_PROPERTY)));
            if (target != null) {
                List<Product> dependents = this.getInavoidableDependents(target);
                for (Product product : this.getProducts()) {
                    if (target.equals(product) || dependents.contains(product) || product.isAncestor(target) || product.isAncestor(dependents)) continue;
                    product.setVisible(false);
                }
            } else if (!UiUtils.showYesNoDialog(ResourceUtils.getString(Registry.class, ERROR_MISSING_TARGET_COMPONENT_TITLE_KEY), ResourceUtils.getString(Registry.class, ERROR_MISSING_TARGET_COMPONENT_MSG_KEY, uid, version))) {
                this.finishHandler.cancel();
            } else {
                for (Product product : this.getProducts()) {
                    product.setVisible(false);
                }
            }
        }
        for (Product product : this.getProducts()) {
            boolean compatible = false;
            for (Platform productPlatform : product.getPlatforms()) {
                if (!this.targetPlatform.isCompatibleWith(productPlatform)) continue;
                compatible = true;
                break;
            }
            if (compatible) continue;
            product.setVisible(false);
        }
        for (Group group : this.getGroups()) {
            if (!group.isEmpty()) continue;
            group.setVisible(false);
        }
    }

    private void changeStatuses() {
        if (Boolean.getBoolean(SUGGEST_INSTALL_PROPERTY) || Boolean.getBoolean(FORCE_INSTALL_PROPERTY)) {
            for (Product product : this.getProducts(Status.NOT_INSTALLED)) {
                if (!product.isVisible()) continue;
                product.setStatus(Status.TO_BE_INSTALLED);
            }
        }
        if (Boolean.getBoolean(SUGGEST_UNINSTALL_PROPERTY) || Boolean.getBoolean(FORCE_UNINSTALL_PROPERTY)) {
            for (Product product : this.getProducts(Status.INSTALLED)) {
                if (!product.isVisible()) continue;
                product.setStatus(Status.TO_BE_UNINSTALLED);
            }
        }
    }

    private void validateRequirements(Product product) throws InitializationException {
        this.validateRequirements(product, new LinkedList<Product>());
    }

    private void validateRequirements(Product product, List<Product> prohibitedList) throws InitializationException {
        for (Dependency requirement : product.getDependencies(Requirement.class)) {
            List<Product> requirees = this.queryProducts(new ProductFilter(requirement.getUid(), requirement.getVersionLower(), requirement.getVersionUpper(), this.targetPlatform));
            if (requirees.size() == 0) {
                String sourceId = product.getUid() + "/" + product.getVersion();
                String requirementId = requirement.getUid() + "/" + requirement.getVersionLower() + " - " + requirement.getVersionUpper() + (requirement.getVersionResolved() != null ? " [" + requirement.getVersionResolved() + "]" : "");
                throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_REQUIREMENT_KEY, sourceId, requirementId));
            }
            for (Product requiree : requirees) {
                for (Dependency dependency : requiree.getDependencies()) {
                    if (product.satisfies(dependency)) {
                        throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CYCLIC_DEPENDENCY_KEY, product.getUid(), dependency.getUid()));
                    }
                    for (Product prohibited : prohibitedList) {
                        if (!prohibited.satisfies(dependency)) continue;
                        throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CYCLIC_DEPENDENCY_KEY, prohibited.getUid(), dependency.getUid()));
                    }
                }
                LinkedList<Product> newProhibitedList = new LinkedList<Product>();
                newProhibitedList.addAll(prohibitedList);
                newProhibitedList.add(product);
                this.validateRequirements(requiree, newProhibitedList);
            }
        }
    }

    private void validateConflicts(Product product) throws InitializationException {
        for (Dependency requirement : product.getDependencies(Requirement.class)) {
            List<Product> requirees = this.queryProducts(new ProductFilter(requirement.getUid(), requirement.getVersionLower(), requirement.getVersionUpper(), this.targetPlatform));
            for (Dependency conflict : product.getDependencies(Conflict.class)) {
                List<Product> conflictees = this.queryProducts(new ProductFilter(conflict.getUid(), conflict.getVersionLower(), conflict.getVersionUpper(), this.targetPlatform));
                if (!SystemUtils.intersects(requirees, conflictees)) continue;
                throw new InitializationException("A requiree is also a conflictee.");
            }
        }
    }

    private void validateInstallAfters(Product product) throws InitializationException {
        this.validateInstallAfters(product, new LinkedList<Product>());
    }

    private void validateInstallAfters(Product product, List<Product> prohibitedList) throws InitializationException {
        for (Dependency installafter : product.getDependencies(InstallAfter.class)) {
            List<Product> dependees = this.queryProducts(new ProductFilter(installafter.getUid(), this.targetPlatform));
            for (Product requiree : dependees) {
                for (Dependency dependency : requiree.getDependencies(Requirement.class, InstallAfter.class)) {
                    if (product.satisfies(dependency)) {
                        throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CYCLIC_DEPENDENCY_KEY, product.getUid(), dependency.getUid()));
                    }
                    for (Product prohibited : prohibitedList) {
                        if (!prohibited.satisfies(dependency)) continue;
                        throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CYCLIC_DEPENDENCY_KEY, prohibited.getUid(), dependency.getUid()));
                    }
                }
                LinkedList<Product> newProhibitedList = new LinkedList<Product>();
                newProhibitedList.addAll(prohibitedList);
                newProhibitedList.add(product);
                this.validateRequirements(requiree, newProhibitedList);
            }
        }
    }

    public List<Product> getInavoidableDependents(Product product) {
        HashSet<Product> dependents = new HashSet<Product>();
        for (Product candidate : this.getProducts()) {
            for (Dependency requirement : candidate.getDependencies(Requirement.class)) {
                List<Product> requirees = this.getProducts(requirement);
                if (candidate.getStatus() == Status.INSTALLED) {
                    for (int i = 0; i < requirees.size(); ++i) {
                        if (requirees.get(i).getStatus() == Status.INSTALLED) continue;
                        requirees.remove(i);
                    }
                }
                if (requirees.size() != 1 || !requirees.get(0).equals(product)) continue;
                dependents.add(candidate);
                dependents.addAll(this.getInavoidableDependents(candidate));
            }
        }
        return new ArrayList<Product>(dependents);
    }

    private void validateInstallations() throws InitializationException {
        LogManager.logEntry("validating previous installations");
        String LIST_ONE_PRODUCT_MESSAGE = "-> {0} ({1}/{2})";
        String CANNOT_GET_LOGIC_MAKE_INVISIBLE_MESSAGE = "Cannot load configuration logic for {0} ({1}/{2}), marking it as invisible";
        String INSTALLATION_VALIDATION_MESSAGE = "Installation validation of {0} ({1}/{2}):";
        for (Product product : this.getProducts()) {
            boolean result;
            List<Product> inavoidableDependents;
            if (product.getStatus() != Status.INSTALLED || !product.isVisible()) continue;
            ProductConfigurationLogic logic = null;
            try {
                logic = product.getLogic();
            }
            catch (InitializationException e) {
                LogManager.log(2, StringUtils.format("Cannot load configuration logic for {0} ({1}/{2}), marking it as invisible", product.getDisplayName(), product.getUid(), product.getVersion()));
                LogManager.log(2, (Throwable)e);
                product.setVisible(false);
                inavoidableDependents = this.getInavoidableDependents(product);
                if (inavoidableDependents.isEmpty()) continue;
                LogManager.indent();
                LogManager.log(2, "Also make the dependent products invisible: ");
                for (Product p : inavoidableDependents) {
                    LogManager.log(2, StringUtils.format("-> {0} ({1}/{2})", p.getDisplayName(), p.getUid(), p.getVersion()));
                    p.setVisible(false);
                }
                LogManager.unindent();
                continue;
            }
            String message = logic.validateInstallation();
            if (message == null) continue;
            inavoidableDependents = this.getInavoidableDependents(product);
            LogManager.logIndent(StringUtils.format("Installation validation of {0} ({1}/{2}):", product.getDisplayName(), product.getUid(), product.getVersion()));
            LogManager.log(message);
            if (!inavoidableDependents.isEmpty()) {
                LogManager.logIndent("Dependent Products: ");
                for (Product p : inavoidableDependents) {
                    LogManager.log(StringUtils.format("-> {0} ({1}/{2})", p.getDisplayName(), p.getUid(), p.getVersion()));
                }
                LogManager.unindent();
            }
            LogManager.unindent();
            boolean bl = result = Boolean.getBoolean(REMOVE_CORRUPTED_PRODUCTS_SILENTLY_PROPERTY) || UiUtils.showYesNoDialog(ResourceUtils.getString(Registry.class, ERROR_VALIDATION_TITLE_KEY), ResourceUtils.getString(Registry.class, ERROR_VALIDATION_MSG_KEY, product.getDisplayName(), message, product.getDisplayName(), StringUtils.asString(inavoidableDependents)), true);
            if (result) {
                product.setStatus(Status.NOT_INSTALLED);
                product.getParent().removeChild(product);
                for (Product dependent : inavoidableDependents) {
                    dependent.setStatus(Status.NOT_INSTALLED);
                    dependent.getParent().removeChild(dependent);
                }
                continue;
            }
            this.finishHandler.criticalExit();
        }
        LogManager.logExit("... validating installations finished");
    }

    public void loadProductRegistry(File file) throws InitializationException {
        this.loadProductRegistry(file.toURI().toString());
    }

    public void loadProductRegistry(String uri) throws InitializationException {
        this.loadProductRegistry(uri, new Progress(), RegistryType.REMOTE, false);
    }

    public void loadProductRegistry(String uri, Progress progress, RegistryType registryType, boolean loadIncludes) throws InitializationException {
        try {
            Element featuresElement;
            Element propertiesElement;
            LogManager.log("... loading registry from " + uri);
            Element registryElement = this.loadRegistryDocument(uri).getDocumentElement();
            Element includesElement = XMLUtils.getChild(registryElement, "includes");
            if (includesElement != null) {
                this.includes.addAll(XMLUtils.parseExtendedUrisList(includesElement));
                if (loadIncludes) {
                    for (ExtendedUri includeUri : this.includes) {
                        this.loadProductRegistry(includeUri.getRemote().toString(), new Progress(), RegistryType.REMOTE, true);
                    }
                }
            }
            if ((propertiesElement = XMLUtils.getChild(registryElement, "properties")) != null) {
                NbiProperties map = XMLUtils.parseNbiProperties(propertiesElement);
                for (Object name : map.keySet()) {
                    if (this.properties.containsKey(name)) continue;
                    this.properties.put(name, map.get(name));
                }
            }
            if ((featuresElement = XMLUtils.getChild(registryElement, "features")) != null) {
                for (Feature feature : XMLUtils.parseFeaturesList(featuresElement)) {
                    int i;
                    boolean shouldAdd = true;
                    for (i = 0; i < this.features.size(); ++i) {
                        if (this.features.get(i).getId().equals(feature.getId())) {
                            shouldAdd = false;
                            break;
                        }
                        if (this.features.get(i).getOffset() > feature.getOffset()) break;
                    }
                    if (!shouldAdd) continue;
                    this.features.add(i, feature);
                }
            }
            this.loadRegistryComponents(this.registryRoot, registryElement, registryType);
            this.validateInstallations();
            progress.setPercentage(100);
        }
        catch (ParseException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_LOAD_REGISTRY_KEY), e);
        }
        catch (XMLException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_CANNOT_LOAD_REGISTRY_KEY), e);
        }
    }

    public void saveProductRegistry(File file, RegistryFilter filter, boolean saveIncludes, boolean saveProperties, boolean saveFeatures) throws FinalizationException {
        try {
            LogManager.logEntry("saving product registry file");
            LogManager.log("... getting registry document");
            Document document = this.getRegistryDocument(filter, saveIncludes, saveProperties, saveFeatures);
            LogManager.log("... saving registry document to file " + file);
            XMLUtils.saveXMLDocument(document, file);
            LogManager.log("... saving XML file succesfully finished");
        }
        catch (XMLException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
        finally {
            LogManager.logExit("... saving product registry done");
        }
    }

    public Document getEmptyRegistryDocument() throws XMLException {
        return this.loadRegistryDocument(this.localRegistryStubUri);
    }

    public Document getRegistryDocument(RegistryFilter filter, boolean saveIncludes, boolean saveProperties, boolean saveFeatures) throws XMLException, FinalizationException {
        Element componentsElement;
        Document document = this.getEmptyRegistryDocument();
        Element documentElement = document.getDocumentElement();
        if (this.includes.size() > 0 && saveIncludes) {
            documentElement.appendChild(XMLUtils.saveExtendedUrisList(this.includes, document.createElement("includes")));
        }
        if (this.properties.size() > 0 && saveProperties) {
            documentElement.appendChild(XMLUtils.saveNbiProperties(this.properties, document.createElement("properties")));
        }
        if (this.features.size() > 0 && saveFeatures) {
            documentElement.appendChild(XMLUtils.saveFeaturesList(this.features, document.createElement("features")));
        }
        if ((componentsElement = this.registryRoot.saveChildrenToDom(document, filter)) != null) {
            documentElement.appendChild(componentsElement);
        }
        return document;
    }

    public Document loadRegistryDocument(String uri) throws XMLException {
        try {
            File schemaFile = FileProxy.getInstance().getFile(this.registrySchemaUri, true);
            File registryFile = FileProxy.getInstance().getFile(uri, true);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setSchema(schema);
            }
            catch (UnsupportedOperationException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(Registry.class, ERROR_PARSER_DO_NOT_CUPPORT_SCHEMAS_KEY, factory.getClass()), e);
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(registryFile);
        }
        catch (DownloadException e) {
            throw new XMLException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_DOCUMENT_LOADING), e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_DOCUMENT_LOADING), e);
        }
        catch (SAXException e) {
            throw new XMLException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_DOCUMENT_LOADING), e);
        }
        catch (IOException e) {
            throw new XMLException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_DOCUMENT_LOADING), e);
        }
    }

    private void loadRegistryComponents(RegistryNode parentNode, Element parentElement, RegistryType registryType) throws InitializationException {
        Element element = XMLUtils.getChild(parentElement, "components");
        if (element != null) {
            for (Element child : XMLUtils.getChildren(element)) {
                Object existing;
                if (child.getNodeName().equals("product")) {
                    Product product = new Product().loadFromDom(child);
                    existing = this.getProducts(product.getUid(), product.getVersion(), product.getPlatforms());
                    product.setRegistryType(registryType);
                    if (existing.size() == 0) {
                        parentNode.addChild(product);
                        this.loadRegistryComponents(product, child, registryType);
                    } else {
                        RegistryNode existingNode = (RegistryNode)existing.get(0);
                        if (!existingNode.getParent().getUid().equals(parentNode.getUid())) {
                            existingNode.getParent().removeChild(existingNode);
                            parentNode.addChild(existingNode);
                        }
                        this.loadRegistryComponents(existingNode, child, registryType);
                    }
                }
                if (!child.getNodeName().equals("group")) continue;
                Group group = new Group().loadFromDom(child);
                existing = this.getGroup(group.getUid());
                group.setRegistryType(registryType);
                if (existing == null) {
                    parentNode.addChild(group);
                    this.loadRegistryComponents(group, child, registryType);
                    continue;
                }
                this.loadRegistryComponents((RegistryNode)existing, child, registryType);
            }
        }
    }

    public List<RegistryNode> query(RegistryFilter filter) {
        LinkedList<RegistryNode> matches = new LinkedList<RegistryNode>();
        LinkedList<RegistryNode> queue = new LinkedList<RegistryNode>();
        queue.offer(this.registryRoot);
        while (queue.peek() != null) {
            RegistryNode node = (RegistryNode)queue.poll();
            if (filter.accept(node)) {
                matches.add(node);
            }
            for (RegistryNode child : node.getChildren()) {
                queue.offer(child);
            }
        }
        return matches;
    }

    public List<Product> queryProducts(RegistryFilter filter) {
        ArrayList<Product> components = new ArrayList<Product>();
        for (RegistryNode node : this.query(filter)) {
            if (!(node instanceof Product)) continue;
            components.add((Product)node);
        }
        return components;
    }

    public List<Group> queryGroups(RegistryFilter filter) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (RegistryNode node : this.query(filter)) {
            if (!(node instanceof Group)) continue;
            groups.add((Group)node);
        }
        return groups;
    }

    public List<RegistryNode> getNodes() {
        return this.query(TrueFilter.INSTANCE);
    }

    public List<RegistryNode> getNodes(RegistryType registryType) {
        LinkedList<RegistryNode> filtered = new LinkedList<RegistryNode>();
        for (RegistryNode node : this.getNodes()) {
            if (node.getRegistryType() != registryType) continue;
            filtered.add(node);
        }
        return filtered;
    }

    public List<Product> getProducts() {
        return this.queryProducts(TrueFilter.INSTANCE);
    }

    public List<Product> getProducts(Platform platform) {
        return this.queryProducts(new ProductFilter(platform));
    }

    public List<Product> getProducts(String uid) {
        return this.queryProducts(new ProductFilter(uid, this.targetPlatform));
    }

    public List<Product> getProducts(String uid, Version lower, Version upper) {
        return this.queryProducts(new ProductFilter(uid, lower, upper, this.targetPlatform));
    }

    public List<Product> getProducts(String uid, Version version, Platform platform) {
        return this.queryProducts(new ProductFilter(uid, version, platform));
    }

    public List<Product> getProducts(String uid, Version version, List<Platform> platforms) {
        return this.queryProducts(new ProductFilter(uid, version, platforms));
    }

    public List<Product> getProducts(Dependency dependency) {
        if (dependency instanceof Requirement && dependency.getVersionResolved() != null) {
            return this.queryProducts(new ProductFilter(dependency.getUid(), dependency.getVersionResolved(), dependency.getVersionResolved(), this.targetPlatform));
        }
        if (dependency instanceof Requirement || dependency instanceof Conflict) {
            return this.queryProducts(new ProductFilter(dependency.getUid(), dependency.getVersionLower(), dependency.getVersionUpper(), this.targetPlatform));
        }
        if (dependency instanceof InstallAfter) {
            return this.queryProducts(new ProductFilter(dependency.getUid(), this.targetPlatform));
        }
        ErrorManager.notifyCritical(ResourceUtils.getString(Registry.class, ERROR_UNKNOWN_DEPENDENCY_KEY, dependency.getClass().toString()));
        return null;
    }

    public List<Product> getProducts(Status status) {
        return this.queryProducts(new ProductFilter(status, this.targetPlatform));
    }

    public List<Product> getProducts(DetailedStatus detailedStatus) {
        return this.queryProducts(new ProductFilter(detailedStatus, this.targetPlatform));
    }

    public List<Product> getProducts(Feature feature) {
        return this.queryProducts(new ProductFilter(feature, this.targetPlatform));
    }

    public Product getProduct(String uid, Version version) {
        List<Product> candidates = this.getProducts(uid, version, this.targetPlatform);
        return candidates.size() > 0 ? candidates.get(0) : null;
    }

    public List<Group> getGroups() {
        return this.queryGroups(TrueFilter.INSTANCE);
    }

    public Group getGroup(String uid) {
        List<Group> candidates = this.queryGroups(new GroupFilter(uid));
        return candidates.size() > 0 ? candidates.get(0) : null;
    }

    public List<Product> getProductsToInstall() {
        Product product;
        LinkedList<Product> products = new LinkedList<Product>();
        while ((product = this.getNextComponentToInstall(products)) != null) {
            products.add(product);
        }
        return products;
    }

    public List<Product> getProductsToUninstall() {
        Product product;
        ArrayList<Product> products = new ArrayList<Product>();
        while ((product = this.getNextComponentToUninstall(products)) != null) {
            products.add(product);
        }
        return products;
    }

    private Product getNextComponentToInstall(List<Product> currentList) {
        for (Product product : this.getProducts()) {
            if (product.getStatus() != Status.TO_BE_INSTALLED || currentList.contains(product) || !this.checkDependenciesForInstall(product)) continue;
            boolean productIsGood = true;
            for (Dependency dependency : product.getDependencies(Requirement.class, InstallAfter.class)) {
                for (Product dependee : this.getProducts(dependency)) {
                    if (dependee.getStatus() != Status.TO_BE_INSTALLED || currentList.contains(dependee)) continue;
                    productIsGood = false;
                }
            }
            if (!productIsGood) continue;
            return product;
        }
        return null;
    }

    private Product getNextComponentToUninstall(List<Product> currentList) {
        for (Product product : this.getProducts()) {
            if (product.getStatus() != Status.TO_BE_UNINSTALLED || currentList.contains(product) || !this.checkDependenciesForUninstall()) continue;
            boolean productIsGood = true;
            for (Product dependent : this.getProducts()) {
                if (dependent.getStatus() == Status.NOT_INSTALLED || currentList.contains(dependent) || !this.satisfiesRequirement(product, dependent)) continue;
                productIsGood = false;
                break;
            }
            if (!productIsGood) continue;
            return product;
        }
        return null;
    }

    public boolean satisfiesRequirement(Product candidate, Product product) {
        for (Dependency requirement : product.getDependencies(Requirement.class)) {
            List<Product> requirees = this.getProducts(requirement);
            for (Product requiree : requirees) {
                if (!candidate.equals(requiree) && !this.satisfiesRequirement(candidate, requiree)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkDependenciesForInstall(Product product) {
        boolean satisfied;
        for (Dependency requirement : product.getDependencies(Requirement.class)) {
            List<Product> requirees = this.getProducts(requirement);
            satisfied = false;
            for (Product requiree : requirees) {
                if (requiree.getStatus() != Status.INSTALLED && requiree.getStatus() != Status.TO_BE_INSTALLED) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            return false;
        }
        for (Dependency conflict : product.getDependencies(Conflict.class)) {
            List<Product> conflictees = this.getProducts(conflict);
            satisfied = true;
            for (Product conflictee : conflictees) {
                if (conflictee.getStatus() != Status.INSTALLED && conflictee.getStatus() != Status.TO_BE_INSTALLED) continue;
                satisfied = false;
                break;
            }
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    public boolean checkDependenciesForUninstall() {
        for (Product product : this.getProducts()) {
            if (product.getStatus() != Status.INSTALLED && product.getStatus() != Status.TO_BE_INSTALLED) continue;
            for (Dependency requirement : product.getDependencies(Requirement.class)) {
                List<Product> requirees = this.getProducts(requirement);
                for (Product requiree : requirees) {
                    if (requiree.getStatus() != Status.INSTALLED) continue;
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void loadStateFile(File stateFile, Progress progress) throws InitializationException {
        try {
            LogManager.log("loading state file from " + stateFile.getAbsolutePath());
            LogManager.log("parsing xml file...");
            File schemaFile = FileProxy.getInstance().getFile(this.stateFileSchemaUri, true);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setSchema(schema);
            }
            catch (UnsupportedOperationException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(Registry.class, ERROR_PARSER_DO_NOT_CUPPORT_SCHEMAS_KEY, factory.getClass()), e);
            }
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(stateFile);
            LogManager.log("...complete");
            Element element = document.getDocumentElement();
            int productsNumber = XMLUtils.countDescendants(element, "product");
            int percentageChunk = 100 / (productsNumber + 1);
            int percentageLeak = 100 % (productsNumber + 1);
            LogManager.log("    parsing registry properties...");
            Element propertiesElement = XMLUtils.getChild(element, "properties");
            if (propertiesElement != null) {
                progress.setDetail(ResourceUtils.getString(Registry.class, LOADING_REGISTRY_PROPERTIES_KEY));
                this.properties.putAll((Map<?, ?>)XMLUtils.parseNbiProperties(propertiesElement));
            }
            LogManager.log("    ...complete");
            progress.addPercentage(percentageChunk + percentageLeak);
            LogManager.log(4, "    parsing components...");
            Element productsElement = XMLUtils.getChild(element, "components");
            if (productsElement != null) {
                block14: for (Element productElement : XMLUtils.getChildren(productsElement)) {
                    Element productPropertiesElement;
                    Product product;
                    String uid = productElement.getAttribute("uid");
                    Version version = Version.getVersion(productElement.getAttribute("version"));
                    List<Platform> platforms = StringUtils.parsePlatforms(productElement.getAttribute("platform"));
                    LogManager.log("        parsing component uid=" + uid + ", version=" + version);
                    progress.setDetail(ResourceUtils.getString(Registry.class, LOADING_COMPONENT_KEY, uid, version));
                    boolean compatible = false;
                    for (Platform productPlatform : platforms) {
                        if (!this.targetPlatform.isCompatibleWith(productPlatform)) continue;
                        compatible = true;
                        break;
                    }
                    if (!compatible || (product = this.getProduct(uid, version)) == null) continue;
                    Status status = StringUtils.parseStatus(productElement.getAttribute("status"));
                    switch (status) {
                        case NOT_INSTALLED: {
                            continue block14;
                        }
                        case TO_BE_INSTALLED: {
                            if (product.getStatus() == Status.INSTALLED) continue block14;
                            product.setStatus(status);
                            break;
                        }
                        case INSTALLED: {
                            continue block14;
                        }
                        case TO_BE_UNINSTALLED: {
                            if (product.getStatus() == Status.NOT_INSTALLED) continue block14;
                            product.setStatus(status);
                        }
                    }
                    if ((productPropertiesElement = XMLUtils.getChild(productElement, "properties")) == null) continue;
                    product.getProperties().putAll((Map<?, ?>)XMLUtils.parseNbiProperties(productPropertiesElement));
                }
            }
            LogManager.log(4, "    ...complete");
        }
        catch (DownloadException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_LOADING_COMPONENTS), e);
        }
        catch (ParserConfigurationException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_LOADING_COMPONENTS), e);
        }
        catch (SAXException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_LOADING_COMPONENTS), e);
        }
        catch (IOException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_LOADING_COMPONENTS), e);
        }
        catch (ParseException e) {
            throw new InitializationException(ResourceUtils.getString(Registry.class, ERROR_LOADING_COMPONENTS), e);
        }
    }

    public void saveStateFile(File stateFile, Progress progress) throws FinalizationException {
        try {
            List<Product> products;
            File schemaFile = FileProxy.getInstance().getFile(this.stateFileSchemaUri, true);
            File stubFile = FileProxy.getInstance().getFile(this.stateFileStubUri, true);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setSchema(schema);
            }
            catch (UnsupportedOperationException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(Registry.class, ERROR_PARSER_DO_NOT_CUPPORT_SCHEMAS_KEY, factory.getClass()), e);
            }
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(stubFile);
            Element documentElement = document.getDocumentElement();
            if (this.properties.size() > 0) {
                Element propertiesNode = document.createElement("properties");
                for (Object key : this.properties.keySet()) {
                    String name = (String)key;
                    Element propertyNode = document.createElement("property");
                    propertyNode.setAttribute("name", name);
                    propertyNode.setTextContent(this.properties.getProperty(name));
                    propertiesNode.appendChild(propertyNode);
                }
                documentElement.appendChild(propertiesNode);
            }
            if ((products = this.queryProducts(new OrFilter(new ProductFilter(Status.INSTALLED, this.targetPlatform), new ProductFilter(Status.NOT_INSTALLED, this.targetPlatform)))).size() > 0) {
                Element productsNode = document.createElement("components");
                block13: for (Product component : products) {
                    Element productNode = document.createElement("product");
                    productNode.setAttribute("uid", component.getUid());
                    productNode.setAttribute("version", component.getVersion().toString());
                    productNode.setAttribute("platform", StringUtils.asString(component.getPlatforms(), " "));
                    switch (component.getStatus()) {
                        case INSTALLED: {
                            productNode.setAttribute("status", Status.TO_BE_INSTALLED.toString());
                            break;
                        }
                        case NOT_INSTALLED: {
                            productNode.setAttribute("status", Status.TO_BE_UNINSTALLED.toString());
                            break;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    if (component.getProperties().size() > 0) {
                        Element propertiesNode = document.createElement("properties");
                        Properties props = new Properties();
                        props.putAll((Map<?, ?>)component.getProperties());
                        for (Object key : props.keySet()) {
                            String name = (String)key;
                            Element propertyNode = document.createElement("property");
                            propertyNode.setAttribute("name", name);
                            propertyNode.setTextContent(props.getProperty(name));
                            propertiesNode.appendChild(propertyNode);
                        }
                        productNode.appendChild(propertiesNode);
                    }
                    productsNode.appendChild(productNode);
                }
                documentElement.appendChild(productsNode);
            }
            FileUtils.mkdirs(stateFile.getParentFile());
            XMLUtils.saveXMLDocument(document, stateFile);
        }
        catch (DownloadException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
        catch (ParserConfigurationException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
        catch (SAXException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
        catch (IOException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
        catch (XMLException e) {
            throw new FinalizationException(ResourceUtils.getString(Registry.class, ERROR_REGISTRY_FINALIZATION), e);
        }
    }

    public File getLocalProductCache() {
        return this.localProductCache;
    }

    public RegistryNode getRegistryRoot() {
        return this.registryRoot;
    }

    public boolean hasInstalledChildren(RegistryNode parentNode) {
        for (RegistryNode child : parentNode.getChildren()) {
            Product component;
            if (child instanceof Product && (component = (Product)child).getStatus() == Status.INSTALLED) {
                return true;
            }
            if (!this.hasInstalledChildren(child)) continue;
            return true;
        }
        return false;
    }

    public Platform getTargetPlatform() {
        return this.targetPlatform;
    }
}

