/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class InitializeRegistryAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(InitializeRegistryAction.class, "IRA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(InitializeRegistryAction.class, "IRA.description");
    public static final String DEFAULT_REGISTRY_INITIALIZATION_FAILED_MESSAGE = ResourceUtils.getString(InitializeRegistryAction.class, "IRA.registry.initialization.failed");
    public static final String REGISTRY_INITIALIZATION_FAILED_PROPERTY = "registry.initialization.failed";

    public InitializeRegistryAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(REGISTRY_INITIALIZATION_FAILED_PROPERTY, DEFAULT_REGISTRY_INITIALIZATION_FAILED_MESSAGE);
    }

    public void execute() {
        try {
            Progress progress = new Progress();
            this.getWizardUi().setProgress(progress);
            Registry.getInstance().initializeRegistry(progress);
        }
        catch (InitializationException e) {
            ErrorManager.notifyCritical(StringUtils.format(this.getProperty(REGISTRY_INITIALIZATION_FAILED_PROPERTY), new Object[0]), e);
        }
    }

    public boolean isCancelable() {
        return false;
    }
}

