/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

public class InheritanceImpl
extends OffsetableIdentifiableBase<CsmInheritance>
implements CsmInheritance,
Resolver.SafeClassifierProvider {
    private CsmVisibility visibility;
    private boolean virtual;
    private CsmType ancestorType;
    private CsmClassifier resolvedClassifier;
    private CsmUID<CsmScope> scope;

    public InheritanceImpl(AST aST, CsmFile csmFile, CsmScope csmScope) {
        super(aST, csmFile);
        this.scope = UIDCsmConverter.scopeToUID(csmScope);
        this.visibility = ((CsmDeclaration)csmScope).getKind() == CsmDeclaration.Kind.STRUCT ? CsmVisibility.PUBLIC : CsmVisibility.PRIVATE;
        block7: for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            switch (aST2.getType()) {
                case 164: {
                    this.visibility = CsmVisibility.PRIVATE;
                    continue block7;
                }
                case 162: {
                    this.visibility = CsmVisibility.PUBLIC;
                    continue block7;
                }
                case 163: {
                    this.visibility = CsmVisibility.PROTECTED;
                    continue block7;
                }
                case 123: {
                    this.virtual = true;
                    continue block7;
                }
                case 89: {
                    this.ancestorType = TemplateUtils.checkTemplateType(TypeFactory.createType(aST2, this.getContainingFile(), null, 0), csmScope);
                    return;
                }
            }
        }
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public CsmType getAncestorType() {
        return this.ancestorType;
    }

    public CsmClassifier getClassifier() {
        return this.getClassifier(null);
    }

    @Override
    public CsmClassifier getClassifier(Resolver resolver) {
        if (!CsmBaseUtilities.isValid((CsmObject)this.resolvedClassifier)) {
            this.resolvedClassifier = this.getAncestorType() instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)this.getAncestorType()).getClassifier(resolver) : this.getAncestorType().getClassifier();
        }
        return this.resolvedClassifier;
    }

    @Override
    protected CsmUID<CsmInheritance> createUID() {
        return UIDUtilities.createInheritanceUID(this);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 11 * n + this.visibility.hashCode();
        n = 11 * n + (this.virtual ? 1 : 0);
        n = 11 * n + (this.ancestorType != null ? this.ancestorType.hashCode() : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof InheritanceImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        InheritanceImpl inheritanceImpl = (InheritanceImpl)object;
        if (this.visibility != inheritanceImpl.visibility) {
            return false;
        }
        if (this.virtual != inheritanceImpl.virtual) {
            return false;
        }
        return this.ancestorType == inheritanceImpl.ancestorType || this.ancestorType != null && this.ancestorType.equals(inheritanceImpl.ancestorType);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
        dataOutput.writeBoolean(this.virtual);
        PersistentUtils.writeType(this.ancestorType, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUID(this.scope, dataOutput);
    }

    public InheritanceImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.visibility = PersistentUtils.readVisibility(dataInput);
        this.virtual = dataInput.readBoolean();
        this.ancestorType = PersistentUtils.readType(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.scope = uIDObjectFactory.readUID(dataInput);
    }

    @Override
    public String toString() {
        return "INHERITANCE " + this.visibility + " " + (this.isVirtual() ? "virtual " : "") + this.ancestorType.getText() + this.getOffsetString();
    }

    public CsmScope getScope() {
        return UIDCsmConverter.UIDtoScope(this.scope);
    }
}

