/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFunPtrImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.EmptyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyTryCatchStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.fsm.DummyParametersListImpl;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.util.CharSequences;

public class PersistentUtils {
    private static final int UTF_LIMIT = 65535;
    private static final String NULL_STRING = new String(new char[]{'\u0000'});
    private static final int FIRST_INDEX = 85;
    private static final int VISIBILITY_PUBLIC = 85;
    private static final int VISIBILITY_PROTECTED = 86;
    private static final int VISIBILITY_PRIVATE = 87;
    private static final int VISIBILITY_NONE = 88;
    private static final int EXPRESSION_BASE = 89;
    private static final int FILE_BUFFER_FILE = 90;
    private static final int NO_TYPE = 91;
    private static final int TYPE_IMPL = 92;
    private static final int NESTED_TYPE = 93;
    private static final int TYPE_FUN_PTR_IMPL = 94;
    private static final int TEMPLATE_PARAM_TYPE = 95;
    private static final int PREPROC_STATE_STATE_IMPL = 96;
    private static final int LAZY_COMPOUND_STATEMENT_IMPL = 97;
    private static final int LAZY_TRY_CATCH_STATEMENT_IMPL = 98;
    private static final int EMPTY_COMPOUND_STATEMENT_IMPL = 99;
    private static final int COMPOUND_STATEMENT_IMPL = 100;
    private static final int PARAM_LIST_IMPL = 101;
    private static final int FUN_PARAM_LIST_IMPL = 102;
    private static final int FUN_KR_PARAM_LIST_IMPL = 103;
    private static final int DUMMY_PARAMS_LIST_IMPL = 104;
    private static final int TEMPLATE_DESCRIPTOR_IMPL = 105;
    private static final int SPECIALIZATION_DESCRIPTOR_IMPL = 106;
    private static final int SPECIALIZATION_PARAMETERS_LIST = 107;
    private static final int TYPE_BASED_SPECIALIZATION_PARAMETER_IMPL = 108;
    private static final int EXPRESSION_BASED_SPECIALIZATION_PARAMETER_IMPL = 109;
    public static final int LAST_INDEX = 109;

    public static void readErrorDirectives(Set<ErrorDirectiveImpl> set, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            ErrorDirectiveImpl errorDirectiveImpl = new ErrorDirectiveImpl(dataInput);
            set.add(errorDirectiveImpl);
        }
    }

    public static void writeErrorDirectives(Set<ErrorDirectiveImpl> set, DataOutput dataOutput) throws IOException {
        int n = set.size();
        dataOutput.writeInt(n);
        for (ErrorDirectiveImpl errorDirectiveImpl : set) {
            errorDirectiveImpl.write(dataOutput);
        }
    }

    private PersistentUtils() {
    }

    public static void writeParameterList(CsmParameterList<?> csmParameterList, DataOutput dataOutput) throws IOException {
        if (csmParameterList == null) {
            dataOutput.writeInt(-1);
        } else if (csmParameterList instanceof ParameterListImpl) {
            int n = 101;
            if (csmParameterList instanceof FunctionParameterListImpl) {
                n = 102;
                if (csmParameterList instanceof FunctionParameterListImpl.FunctionKnRParameterListImpl) {
                    n = 103;
                }
            }
            if (csmParameterList instanceof DummyParametersListImpl) {
                n = 104;
            }
            dataOutput.writeInt(n);
            ((ParameterListImpl)csmParameterList).write(dataOutput);
        }
    }

    public static CsmParameterList<?> readParameterList(DataInput dataInput) throws IOException {
        ParameterListImpl parameterListImpl;
        int n = dataInput.readInt();
        switch (n) {
            case -1: {
                parameterListImpl = null;
                break;
            }
            case 101: {
                parameterListImpl = new ParameterListImpl(dataInput);
                break;
            }
            case 102: {
                parameterListImpl = new FunctionParameterListImpl(dataInput);
                break;
            }
            case 103: {
                parameterListImpl = new FunctionParameterListImpl.FunctionKnRParameterListImpl(dataInput);
                break;
            }
            case 104: {
                parameterListImpl = new DummyParametersListImpl(dataInput);
                break;
            }
            default: {
                assert (false) : "unexpected param list implementation " + n;
                parameterListImpl = null;
            }
        }
        return parameterListImpl;
    }

    public static void writeBuffer(FileBuffer fileBuffer, DataOutput dataOutput) throws IOException {
        assert (fileBuffer != null);
        if (!(fileBuffer instanceof AbstractFileBuffer)) {
            throw new IllegalArgumentException("instance of unknown FileBuffer " + fileBuffer);
        }
        dataOutput.writeInt(90);
        PersistentUtils.writeUTF(((AbstractFileBuffer)fileBuffer).getAbsolutePath(), dataOutput);
    }

    public static FileBuffer readBuffer(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        assert (n == 90);
        CharSequence charSequence = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
        FileBufferFile fileBufferFile = new FileBufferFile(charSequence);
        return fileBufferFile;
    }

    public static void writeStrings(CharSequence[] charSequenceArray, DataOutput dataOutput) throws IOException {
        if (charSequenceArray == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = charSequenceArray.length;
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                assert (charSequenceArray[i] != null);
                PersistentUtils.writeUTF(charSequenceArray[i], dataOutput);
            }
        }
    }

    public static void writeCollectionStrings(Collection<CharSequence> collection, DataOutput dataOutput) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CharSequence charSequence : collection) {
                assert (charSequence != null);
                PersistentUtils.writeUTF(charSequence, dataOutput);
            }
        }
    }

    public static CharSequence[] readStrings(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        CharSequence[] charSequenceArray = null;
        int n = dataInput.readInt();
        if (n != -1) {
            charSequenceArray = new CharSequence[n];
            for (int i = 0; i < n; ++i) {
                charSequenceArray[i] = aPTStringManager.getString(PersistentUtils.readUTF(dataInput, aPTStringManager));
            }
        }
        return charSequenceArray;
    }

    public static Collection<CharSequence> readCollectionStrings(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        ArrayList<CharSequence> arrayList = null;
        int n = dataInput.readInt();
        if (n != -1) {
            arrayList = new ArrayList<CharSequence>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(PersistentUtils.readUTF(dataInput, aPTStringManager));
            }
        }
        return arrayList;
    }

    public static void writeUTF(CharSequence charSequence, DataOutput dataOutput) throws IOException {
        if (charSequence == null) {
            dataOutput.writeUTF(NULL_STRING);
        } else {
            assert (CharSequences.isCompact((CharSequence)charSequence));
            dataOutput.writeUTF(((Object)charSequence).toString());
        }
    }

    public static CharSequence readUTF(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        String string = dataInput.readUTF();
        if (string.length() == 1 && string.charAt(0) == '\u0000') {
            return null;
        }
        CharSequence charSequence = aPTStringManager.getString((CharSequence)string);
        assert (CharSequences.isCompact((CharSequence)charSequence));
        return charSequence;
    }

    public static void writeExpression(CsmExpression csmExpression, DataOutput dataOutput) throws IOException {
        if (csmExpression == null) {
            dataOutput.writeInt(-1);
        } else if (csmExpression instanceof ExpressionBase) {
            dataOutput.writeInt(89);
            ((ExpressionBase)csmExpression).write(dataOutput);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmExpression " + csmExpression);
        }
    }

    public static CsmExpression readExpression(DataInput dataInput) throws IOException {
        ExpressionBase expressionBase;
        int n = dataInput.readInt();
        if (n == -1) {
            expressionBase = null;
        } else {
            assert (n == 89);
            expressionBase = new ExpressionBase(dataInput);
        }
        return expressionBase;
    }

    public static void writeExpressions(Collection<CsmExpression> collection, DataOutput dataOutput) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CsmExpression csmExpression : collection) {
                assert (csmExpression != null);
                PersistentUtils.writeExpression(csmExpression, dataOutput);
            }
        }
    }

    public static <T extends Collection<CsmExpression>> T readExpressions(T t, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != -1) {
            for (int i = 0; i < n; ++i) {
                CsmExpression csmExpression = PersistentUtils.readExpression(dataInput);
                assert (csmExpression != null);
                t.add((CsmExpression)csmExpression);
            }
            return t;
        }
        t = null;
        return t;
    }

    public static void writeExpressionKind(CsmExpression.Kind kind, DataOutput dataOutput) throws IOException {
        if (kind != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        dataOutput.writeInt(-1);
    }

    public static CsmExpression.Kind readExpressionKind(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != -1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        CsmExpression.Kind kind = null;
        return kind;
    }

    public static CsmType readType(DataInput dataInput) throws IOException {
        Object object;
        int n = dataInput.readInt();
        switch (n) {
            case -1: {
                object = null;
                break;
            }
            case 91: {
                object = NoType.instance();
                break;
            }
            case 92: {
                object = new TypeImpl(dataInput);
                break;
            }
            case 93: {
                object = new NestedType(dataInput);
                break;
            }
            case 94: {
                object = new TypeFunPtrImpl(dataInput);
                break;
            }
            case 95: {
                object = new TemplateParameterTypeImpl(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type handler" + n);
            }
        }
        return object;
    }

    public static void writeType(CsmType csmType, DataOutput dataOutput) throws IOException {
        if (csmType == null) {
            dataOutput.writeInt(-1);
        } else if (csmType instanceof NoType) {
            dataOutput.writeInt(91);
        } else if (csmType instanceof TypeImpl) {
            if (csmType instanceof TypeFunPtrImpl) {
                dataOutput.writeInt(94);
                ((TypeFunPtrImpl)csmType).write(dataOutput);
            } else if (csmType instanceof NestedType) {
                dataOutput.writeInt(93);
                ((NestedType)csmType).write(dataOutput);
            } else {
                dataOutput.writeInt(92);
                ((TypeImpl)csmType).write(dataOutput);
            }
        } else if (csmType instanceof TemplateParameterTypeImpl) {
            dataOutput.writeInt(95);
            ((TemplateParameterTypeImpl)csmType).write(dataOutput);
        } else {
            throw new IllegalArgumentException("instance of unknown class " + csmType.getClass().getName());
        }
    }

    public static <T extends Collection<CsmType>> void readTypes(T t, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            CsmType csmType = PersistentUtils.readType(dataInput);
            assert (csmType != null);
            t.add((CsmType)csmType);
        }
    }

    public static void writeTypes(Collection<? extends CsmType> collection, DataOutput dataOutput) throws IOException {
        assert (collection != null);
        int n = collection.size();
        dataOutput.writeInt(n);
        for (CsmType csmType : collection) {
            assert (csmType != null);
            PersistentUtils.writeType(csmType, dataOutput);
        }
    }

    public static TemplateDescriptor readTemplateDescriptor(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        assert (n == 105);
        return new TemplateDescriptor(dataInput);
    }

    public static void writeTemplateDescriptor(TemplateDescriptor templateDescriptor, DataOutput dataOutput) throws IOException {
        if (templateDescriptor == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(105);
            templateDescriptor.write(dataOutput);
        }
    }

    public static SpecializationDescriptor readSpecializationDescriptor(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        assert (n == 106);
        return new SpecializationDescriptor(dataInput);
    }

    public static void writeSpecializationDescriptor(SpecializationDescriptor specializationDescriptor, DataOutput dataOutput) throws IOException {
        if (specializationDescriptor == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(106);
            specializationDescriptor.write(dataOutput);
        }
    }

    public static void writeSpecializationParameters(List<CsmSpecializationParameter> list, DataOutput dataOutput) throws IOException {
        if (list == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(107);
            dataOutput.writeInt(list.size());
            for (CsmSpecializationParameter csmSpecializationParameter : list) {
                if (csmSpecializationParameter instanceof TypeBasedSpecializationParameterImpl) {
                    dataOutput.writeInt(108);
                    ((TypeBasedSpecializationParameterImpl)csmSpecializationParameter).write(dataOutput);
                    continue;
                }
                if (csmSpecializationParameter instanceof ExpressionBasedSpecializationParameterImpl) {
                    dataOutput.writeInt(109);
                    ((ExpressionBasedSpecializationParameterImpl)csmSpecializationParameter).write(dataOutput);
                    continue;
                }
                assert (false) : "unexpected instance of specialization parameter ";
            }
        }
    }

    public static List<CsmSpecializationParameter> readSpecializationParameters(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        assert (n == 107);
        ArrayList<CsmSpecializationParameter> arrayList = new ArrayList<CsmSpecializationParameter>();
        PersistentUtils.readSpecializationParametersList(arrayList, dataInput);
        return arrayList;
    }

    public static void readSpecializationParameters(List<CsmSpecializationParameter> list, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return;
        }
        assert (n == 107) : "unexpected handler " + n;
        PersistentUtils.readSpecializationParametersList(list, dataInput);
    }

    private static void readSpecializationParametersList(List<CsmSpecializationParameter> list, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readInt();
            if (n2 == 108) {
                list.add((CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(dataInput));
                continue;
            }
            if (n2 == 109) {
                list.add((CsmSpecializationParameter)new ExpressionBasedSpecializationParameterImpl(dataInput));
                continue;
            }
            assert (false) : "unexpected instance of specialization parameter ";
        }
    }

    public static void writeVisibility(CsmVisibility csmVisibility, DataOutput dataOutput) throws IOException {
        assert (csmVisibility != null);
        int n = -1;
        if (csmVisibility == CsmVisibility.PUBLIC) {
            n = 85;
        } else if (csmVisibility == CsmVisibility.PROTECTED) {
            n = 86;
        } else if (csmVisibility == CsmVisibility.PRIVATE) {
            n = 87;
        } else if (csmVisibility == CsmVisibility.NONE) {
            n = 88;
        } else {
            throw new IllegalArgumentException("instance of unknown visibility " + csmVisibility);
        }
        dataOutput.writeInt(n);
    }

    public static CsmVisibility readVisibility(DataInput dataInput) throws IOException {
        CsmVisibility csmVisibility = null;
        int n = dataInput.readInt();
        switch (n) {
            case 85: {
                csmVisibility = CsmVisibility.PUBLIC;
                break;
            }
            case 86: {
                csmVisibility = CsmVisibility.PROTECTED;
                break;
            }
            case 87: {
                csmVisibility = CsmVisibility.PRIVATE;
                break;
            }
            case 88: {
                csmVisibility = CsmVisibility.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + n);
            }
        }
        return csmVisibility;
    }

    public static void writeCompoundStatement(CsmCompoundStatement csmCompoundStatement, DataOutput dataOutput) throws IOException {
        assert (csmCompoundStatement != null);
        if (csmCompoundStatement instanceof LazyCompoundStatementImpl) {
            dataOutput.writeInt(97);
            ((LazyCompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else if (csmCompoundStatement instanceof LazyTryCatchStatementImpl) {
            dataOutput.writeInt(98);
            ((LazyTryCatchStatementImpl)csmCompoundStatement).write(dataOutput);
        } else if (csmCompoundStatement instanceof EmptyCompoundStatementImpl) {
            dataOutput.writeInt(99);
            ((EmptyCompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else if (csmCompoundStatement instanceof CompoundStatementImpl) {
            dataOutput.writeInt(100);
            ((CompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else {
            throw new IllegalArgumentException("unknown compound statement " + csmCompoundStatement);
        }
    }

    public static CsmCompoundStatement readCompoundStatement(DataInput dataInput) throws IOException {
        StatementBase statementBase;
        int n = dataInput.readInt();
        switch (n) {
            case 97: {
                statementBase = new LazyCompoundStatementImpl(dataInput);
                break;
            }
            case 98: {
                statementBase = new LazyTryCatchStatementImpl(dataInput);
                break;
            }
            case 99: {
                statementBase = new EmptyCompoundStatementImpl(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + n);
            }
        }
        return statementBase;
    }

    public static void writePreprocState(APTPreprocHandler.State state, DataOutput dataOutput) throws IOException {
        APTPreprocHandler.State state2 = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        APTSerializeUtils.writePreprocState((APTPreprocHandler.State)state2, (DataOutput)dataOutput);
    }

    public static APTPreprocHandler.State readPreprocState(DataInput dataInput) throws IOException {
        APTPreprocHandler.State state = APTSerializeUtils.readPreprocState((DataInput)dataInput);
        assert (state.isCleaned());
        return state;
    }
}

