/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.resources;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassSupport;

public final class ResourcesSupport {
    private static final InfoPresenter.Resolver RESOURCE_RESOLVER = new ResourceResolver();

    public static InfoPresenter createResourceInfoResolver() {
        return InfoPresenter.create((InfoPresenter.Resolver)RESOURCE_RESOLVER);
    }

    private ResourcesSupport() {
    }

    private static class ResourceResolver
    implements InfoPresenter.Resolver {
        private ResourceResolver() {
        }

        public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return ClassSupport.resolveDisplayName(component);
                }
                case SECONDARY: {
                    return MidpTypes.getSimpleClassName(component.getType());
                }
                case TERTIARY: {
                    return "<HTML>" + InfoPresenter.getHtmlDisplayName((DesignComponent)component);
                }
            }
            throw new IllegalStateException();
        }

        public DesignEventFilter getEventFilter(DesignComponent component) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(component, false);
        }

        public boolean isEditable(DesignComponent component) {
            return true;
        }

        public String getEditableName(DesignComponent component) {
            if (component == null) {
                throw Debug.error((Object[])new Object[]{"Component cannot be null"});
            }
            return (String)component.readProperty("instanceName").getPrimitiveValue();
        }

        public void setEditableName(DesignComponent component, String name) {
            if (component == null || name == null) {
                throw Debug.error((Object[])new Object[]{"Component or name cannot be null"});
            }
            component.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(component, name));
        }

        public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
            if (InfoPresenter.IconType.COLOR_16x16.equals((Object)iconType)) {
                for (ComponentDescriptor descriptor = component.getComponentDescriptor(); descriptor != null; descriptor = descriptor.getSuperDescriptor()) {
                    Image image = MidpTypes.getRegisteredIcon(descriptor.getTypeDescriptor().getThisType());
                    if (image == null) continue;
                    return image;
                }
            }
            return null;
        }
    }
}

