/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.project.ui.J2eePlatformUiSupport;
import org.netbeans.modules.j2ee.common.project.ui.MessageUtils;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final AppClientProjectProperties uiProperties;
    private final String oldServerInstanceId;
    private JLabel errorLabel;
    private JButton jButtonMainClass;
    private JButton jButtonWorkingDirectoryBrowse;
    private JComboBox jComboBoxJ2eeSpecVersion;
    private JComboBox jComboBoxServer;
    private JLabel jLabelArgs;
    private JLabel jLabelJ2EE;
    private JLabel jLabelMainClass;
    private JLabel jLabelServer;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextField jTextVMOptions;
    private JTextField jTextWorkingDirectory;

    public CustomizerRun(AppClientProjectProperties appClientProjectProperties) {
        this.initComponents();
        this.uiProperties = appClientProjectProperties;
        this.oldServerInstanceId = appClientProjectProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null ? J2eePlatformUiSupport.getServerInstanceID((Object)appClientProjectProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem()) : null;
        appClientProjectProperties.JAVAC_CLASSPATH_MODEL.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CustomizerRun.this.setMessages();
            }
        });
        this.jTextFieldMainClass.setDocument(appClientProjectProperties.MAIN_CLASS_MODEL);
        this.jTextFieldArgs.setDocument(appClientProjectProperties.APPLICATION_ARGS_MODEL);
        this.jTextVMOptions.setDocument(appClientProjectProperties.RUN_JVM_ARGS_MODEL);
        this.jTextWorkingDirectory.setDocument(appClientProjectProperties.RUN_WORK_DIR_MODEL);
        this.jButtonMainClass.addActionListener(new MainClassListener(appClientProjectProperties.getProject().getSourceRoots(), this.jTextFieldMainClass));
        this.jComboBoxJ2eeSpecVersion.setModel(appClientProjectProperties.J2EE_PLATFORM_MODEL);
        this.jComboBoxServer.setModel(appClientProjectProperties.J2EE_SERVER_INSTANCE_MODEL);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.jLabelVMOptions = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptionsExample = new JLabel();
        this.jLabelServer = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.jLabelJ2EE = new JLabel();
        this.jComboBoxJ2eeSpecVersion = new JComboBox();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jTextFieldMainClass, gridBagConstraints);
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_jTextFieldMainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jButtonMainClass, gridBagConstraints);
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelArgs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jTextFieldArgs, gridBagConstraints);
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        this.jLabelWorkingDirectory.setLabelFor(this.jTextWorkingDirectory);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jTextWorkingDirectory, gridBagConstraints);
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizeRun_Run_Working_Directory"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jButtonWorkingDirectoryBrowse, gridBagConstraints);
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelVMOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jTextVMOptions, gridBagConstraints);
        this.jTextVMOptions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizeRun_Run_VM_Options"));
        this.jLabelVMOptionsExample.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jLabelVMOptionsExample, gridBagConstraints);
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelServer, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Server_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelServer, gridBagConstraints);
        this.jComboBoxServer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerRun.this.jComboBoxServerItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jComboBoxServer, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJ2EE, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_J2EE_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelJ2EE, gridBagConstraints);
        this.jComboBoxJ2eeSpecVersion.setEnabled(false);
        this.jComboBoxJ2eeSpecVersion.setPrototypeDisplayValue("MMMMMMMMM");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jComboBoxJ2eeSpecVersion, gridBagConstraints);
        this.errorLabel.setForeground(new Color(89, 71, 191));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        String string = this.jTextWorkingDirectory.getText();
        if (string.equals("")) {
            string = FileUtil.toFile((FileObject)this.uiProperties.getProject().getProjectDirectory()).getAbsolutePath();
        }
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void jComboBoxServerItemStateChanged(ItemEvent itemEvent) {
        this.setMessages();
    }

    private void setMessages() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        boolean bl = false;
        if (this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null && this.isServerLibraryMessageNeeded(J2eePlatformUiSupport.getServerInstanceID((Object)this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem()), this.uiProperties)) {
            stringBuilder.append(NbBundle.getMessage(CustomizerRun.class, (String)"MSG_CREATING_LIBRARY"));
            bl = true;
        }
        if (bl) {
            stringBuilder.append("</html>");
            MessageUtils.setMessage((JLabel)this.errorLabel, (MessageUtils.MessageType)MessageUtils.MessageType.WARNING, (String)stringBuilder.toString());
        } else {
            MessageUtils.clear((JLabel)this.errorLabel);
        }
    }

    private boolean isServerLibraryMessageNeeded(String string, AppClientProjectProperties appClientProjectProperties) {
        UpdateHelper updateHelper = appClientProjectProperties.getProject().getUpdateHelper();
        try {
            if (SharabilityUtility.isLibrarySwitchIntended((String)string, (String)this.oldServerInstanceId, (List)ClassPathUiSupport.getList((DefaultListModel)appClientProjectProperties.JAVAC_CLASSPATH_MODEL.getDefaultListModel()), (UpdateHelper)updateHelper)) {
                AntProjectHelper antProjectHelper = updateHelper.getAntProjectHelper();
                Library[] libraryArray = SharabilityUtility.getLibraries((File)antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation()), (String)string);
                return libraryArray.length <= 0;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private SourceRoots sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField jTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = jTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final MainClassChooser mainClassChooser = new MainClassChooser(this.sourceRoots.getRoots());
            Object[] objectArray = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            mainClassChooser.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(mainClassChooser.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassChooser, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == objectArray[0]) {
                this.mainClassTextField.setText(mainClassChooser.getSelectedMainClass());
            }
            dialog.dispose();
        }
    }
}

