/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.awt.Image;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javacard.spi.AbstractCard;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardChildren;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.CardStateObserver;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.CardContentsProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class Cards {
    private final ChangeSupport supp = new ChangeSupport((Object)this);

    protected Cards() {
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    public abstract List<? extends Lookup.Provider> getCardSources();

    public final List<Card> getCards(boolean onlyValid) {
        List<? extends Lookup.Provider> provs = this.getCardSources();
        ArrayList<Card> result = new ArrayList<Card>(provs.size());
        for (Lookup.Provider provider : provs) {
            Card c = this.findCard(provider);
            if (c == null || onlyValid && (!onlyValid || !c.isValid())) continue;
            result.add(c);
        }
        return result;
    }

    public final synchronized void addChangeListener(ChangeListener cl) {
        boolean hadListeners = this.supp.hasListeners();
        this.supp.addChangeListener(cl);
        if (!hadListeners) {
            this.addNotify();
        }
    }

    public final synchronized void removeChangeListener(ChangeListener cl) {
        this.supp.removeChangeListener(cl);
        if (!this.supp.hasListeners()) {
            this.removeNotify();
        }
    }

    public Children createChildren() {
        return Children.create((ChildFactory)new CF(), (boolean)true);
    }

    public Children createChildren(String expectedCardSystemId) {
        return Children.create((ChildFactory)new CF(expectedCardSystemId), (boolean)true);
    }

    protected final void fireChange() {
        this.supp.fireChange();
    }

    public final Card find(String systemId, boolean returnDummyCard) {
        for (Card c : this.getCards(false)) {
            if (!systemId.equals(c.getSystemId())) continue;
            return c;
        }
        return returnDummyCard ? AbstractCard.createBrokenCard(systemId) : null;
    }

    private Card findCard(Lookup.Provider prov) {
        Card card;
        DataObject dob = (DataObject)prov.getLookup().lookup(DataObject.class);
        if (dob != null) {
            card = (Card)dob.getLookup().lookup(Card.class);
            if (card == null) {
                card = (Card)dob.getNodeDelegate().getLookup().lookup(Card.class);
                if (card != null) {
                    return card;
                }
            } else {
                return card;
            }
        }
        card = (Card)prov.getLookup().lookup(Card.class);
        return card;
    }

    private static final class DummyProvider
    implements Lookup.Provider {
        private final Card dummyCard;

        DummyProvider(String s) {
            this.dummyCard = AbstractCard.createBrokenCard(s);
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.dummyCard);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DummyProvider other = (DummyProvider)obj;
            return this.dummyCard == other.dummyCard || this.dummyCard != null && this.dummyCard.equals(other.dummyCard);
        }

        public int hashCode() {
            return this.dummyCard.getSystemId().hashCode();
        }
    }

    private static final class CardNode
    extends AbstractNode
    implements CardStateObserver {
        private Card hardRef;

        CardNode(Lookup.Provider p) {
            super(Children.LEAF, p.getLookup());
            Card card;
            this.hardRef = card = (Card)this.getLookup().lookup(Card.class);
            this.setName(card.getSystemId());
            CardInfo info = card.getCapability(CardInfo.class);
            if (info != null) {
                this.setDisplayName(info.getDisplayName());
                this.setShortDescription(info.getDescription());
            } else {
                this.setDisplayName(this.getName());
            }
            card.addCardStateObserver(new WeakCardStateObserver(this));
            CardContentsProvider prov = card.getCapability(CardContentsProvider.class);
            if (prov != null) {
                this.setChildren(Children.create((ChildFactory)new CardChildren(prov), (boolean)true));
            }
        }

        public void destroy() throws IOException {
            this.hardRef = null;
            super.destroy();
        }

        public Action[] getActions(boolean ignored) {
            Card card = (Card)this.getLookup().lookup(Card.class);
            JavacardPlatform platform = card.getPlatform();
            String kind = platform.getPlatformKind();
            String path = "org-netbeans-modules-javacard-spi/kinds/" + kind + "/Actions/";
            return Lookups.forPath((String)path).lookupAll(Action.class).toArray(new Action[0]);
        }

        public String getHtmlDisplayName() {
            Card card = (Card)this.getLookup().lookup(Card.class);
            if (!card.isValid()) {
                return "<font color='!nb.errorForeground'>" + this.getDisplayName();
            }
            if (!card.getState().isRunning()) {
                return "<font color='!controlShadow'>" + this.getDisplayName();
            }
            return null;
        }

        public Image getIcon(int type) {
            CardInfo info;
            Image result = null;
            Card card = (Card)this.getLookup().lookup(Card.class);
            if (card != null && (info = card.getCapability(CardInfo.class)) != null) {
                result = info.getIcon();
            }
            Image image = result = result == null ? super.getIcon(type) : result;
            if (card != null && card.getState().isRunning()) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/spi/resources/running.png");
                result = ImageUtilities.mergeImages((Image)result, (Image)badge, (int)11, (int)11);
            }
            return result;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = Sheet.createPropertiesSet();
            set.put((Node.Property)new IdProp());
            set.put((Node.Property)new StateProp());
            set.put((Node.Property)new ValidProp());
            sheet.put(set);
            return sheet;
        }

        @Override
        public void onStateChange(Card card, CardState old, CardState nue) {
            this.fireIconChange();
            this.fireDisplayNameChange("", this.getDisplayName());
            this.firePropertyChange("state", old.toString(), nue.toString());
        }

        private class IdProp
        extends PropertySupport.ReadOnly<String> {
            IdProp() {
                super("id", String.class, NbBundle.getMessage(IdProp.class, (String)"PROP_ID"), NbBundle.getMessage(IdProp.class, (String)"DESC_PROP_ID"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                Card card = (Card)CardNode.this.getLookup().lookup(Card.class);
                return card == null ? "?" : card.getSystemId();
            }
        }

        private class ValidProp
        extends PropertySupport.ReadOnly<Boolean> {
            ValidProp() {
                super("valid", Boolean.class, NbBundle.getMessage(ValidProp.class, (String)"PROP_VALID"), NbBundle.getMessage(ValidProp.class, (String)"DESC_PROP_VALID"));
            }

            public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
                Card card = (Card)CardNode.this.getLookup().lookup(Card.class);
                return card != null && card.isValid();
            }
        }

        private class StateProp
        extends PropertySupport.ReadOnly<String> {
            StateProp() {
                super("state", String.class, NbBundle.getMessage(StateProp.class, (String)"PROP_STATE"), NbBundle.getMessage(StateProp.class, (String)"DESC_PROP_STATE"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                Card card = (Card)CardNode.this.getLookup().lookup(Card.class);
                return card == null ? "" : card.getState().toString();
            }
        }
    }

    private static final class WeakCardStateObserver
    implements CardStateObserver {
        private final Reference<CardStateObserver> ref;

        WeakCardStateObserver(CardStateObserver real) {
            this.ref = new WeakReference<CardStateObserver>(real);
        }

        @Override
        public void onStateChange(Card card, CardState old, CardState nue) {
            CardStateObserver real = this.ref.get();
            if (real == null) {
                card.removeCardStateObserver(this);
            } else {
                real.onStateChange(card, old, nue);
            }
        }
    }

    private class CF
    extends ChildFactory.Detachable<Lookup.Provider>
    implements ChangeListener {
        private final String brokenCardName;

        CF(String brokenCardName) {
            this.brokenCardName = brokenCardName;
        }

        CF() {
            this(null);
        }

        protected void addNotify() {
            super.addNotify();
            Cards.this.addChangeListener(this);
        }

        protected void removeNotify() {
            super.removeNotify();
            Cards.this.removeChangeListener(this);
        }

        protected boolean createKeys(List<Lookup.Provider> toPopulate) {
            toPopulate.addAll(Cards.this.getCardSources());
            if (this.brokenCardName != null) {
                Lookup.Provider lp;
                Card card;
                boolean found = false;
                Iterator<Lookup.Provider> i$ = toPopulate.iterator();
                while (i$.hasNext() && !(found = (card = (Card)(lp = i$.next()).getLookup().lookup(Card.class)) != null && this.brokenCardName.equals(card.getSystemId()))) {
                }
                if (!found) {
                    toPopulate.add(new DummyProvider(this.brokenCardName));
                }
            }
            return true;
        }

        protected Node createNodeForKey(Lookup.Provider key) {
            Card card;
            Lookup l = key.getLookup();
            DataObject dob = (DataObject)l.lookup(DataObject.class);
            if (dob != null) {
                card = (Card)dob.getLookup().lookup(Card.class);
                if (card == null) {
                    card = (Card)dob.getNodeDelegate().getLookup().lookup(Card.class);
                    if (card != null) {
                        return this.brokenCardName == null ? new FilterNode(dob.getNodeDelegate()) : new FilterNode(dob.getNodeDelegate(), Children.LEAF);
                    }
                } else {
                    return this.brokenCardName == null ? new FilterNode(dob.getNodeDelegate()) : new FilterNode(dob.getNodeDelegate(), Children.LEAF);
                }
            }
            if ((card = (Card)l.lookup(Card.class)) != null) {
                return new CardNode(key);
            }
            return null;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }
}

