/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;

public final class ShareAction
extends AbstractAction
implements ContextAwareAction {
    private static ShareAction inst = null;

    private ShareAction() {
        this.putValue("Name", NbBundle.getMessage(ShareAction.class, (String)"CTL_ShareAction"));
    }

    public static synchronized ShareAction getDefault() {
        if (inst == null) {
            inst = new ShareAction();
        }
        return inst;
    }

    public static void actionPerformed(Node[] e) {
        ContextShareAction.actionPerformed(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextShareAction();
    }

    static class ContextShareAction
    extends AbstractAction
    implements Presenter.Popup {
        public ContextShareAction() {
            this.putValue("Name", NbBundle.getMessage(ShareAction.class, (String)"CTL_ShareAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] n = WindowManager.getDefault().getRegistry().getActivatedNodes();
            if (n.length > 0) {
                ContextShareAction.actionPerformed(n);
            } else {
                ContextShareAction.actionPerformed(null);
            }
        }

        public static void actionPerformed(Node[] e) {
            if (e != null) {
                for (Node node : e) {
                    File file;
                    Project prj = (Project)node.getLookup().lookup(Project.class);
                    if (prj == null || VersioningSupport.getOwner((File)(file = FileUtil.toFile((FileObject)prj.getProjectDirectory()))) == null) continue;
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ShareAction.class, (String)"NameAndLicenseWizardPanelGUI.versioningNotSupported", (Object)ProjectUtils.getInformation((Project)prj).getDisplayName()));
                    return;
                }
            }
            if (Subversion.isClientAvailable((boolean)true)) {
                boolean cancelled;
                WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new NewKenaiProjectWizardIterator(e, Utilities.getPreferredKenai()));
                wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
                wizardDescriptor.setTitle(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.dialogTitle"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor);
                boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
                if (!cancelled) {
                    Set createdProjects = wizardDescriptor.getInstantiatedObjects();
                    ContextShareAction.showDashboard(createdProjects);
                }
            }
        }

        public static void showDashboard(Set<NewKenaiProjectWizardIterator.CreatedProjectInfo> projects) {
            KenaiTopComponent kenaiTc = KenaiTopComponent.findInstance();
            kenaiTc.open();
            kenaiTc.requestActive();
            DashboardImpl.getInstance().selectAndExpand(projects.iterator().next().project);
        }

        public JMenuItem getPopupPresenter() {
            final JMenuItem i = new JMenuItem(this);
            i.setVisible(true);
            Node[] n = WindowManager.getDefault().getRegistry().getActivatedNodes();
            if (n.length > 0 && n.length == 1) {
                final Project prj = (Project)n[0].getLookup().lookup(Project.class);
                if (prj == null) {
                    Logger.getLogger(ShareAction.class.getName()).fine("ShareAction: cannot find project for node " + n[0].getDisplayName());
                } else {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            String remoteLocation = (String)prj.getProjectDirectory().getAttribute("ProvidedExtensions.RemoteLocation");
                            if (KenaiProject.getNameForRepository((String)remoteLocation) != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        i.setVisible(false);
                                        ((JPopupMenu)i.getParent()).pack();
                                    }
                                });
                            }
                        }
                    });
                }
            }
            return i;
        }
    }
}

