/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.netbeans.modules.kenai.ui.treelist.AsynchronousLeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;

public class QueryNode
extends AsynchronousLeafNode<List<QueryResultHandle>>
implements PropertyChangeListener {
    private final QueryHandle query;
    private JPanel panel;
    private List<JLabel> labels = new ArrayList<JLabel>(15);
    private List<LinkButton> buttons = new ArrayList<LinkButton>(10);
    private final Object LOCK = new Object();

    public QueryNode(QueryHandle query, TreeListNode parent) {
        super(parent, query.getDisplayName());
        this.query = query;
        query.addPropertyChangeListener(this);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.query.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("queryResult".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    @Override
    public Action getDefaultAction() {
        return QueryAccessor.getDefault().getDefaultAction(this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        Object object = this.LOCK;
        synchronized (object) {
            for (JLabel lbl : this.labels) {
                lbl.setForeground(foreground);
            }
            for (LinkButton lb : this.buttons) {
                lb.setForeground(foreground, isSelected);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent createComponent(List<QueryResultHandle> data) {
        QueryAccessor accessor = QueryAccessor.getDefault();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            int col = 0;
            TreeLabel lbl = new TreeLabel(this.query.getDisplayName());
            this.labels.add(lbl);
            this.panel.add((Component)lbl, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (data.size() > 0) {
                lbl = new TreeLabel("(");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                for (int i = 0; i < data.size(); ++i) {
                    QueryResultHandle qrh = data.get(i);
                    if (qrh.getResultType() != QueryResultHandle.ResultType.NAMED_RESULT) continue;
                    LinkButton btn = new LinkButton(qrh.getText(), accessor.getOpenQueryResultAction(qrh));
                    btn.setToolTipText(qrh.getToolTipText());
                    this.buttons.add(btn);
                    this.panel.add((Component)btn, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    if (i >= data.size() - 1 || data.get(i + 1).getResultType() != QueryResultHandle.ResultType.NAMED_RESULT) continue;
                    lbl = new TreeLabel("|");
                    this.labels.add(lbl);
                    this.panel.add((Component)lbl, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                }
                lbl = new TreeLabel(")");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(col++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        return this.panel;
    }

    @Override
    protected List<QueryResultHandle> load() {
        QueryAccessor accessor = QueryAccessor.getDefault();
        return accessor.getQueryResults(this.query);
    }
}

