/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.JoinTokenListBase;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.JoinTokenListChange;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;

class MutableJoinTokenList<T extends TokenId>
extends JoinTokenList<T>
implements MutableTokenList<T> {
    static <T extends TokenId> MutableJoinTokenList<T> create(TokenListList<T> tokenListList, int etlIndex) {
        MutableJoinTokenList<T> jtl;
        if (etlIndex >= 0) {
            EmbeddedTokenList etl = (EmbeddedTokenList)tokenListList.get(etlIndex);
            int tokenListStartIndex = etlIndex - etl.joinInfo.tokenListIndex();
            jtl = new MutableJoinTokenList<T>(tokenListList, etl.joinInfo.base, tokenListStartIndex);
            jtl.setActiveTokenListIndex(etlIndex - tokenListStartIndex);
        } else {
            assert (tokenListList.size() == 0);
            jtl = new MutableJoinTokenList<T>(tokenListList, new JoinTokenListBase(0), 0);
        }
        return jtl;
    }

    MutableJoinTokenList(TokenListList<T> tokenListList, JoinTokenListBase base, int tokenListStartIndex) {
        super(tokenListList, base, tokenListStartIndex);
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbeddingUnsync(int index) {
        return this.tokenOrEmbedding(index);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    @Override
    public void replaceTokens(TokenListChange<T> change, TokenHierarchyEventInfo eventInfo, boolean modInside) {
        this.base.incrementExtraModCount();
        ((JoinTokenListChange)change).replaceTokens(eventInfo);
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int tokenIndex, int relexOffset, Object relexState) {
        throw new IllegalStateException("Should never be called");
    }

    public void setPrevActiveTokenListIndex() {
        --this.activeTokenListIndex;
        this.fetchActiveTokenListData();
    }

    @Override
    protected void updateStatus(EmbeddedTokenList<T> etl) {
        etl.embeddingContainer().updateStatusUnsync();
    }

    void moveIndexGap(int index) {
        this.base.moveIndexGap(this.tokenListList, this.tokenListStartIndex, index);
    }

    public void resetActiveAfterUpdate() {
        this.activeTokenListIndex = 0;
        this.fetchActiveTokenListData();
    }
}

