/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.openide.util.Parameters;

public final class GemRequirement
implements Comparable<GemRequirement> {
    private static final Pattern BUNDLER = Pattern.compile("\\s+\\*\\s(\\S+)\\s\\((\\S+)\\)\\s*");
    private static final Pattern STATUS = Pattern.compile("\\s*-\\s*\\[(.*)\\].*");
    private static final Pattern NAME = Pattern.compile("\\s*-\\s*\\[.*\\]\\s(\\S*).*");
    private static final Pattern VERSION = Pattern.compile(".*\\s+(\\d+[\\.\\d]*)\\s*");
    private static final Pattern OPERATOR = Pattern.compile(".*\\s(\\S+)\\s\\d+.*");
    private final Status status;
    private final String name;
    private final String version;
    private final String operator;

    public static GemRequirement fromString(String gemRequirement) {
        String[] parts = gemRequirement.split(" ");
        if (parts.length == 1) {
            return new GemRequirement(gemRequirement, "", "", Status.UNKNOWN);
        }
        assert (parts.length == 3) : "Invalid requirement " + gemRequirement;
        return new GemRequirement(parts[0], parts[2], parts[1], Status.UNKNOWN);
    }

    GemRequirement(String name, String version, String operator, Status status) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"status", (Object)((Object)status));
        this.name = name;
        this.version = version;
        this.operator = operator;
        this.status = status;
    }

    public static GemRequirement forGem(Gem gem) {
        return new GemRequirement(gem.getName(), null, null, Status.INSTALLED);
    }

    public static String[] getOperators() {
        return new String[]{">=", ">", "=", "<=", "<", "!=", "~>"};
    }

    Status getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithVersion() {
        if (this.version == null || "".equals(this.version)) {
            return this.name;
        }
        return this.name + "-" + this.version;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionRequirement() {
        if (this.version == null || this.operator == null) {
            return "";
        }
        return this.operator + " " + this.version;
    }

    public boolean satisfiedBy(String gemVersion) {
        if (this.version == null || "".equals(this.version)) {
            return true;
        }
        if ("=".equals(this.operator) && this.version.equals(gemVersion)) {
            return true;
        }
        if (">".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) > 0;
        }
        if (">=".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) >= 0;
        }
        if ("<".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) < 0;
        }
        if ("<=".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) < 1;
        }
        if ("!=".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) != 0;
        }
        if ("~>".equals(this.operator)) {
            return Util.compareVersions((String)gemVersion, (String)this.version) >= 0 && Util.compareVersions((String)gemVersion, (String)GemRequirement.bumbVersion(this.version)) < 0;
        }
        return false;
    }

    private static String bumbVersion(String version) {
        String[] ints = version.split("\\.");
        try {
            if (ints.length == 1) {
                int major = Integer.parseInt(ints[0]);
                return "" + major++;
            }
            if (ints.length > 1) {
                int minor = Integer.parseInt(ints[1]);
                ints[1] = "" + (minor + 1);
                String res = "";
                for (int i = 0; i < ints.length; ++i) {
                    res = i == 0 ? res + ints[i] : res + "." + ints[i];
                }
                return res;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return version;
        }
        return version;
    }

    public static GemRequirement parse(String line) {
        Matcher bundlerMatcher = BUNDLER.matcher(line);
        if (bundlerMatcher.matches()) {
            return new GemRequirement(bundlerMatcher.group(1), bundlerMatcher.group(2), "=", Status.UNKNOWN);
        }
        Matcher statusMatcher = STATUS.matcher(line);
        Matcher nameMatcher = NAME.matcher(line);
        Matcher versionMatcher = VERSION.matcher(line);
        Matcher operatorMatcher = OPERATOR.matcher(line);
        String status = null;
        if (nameMatcher.matches()) {
            String name = nameMatcher.group(1);
            String version = versionMatcher.matches() ? versionMatcher.group(1) : "";
            String operator = operatorMatcher.matches() ? operatorMatcher.group(1) : "";
            status = statusMatcher.matches() ? statusMatcher.group(1) : "";
            return new GemRequirement(name, version, operator, Status.statusFor(status));
        }
        return null;
    }

    String asString() {
        StringBuilder result = new StringBuilder(this.name);
        if (!GemRequirement.isEmpty(this.operator) && !GemRequirement.isEmpty(this.version)) {
            result.append(" " + this.operator);
            result.append(" " + this.version);
        }
        return result.toString();
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public String toString() {
        return GemRequirement.class.getName() + "[" + this.name + " " + this.operator + " " + this.version + " " + (Object)((Object)this.status) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GemRequirement other = (GemRequirement)obj;
        if (!(this.status == other.status || this.status != null && this.status.equals((Object)other.status))) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.status != null ? this.status.hashCode() : 0);
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 67 * hash + (this.operator != null ? this.operator.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(GemRequirement o) {
        int result = this.name.compareTo(o.name);
        if (result != 0) {
            return result;
        }
        if (this.version != null && o.version != null) {
            return this.version.compareTo(o.version);
        }
        if (this.version != null) {
            return 1;
        }
        return -1;
    }

    static enum Status {
        INSTALLED("I"),
        NOT_INSTALLED(" "),
        FROZEN("F"),
        FRAMEWORK("R"),
        UNKNOWN("unknown");

        private final String code;

        private Status(String code) {
            this.code = code;
        }

        static Status statusFor(String status) {
            for (Status each : Status.values()) {
                if (!each.code.equals(status)) continue;
                return each;
            }
            return UNKNOWN;
        }
    }
}

